/*
 * Decompiled with CFR 0.152.
 */
package org.hsql;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Properties;
import org.hsql.Database;
import org.hsql.WebServerConnection;

public class WebServer {
    static final String sServerName = "HypersonicSQL/1.0";
    static Properties pConfig;
    static String sRoot;
    static String sDefaultFile;
    static char cPathSeparatorChar;
    boolean bSilent;
    Database dDatabase;
    private ServerSocket sServer;

    public static void main(String[] stringArray) {
        WebServer webServer = new WebServer();
        webServer.run(stringArray);
    }

    private void run(String[] stringArray) {
        Object object;
        Object object2;
        ServerSocket serverSocket = null;
        try {
            object2 = new File("WebServer.properties");
            object = new FileInputStream((File)object2);
            pConfig = new Properties();
            pConfig.load((InputStream)object);
            ((FileInputStream)object).close();
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                if (string.equals("-?")) {
                    this.printHelp();
                }
                if (string.charAt(0) == '-') {
                    ((Hashtable)pConfig).put(string.substring(1), stringArray[n + 1]);
                    ++n;
                }
                ++n;
            }
            int n2 = Integer.parseInt(pConfig.getProperty("port", "80"));
            String string = pConfig.getProperty("database", "test");
            sRoot = pConfig.getProperty("root", "./");
            sDefaultFile = pConfig.getProperty("default", "index.html");
            this.bSilent = pConfig.getProperty("silent", "true").equalsIgnoreCase("true");
            serverSocket = new ServerSocket(n2);
            cPathSeparatorChar = File.separatorChar;
            this.trace("port    =" + n2);
            this.trace("database=" + string);
            this.trace("root    =" + sRoot);
            this.trace("default =" + sDefaultFile);
            this.trace("silent  =" + this.bSilent);
            this.dDatabase = new Database(string);
            System.out.println("WebServer is running");
            System.out.println("Press [Ctrl]+[C] to abort");
        }
        catch (Exception exception) {
            this.traceError("WebServer.run/init: " + exception);
            return;
        }
        try {
            while (true) {
                object2 = serverSocket.accept();
                object = new WebServerConnection((Socket)object2, this);
                ((Thread)object).start();
            }
        }
        catch (IOException iOException) {
            this.traceError("WebServer.run/loop: " + iOException.getMessage());
            return;
        }
    }

    void printHelp() {
        System.out.println("Usage: java WebServer [-options]\nwhere options include:\n    -port <nr>            port where the server is listening\n    -database <name>      name of the database\n    -root <path>          root path for sending files\n    -default <file>       default file when filename is missing\n    -silent <true/false>  false means display all queries\nThe command line arguments override the values in the properties file.");
        System.exit(0);
    }

    void trace(String string) {
        if (!this.bSilent) {
            System.out.println(string);
        }
    }

    void traceError(String string) {
        System.out.println(string);
    }
}

