/*
 * Decompiled with CFR 0.152.
 */
package org.hsql;

import java.sql.SQLException;
import java.util.Hashtable;
import org.hsql.Trace;

class Tokenizer {
    private static final int NAME = 1;
    private static final int LONG_NAME = 2;
    private static final int SPECIAL = 3;
    private static final int NUMBER = 4;
    private static final int FLOAT = 5;
    private static final int STRING = 6;
    private static final int QUOTED_IDENTIFIER = 7;
    private String sCommand;
    private int iLength;
    private Object oValue;
    private int iIndex;
    private int iType;
    private String sToken;
    private String sLongNameFirst;
    private String sLongNameLast;
    private boolean bWait;
    private static Hashtable hKeyword = new Hashtable();

    Tokenizer(String string) {
        this.sCommand = string;
        this.iLength = this.sCommand.length();
        this.iIndex = 0;
    }

    void back() throws SQLException {
        Trace.assert(!this.bWait, "back");
        this.bWait = true;
    }

    void getThis(String string) throws SQLException {
        this.getToken();
        if (!this.sToken.equals(string)) {
            throw Trace.error(1, this.sToken);
        }
    }

    String getStringToken() throws SQLException {
        this.getToken();
        if (this.iType == 6) {
            return this.sToken.substring(1).toUpperCase();
        }
        if (this.iType == 1) {
            return this.sToken;
        }
        if (this.iType == 7) {
            return this.sToken.toUpperCase();
        }
        throw Trace.error(1, this.sToken);
    }

    boolean wasValue() {
        if (this.iType == 6 || this.iType == 4 || this.iType == 5) {
            return true;
        }
        if (this.sToken.equals("NULL")) {
            return true;
        }
        return this.sToken.equals("TRUE") || this.sToken.equals("FALSE");
    }

    boolean wasLongName() {
        return this.iType == 2;
    }

    boolean wasName() {
        if (this.iType == 7) {
            return true;
        }
        if (this.iType != 1) {
            return false;
        }
        return !hKeyword.containsKey(this.sToken);
    }

    String getCurrentToken() {
        return this.sToken;
    }

    String getLongNameFirst() {
        return this.sLongNameFirst;
    }

    String getLongNameLast() {
        return this.sLongNameLast;
    }

    String getName() throws SQLException {
        this.getToken();
        if (!this.wasName()) {
            throw Trace.error(1, this.sToken);
        }
        return this.sToken;
    }

    String getString() throws SQLException {
        this.getToken();
        return this.sToken;
    }

    int getType() {
        switch (this.iType) {
            case 6: {
                return 12;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 8;
            }
        }
        return 0;
    }

    Object getAsValue() throws SQLException {
        if (!this.wasValue()) {
            throw Trace.error(1, this.sToken);
        }
        if (this.iType == 6) {
            return this.sToken.substring(1);
        }
        if (this.sToken.equals("NULL")) {
            return null;
        }
        if (this.iType == 4) {
            return new Integer(this.sToken);
        }
        if (this.iType == 5) {
            return new Double(this.sToken);
        }
        return this.sToken;
    }

    int getPosition() {
        return this.iIndex;
    }

    String getPart(int n, int n2) {
        return this.sCommand.substring(n, n2);
    }

    /*
     * Unable to fully structure code
     */
    private void getToken() throws SQLException {
        if (!this.bWait) ** GOTO lbl5
        this.bWait = false;
        return;
lbl-1000:
        // 1 sources

        {
            ++this.iIndex;
lbl5:
            // 2 sources

            ** while (this.iIndex < this.iLength && Character.isWhitespace((char)this.sCommand.charAt((int)this.iIndex)))
        }
lbl6:
        // 1 sources

        this.sToken = "";
        if (this.iIndex >= this.iLength) {
            this.iType = 0;
            return;
        }
        var1_1 = false;
        var2_2 = false;
        var3_3 = false;
        var4_4 = false;
        var5_5 = this.sCommand.charAt(this.iIndex);
        var6_6 = new StringBuffer();
        if (Character.isJavaIdentifierStart(var5_5)) {
            this.iType = 1;
        } else {
            if ("(),*=;+-/%".indexOf(var5_5) >= 0) {
                this.iType = 3;
                ++this.iIndex;
                this.sToken = String.valueOf(var5_5);
                return;
            }
            if ("!<>|".indexOf(var5_5) >= 0) {
                this.iType = 3;
            } else if (var5_5 == '\"') {
                this.iType = 7;
            } else if (var5_5 == '\'') {
                this.iType = 6;
                var6_6.append('\'');
            } else if (var5_5 == '.') {
                this.iType = 5;
                var1_1 = true;
            } else if (Character.isDigit(var5_5)) {
                this.iType = 4;
                var2_2 = true;
            } else {
                throw Trace.error(1, String.valueOf(var5_5));
            }
        }
        var7_7 = this.iIndex++;
        while (true) {
            if (this.iIndex >= this.iLength) {
                var5_5 = ' ';
                Trace.check(this.iType != 6, 12);
            } else {
                var5_5 = this.sCommand.charAt(this.iIndex);
            }
            switch (this.iType) {
                case 1: {
                    if (Character.isJavaIdentifierPart(var5_5)) break;
                    this.sToken = this.sCommand.substring(var7_7, this.iIndex).toUpperCase();
                    if (var5_5 == '.') {
                        this.sLongNameFirst = this.sToken;
                        ++this.iIndex;
                        this.getToken();
                        this.sLongNameLast = this.sToken;
                        this.iType = 2;
                        this.sToken = String.valueOf(this.sLongNameFirst) + "." + this.sLongNameLast;
                    }
                    return;
                }
                case 7: {
                    if (var5_5 == '\"') {
                        ++this.iIndex;
                        if (this.iIndex >= this.iLength) {
                            this.sToken = var6_6.toString();
                            return;
                        }
                        var5_5 = this.sCommand.charAt(this.iIndex);
                        if (var5_5 == '.') {
                            this.sLongNameFirst = var6_6.toString();
                            ++this.iIndex;
                            this.getToken();
                            this.sLongNameLast = this.sToken;
                            this.iType = 2;
                            this.sToken = String.valueOf(this.sLongNameFirst) + "." + this.sLongNameLast;
                            return;
                        }
                        if (var5_5 != '\"') {
                            this.sToken = var6_6.toString();
                            return;
                        }
                    }
                    var6_6.append(var5_5);
                    break;
                }
                case 6: {
                    if (var5_5 == '\'') {
                        ++this.iIndex;
                        if (this.iIndex >= this.iLength || this.sCommand.charAt(this.iIndex) != '\'') {
                            this.sToken = var6_6.toString();
                            return;
                        }
                    }
                    var6_6.append(var5_5);
                    break;
                }
                case 3: {
                    if (">=|".indexOf(var5_5) >= 0) break;
                    this.sToken = this.sCommand.substring(var7_7, this.iIndex);
                    return;
                }
                case 4: 
                case 5: {
                    if (Character.isDigit(var5_5)) {
                        var2_2 = true;
                        break;
                    }
                    if (var5_5 == '.') {
                        this.iType = 5;
                        if (var1_1) {
                            throw Trace.error(1, ".");
                        }
                        var1_1 = true;
                        break;
                    }
                    if (var5_5 == 'E' || var5_5 == 'e') {
                        if (var3_3) {
                            throw Trace.error(1, "E");
                        }
                        var4_4 = true;
                        var1_1 = true;
                        var3_3 = true;
                        break;
                    }
                    if (var5_5 == '-' && var4_4) {
                        var4_4 = false;
                        break;
                    }
                    if (var5_5 == '+' && var4_4) {
                        var4_4 = false;
                        break;
                    }
                    var4_4 = false;
                    if (!var2_2) {
                        if (var1_1 && var7_7 == this.iIndex - 1) {
                            this.sToken = ".";
                            return;
                        }
                        throw Trace.error(1, String.valueOf(var5_5));
                    }
                    this.sToken = this.sCommand.substring(var7_7, this.iIndex);
                    return;
                }
            }
            ++this.iIndex;
        }
    }

    static {
        String[] stringArray = new String[]{"AND", "ALL", "AVG", "BY", "BETWEEN", "CREATE", "COUNT", "DELETE", "DISTINCT", "DROP", "DISTINCT", "EXISTS", "EXCEPT", "FALSE", "FROM", "GROUP", "INSERT", "INDEX", "INTO", "IS", "IN", "INTERSECT", "INNER", "LEFT", "LIKE", "MAX", "MIN", "NULL", "NOT", "ON", "ORDER", "OR", "OUTER", "PRIMARY", "SELECT", "SET", "SUM", "TO", "TABLE", "TRUE", "UPDATE", "UNIQUE", "UNION", "VALUES", "WHERE", "LCASE", "UCASE", "LENGTH", "LEFT", "RIGHT", "IFNULL", "SUBSTRING", "BITAND", "BITOR", "CURDATE", "CURTIME", "NOW", "CASEWHEN", "CONVERT", "CONCAT", "MINUS", "UPPER", "LOWER"};
        int n = 0;
        while (n < stringArray.length) {
            hKeyword.put(stringArray[n], hKeyword);
            ++n;
        }
    }
}

