/*
 * Decompiled with CFR 0.152.
 */
package org.hsql;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import org.hsql.Row;

class Node {
    int iBalance;
    int iLeft;
    int iRight;
    int iParent;
    Node nLeft;
    Node nRight;
    Node nParent;
    private int iId;
    Node nNext;
    Row rData;

    Node(Row row, DataInput dataInput, int n) throws IOException, SQLException {
        this.iId = n;
        this.rData = row;
        this.iBalance = dataInput.readInt();
        this.iLeft = dataInput.readInt();
        this.iRight = dataInput.readInt();
        this.iParent = dataInput.readInt();
    }

    Node(Row row, int n) {
        this.iId = n;
        this.rData = row;
    }

    void delete() {
        this.iBalance = -2;
        this.nParent = null;
        this.nRight = null;
        this.nLeft = null;
        this.iParent = -1;
        this.iRight = -1;
        this.iLeft = -1;
    }

    int getKey() {
        return this.rData.iPos;
    }

    Node getLeft() throws SQLException {
        this.rData.iLastAccess = Row.iCurrentAccess++;
        if (this.nLeft == null && this.iLeft != 0) {
            this.nLeft = this.rData.getNode(this.iLeft, this.iId);
            this.nLeft.nParent = this;
        }
        return this.nLeft;
    }

    void setLeft(Node node) throws SQLException {
        this.rData.changed();
        this.nLeft = node;
        if (node == null) {
            this.iLeft = 0;
        }
    }

    Node getRight() throws SQLException {
        this.rData.iLastAccess = Row.iCurrentAccess++;
        if (this.nRight == null && this.iRight != 0) {
            this.nRight = this.rData.getNode(this.iRight, this.iId);
            this.nRight.nParent = this;
        }
        return this.nRight;
    }

    void setRight(Node node) throws SQLException {
        this.rData.changed();
        this.nRight = node;
        if (node == null) {
            this.iRight = 0;
        }
    }

    Node getParent() throws SQLException {
        this.rData.iLastAccess = Row.iCurrentAccess++;
        if (this.nParent == null && this.iParent != 0) {
            this.nParent = this.rData.getNode(this.iParent, this.iId);
            if (this.nParent.iLeft == this.rData.iPos) {
                this.nParent.nLeft = this;
            } else if (this.nParent.iRight == this.rData.iPos) {
                this.nParent.nRight = this;
            }
        }
        return this.nParent;
    }

    void setParent(Node node) throws SQLException {
        this.rData.changed();
        this.nParent = node;
        if (node == null) {
            this.iParent = 0;
        }
    }

    int getBalance() throws SQLException {
        this.rData.iLastAccess = Row.iCurrentAccess++;
        return this.iBalance;
    }

    void setBalance(int n) throws SQLException {
        if (this.iBalance != n) {
            this.rData.changed();
            this.iBalance = n;
        }
    }

    public Object[] getData() throws SQLException {
        return this.rData.getData();
    }

    boolean equals(Node node) throws SQLException {
        this.rData.iLastAccess = Row.iCurrentAccess++;
        return node == this;
    }

    void write(DataOutput dataOutput) throws IOException, SQLException {
        if (this.nLeft != null) {
            this.iLeft = this.nLeft.rData.iPos;
        }
        if (this.nRight != null) {
            this.iRight = this.nRight.rData.iPos;
        }
        if (this.nParent != null) {
            this.iParent = this.nParent.rData.iPos;
        }
        dataOutput.writeInt(this.iBalance);
        dataOutput.writeInt(this.iLeft);
        dataOutput.writeInt(this.iRight);
        dataOutput.writeInt(this.iParent);
        if (this.nNext != null) {
            this.nNext.write(dataOutput);
        }
    }

    void free() throws SQLException {
        if (this.iBalance == -2) {
            return;
        }
        int n = this.rData.iPos;
        if (this.nLeft != null) {
            this.nLeft.iParent = n;
            this.nLeft.nParent = null;
        }
        if (this.nRight != null) {
            this.nRight.iParent = n;
            this.nRight.nParent = null;
        }
        if (this.nParent != null) {
            if (this.nParent.nLeft == this) {
                this.nParent.iLeft = n;
                this.nParent.nLeft = null;
            } else {
                this.nParent.iRight = n;
                this.nParent.nRight = null;
            }
        }
        if (this.nNext != null) {
            this.nNext.free();
        }
    }
}

