/*
 * Decompiled with CFR 0.152.
 */
package org.hsql;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.hsql.Cache;
import org.hsql.Channel;
import org.hsql.Database;
import org.hsql.Index;
import org.hsql.Node;
import org.hsql.Record;
import org.hsql.Result;
import org.hsql.StringConverter;
import org.hsql.Table;
import org.hsql.Trace;

class Log {
    private static int COPYBLOCKSIZE = 65536;
    private FileInputStream fProperties;
    private Properties pProperties;
    private String sName;
    private Database dDatabase;
    private Channel cSystem;
    private FileWriter wScript;
    private String sFileProperties;
    private String sFileScript;
    private String sFileCache;
    private String sFileBackup;
    private boolean bRestoring;
    private boolean bReadOnly;
    private int iLogSize = 200;
    private int iLogCount;
    Cache cCache;

    Log(Database database, Channel channel, String string) throws SQLException {
        this.dDatabase = database;
        this.cSystem = channel;
        this.sName = string;
        this.sFileProperties = String.valueOf(this.sName) + ".properties";
        this.pProperties = new Properties();
    }

    boolean open() throws SQLException {
        if (!new File(this.sFileProperties).exists()) {
            this.create();
            this.open();
            return true;
        }
        this.loadProperties();
        this.sFileScript = this.pProperties.getProperty("script");
        this.sFileCache = this.pProperties.getProperty("data");
        this.sFileBackup = this.pProperties.getProperty("backup");
        String string = this.pProperties.getProperty("version", "1.0");
        Trace.check(string.equals(String.valueOf(1) + "." + 3), 43);
        if (this.pProperties.getProperty("readonly", "false").equals("true")) {
            this.bReadOnly = true;
            this.dDatabase.setReadOnly();
            this.cCache = new Cache(this.sFileCache);
            this.cCache.open(true);
            this.runScript();
            return false;
        }
        boolean bl = false;
        String string2 = this.pProperties.getProperty("modified", "no");
        if (string2.equals("yes-new-files")) {
            this.renameNewToCurrent(this.sFileScript);
            this.renameNewToCurrent(this.sFileBackup);
        } else if (string2.equals("yes")) {
            if (this.isAlreadyOpen()) {
                throw Trace.error(37);
            }
            this.restoreBackup();
            bl = true;
        }
        ((Hashtable)this.pProperties).put("modified", "yes");
        this.saveProperties();
        this.cCache = new Cache(this.sFileCache);
        this.cCache.open(false);
        this.runScript();
        if (bl) {
            this.close();
            ((Hashtable)this.pProperties).put("modified", "yes");
            this.saveProperties();
            this.cCache.open(false);
        }
        this.openScript();
        return false;
    }

    void close() throws SQLException {
        this.cCache.flush();
        this.closeScript();
        this.backup();
        this.writeScript();
        ((Hashtable)this.pProperties).put("modified", "yes-new-files");
        this.saveProperties();
        this.renameNewToCurrent(this.sFileScript);
        this.renameNewToCurrent(this.sFileBackup);
        ((Hashtable)this.pProperties).put("modified", "no");
        this.saveProperties();
        this.closeProperties();
    }

    void checkpoint() throws SQLException {
        this.close();
        ((Hashtable)this.pProperties).put("modified", "yes");
        this.saveProperties();
        this.cCache.open(false);
        this.openScript();
    }

    void setLogSize(int n) {
        this.iLogSize = n;
    }

    void write(String string) throws SQLException {
        if (this.bRestoring || string == null || string.equals("")) {
            return;
        }
        try {
            Log.writeLine(this.wScript, string);
            this.wScript.flush();
        }
        catch (IOException iOException) {
            Trace.error(15, this.sFileScript);
        }
        if (this.iLogSize > 0 && this.iLogCount++ > 100) {
            this.iLogCount = 0;
            if (new File(this.sFileScript).length() > (long)(this.iLogSize * 1024 * 1024)) {
                this.checkpoint();
            }
        }
    }

    void shutdown() throws SQLException {
        this.cCache.shutdown();
        this.closeScript();
        this.closeProperties();
    }

    static void scriptToFile(Database database, String string, boolean bl, Channel channel) throws SQLException {
        if (new File(string).exists()) {
            throw Trace.error(15, string);
        }
        try {
            long l = System.currentTimeMillis();
            Result result = bl ? database.getScript(false, false, false, channel) : database.getScript(false, false, true, channel);
            Record record = result.rRoot;
            FileWriter fileWriter = new FileWriter(string);
            while (record != null) {
                Log.writeLine(fileWriter, (String)record.data[0]);
                record = record.next;
            }
            Vector vector = database.getTables();
            int n = 0;
            while (n < vector.size()) {
                Table table = (Table)vector.elementAt(n);
                if (bl || !table.isCached()) {
                    Index index = table.getPrimaryIndex();
                    Node node = index.first();
                    while (node != null) {
                        Log.writeLine(fileWriter, table.getInsertStatement(node.getData()));
                        node = index.next(node);
                    }
                }
                ++n;
            }
            fileWriter.close();
            l = System.currentTimeMillis() - l;
            return;
        }
        catch (IOException iOException) {
            Trace.error(15, String.valueOf(string) + " " + iOException);
            return;
        }
    }

    private void renameNewToCurrent(String string) {
        if (new File(String.valueOf(string) + ".new").exists()) {
            new File(string).delete();
            new File(String.valueOf(string) + ".new").renameTo(new File(string));
        }
    }

    private void closeProperties() throws SQLException {
        try {
            if (this.fProperties != null) {
                this.fProperties.close();
                this.fProperties = null;
                return;
            }
        }
        catch (Exception exception) {
            throw Trace.error(15, String.valueOf(this.sFileProperties) + " " + exception);
        }
    }

    private void create() throws SQLException {
        ((Hashtable)this.pProperties).put("script", String.valueOf(this.sName) + ".script");
        ((Hashtable)this.pProperties).put("data", String.valueOf(this.sName) + ".data");
        ((Hashtable)this.pProperties).put("backup", String.valueOf(this.sName) + ".backup");
        ((Hashtable)this.pProperties).put("modified", "no");
        ((Hashtable)this.pProperties).put("version", String.valueOf(1) + "." + 3);
        this.saveProperties();
    }

    private boolean isAlreadyOpen() throws SQLException {
        this.closeProperties();
        if (!new File(this.sFileProperties).delete()) {
            return true;
        }
        this.saveProperties();
        return false;
    }

    private void loadProperties() throws SQLException {
        File file = new File(this.sFileProperties);
        this.closeProperties();
        try {
            this.fProperties = new FileInputStream(file);
            this.pProperties.load(this.fProperties);
            return;
        }
        catch (Exception exception) {
            throw Trace.error(16, this.sFileProperties);
        }
    }

    private void saveProperties() throws SQLException {
        File file = new File(this.sFileProperties);
        this.closeProperties();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.pProperties.save(fileOutputStream, "Hypersonic SQL database");
            fileOutputStream.close();
            this.loadProperties();
            return;
        }
        catch (Exception exception) {
            throw Trace.error(15, this.sFileProperties);
        }
    }

    private void backup() throws SQLException {
        if (!new File(this.sFileCache).exists()) {
            return;
        }
        try {
            int n;
            long l = System.currentTimeMillis();
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)new FileOutputStream(String.valueOf(this.sFileBackup) + ".new"), new Deflater(1), COPYBLOCKSIZE);
            byte[] byArray = new byte[COPYBLOCKSIZE];
            FileInputStream fileInputStream = new FileInputStream(this.sFileCache);
            while ((n = fileInputStream.read(byArray, 0, COPYBLOCKSIZE)) != -1) {
                deflaterOutputStream.write(byArray, 0, n);
            }
            deflaterOutputStream.close();
            fileInputStream.close();
            l = System.currentTimeMillis() - l;
            return;
        }
        catch (Exception exception) {
            throw Trace.error(15, this.sFileBackup);
        }
    }

    private void restoreBackup() throws SQLException {
        if (!new File(this.sFileBackup).exists()) {
            new File(this.sFileCache).delete();
            return;
        }
        try {
            int n;
            long l = System.currentTimeMillis();
            InflaterInputStream inflaterInputStream = new InflaterInputStream(new FileInputStream(this.sFileBackup), new Inflater());
            FileOutputStream fileOutputStream = new FileOutputStream(this.sFileCache);
            byte[] byArray = new byte[COPYBLOCKSIZE];
            while ((n = inflaterInputStream.read(byArray, 0, COPYBLOCKSIZE)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
            ((FilterInputStream)inflaterInputStream).close();
            l = System.currentTimeMillis() - l;
            return;
        }
        catch (Exception exception) {
            throw Trace.error(16, this.sFileBackup);
        }
    }

    private void openScript() throws SQLException {
        try {
            this.wScript = new FileWriter(this.sFileScript, true);
            return;
        }
        catch (Exception exception) {
            Trace.error(15, this.sFileScript);
            return;
        }
    }

    private void closeScript() throws SQLException {
        try {
            if (this.wScript != null) {
                this.wScript.close();
                this.wScript = null;
                return;
            }
        }
        catch (Exception exception) {
            Trace.error(15, this.sFileScript);
        }
    }

    private void runScript() throws SQLException {
        if (new File(this.sFileScript).exists()) {
            this.bRestoring = true;
            try {
                long l = System.currentTimeMillis();
                LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(this.sFileScript));
                while (lineNumberReader.ready()) {
                    String string = Log.readLine(lineNumberReader);
                    this.dDatabase.execute(string, this.cSystem);
                }
                lineNumberReader.close();
                l = System.currentTimeMillis() - l;
            }
            catch (IOException iOException) {
                throw Trace.error(16, String.valueOf(this.sFileScript) + " " + iOException);
            }
            this.bRestoring = false;
        }
    }

    private void writeScript() throws SQLException {
        new File(String.valueOf(this.sFileScript) + ".new").delete();
        Log.scriptToFile(this.dDatabase, String.valueOf(this.sFileScript) + ".new", false, this.cSystem);
    }

    private static void writeLine(FileWriter fileWriter, String string) throws IOException {
        string = StringConverter.unicodeToAscii(string);
        fileWriter.write(string);
        fileWriter.write("\r\n");
    }

    private static String readLine(LineNumberReader lineNumberReader) throws IOException {
        String string = lineNumberReader.readLine();
        return StringConverter.asciiToUnicode(string);
    }
}

