/*
 * Decompiled with CFR 0.152.
 */
package org.hsql;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.hsql.Column;
import org.hsql.Like;
import org.hsql.Record;
import org.hsql.Result;
import org.hsql.Select;
import org.hsql.TableFilter;
import org.hsql.Trace;

class Expression {
    static final int VALUE = 1;
    static final int COLUMN = 2;
    static final int QUERY = 3;
    static final int TRUE = 4;
    static final int VALUELIST = 5;
    static final int ASTERIX = 6;
    static final int SEQUENCE = 7;
    static final int NEGATE = 9;
    static final int ADD = 10;
    static final int SUBTRACT = 11;
    static final int MULTIPLY = 12;
    static final int DIVIDE = 14;
    static final int CONCAT = 15;
    static final int NOT = 20;
    static final int EQUAL = 21;
    static final int BIGGER_EQUAL = 22;
    static final int BIGGER = 23;
    static final int SMALLER = 24;
    static final int SMALLER_EQUAL = 25;
    static final int NOT_EQUAL = 26;
    static final int LIKE = 27;
    static final int AND = 28;
    static final int OR = 29;
    static final int IN = 30;
    static final int EXISTS = 31;
    static final int COUNT = 40;
    static final int SUM = 41;
    static final int MIN = 42;
    static final int MAX = 43;
    static final int AVG = 44;
    static final int MOD = 50;
    static final int LCASE = 51;
    static final int UCASE = 52;
    static final int LENGTH = 53;
    static final int LEFT = 54;
    static final int RIGHT = 55;
    static final int MID = 56;
    static final int CURDATE = 57;
    static final int CURTIME = 58;
    static final int NOW = 59;
    static final int IFNULL = 60;
    static final int CONVERT = 61;
    static final int CASEWHEN = 90;
    static final int BITAND = 91;
    static final int BITOR = 92;
    static final int PLUS = 100;
    static final int OPEN = 101;
    static final int CLOSE = 102;
    static final int SELECT = 103;
    static final int COMMA = 104;
    static final int SUBSTRING = 105;
    static final int STRINGCONCAT = 106;
    static final int BETWEEN = 107;
    static final int END = 108;
    private int iType;
    private Expression eArg;
    private Expression eArg2;
    private Object oData;
    private int iDataType;
    private Hashtable hList;
    private Select sSelect;
    private char cLikeEscape;
    private String sTable;
    private String sColumn;
    private TableFilter tFilter;
    private int iColumn;
    private String sAlias;
    private boolean bDescending;

    Expression(Expression expression) {
        this.iType = expression.iType;
        this.iDataType = expression.iDataType;
        this.eArg = expression.eArg;
        this.eArg2 = expression.eArg2;
        this.cLikeEscape = expression.cLikeEscape;
        this.sSelect = expression.sSelect;
    }

    Expression(Select select) {
        this.iType = 3;
        this.sSelect = select;
    }

    Expression(Vector vector) {
        this.iType = 5;
        int n = vector.size();
        this.hList = new Hashtable(n);
        int n2 = 0;
        while (n2 < n) {
            Object e = vector.elementAt(n2);
            if (e != null) {
                this.hList.put(e, this);
            }
            ++n2;
        }
    }

    Expression(int n, Expression expression, Expression expression2) {
        this.iType = n;
        this.eArg = expression;
        this.eArg2 = expression2;
    }

    Expression(String string, String string2) {
        this.sTable = string;
        if (string2 == null) {
            this.iType = 6;
            return;
        }
        this.iType = 2;
        this.sColumn = string2;
    }

    Expression(int n, Object object) {
        this.iType = 1;
        this.iDataType = n;
        this.oData = object;
    }

    void setLikeEscape(char c) {
        this.cLikeEscape = c;
    }

    void setDataType(int n) {
        this.iDataType = n;
    }

    void setTrue() {
        this.iType = 4;
    }

    boolean isAggregate() {
        return this.iType == 40 || this.iType == 43 || this.iType == 42 || this.iType == 41 || this.iType == 44;
    }

    void setDescending() {
        this.bDescending = true;
    }

    boolean isDescending() {
        return this.bDescending;
    }

    void setAlias(String string) {
        this.sAlias = string;
    }

    String getAlias() {
        if (this.sAlias != null) {
            return this.sAlias;
        }
        if (this.iType == 1) {
            return "";
        }
        if (this.iType == 2) {
            return this.sColumn;
        }
        return "";
    }

    boolean getDescending() {
        return this.bDescending;
    }

    int getType() {
        return this.iType;
    }

    int getColumnNr() {
        return this.iColumn;
    }

    Expression getArg() {
        return this.eArg;
    }

    Expression getArg2() {
        return this.eArg2;
    }

    TableFilter getFilter() {
        return this.tFilter;
    }

    void resolve(TableFilter tableFilter) throws SQLException {
        int n;
        if (this.iType == 2 && (this.sTable == null || tableFilter.getName().equals(this.sTable)) && (n = tableFilter.getTable().searchColumn(this.sColumn)) != -1) {
            Trace.check(this.tFilter == null || this.tFilter == tableFilter, 7);
            this.tFilter = tableFilter;
            this.iColumn = n;
            this.sTable = tableFilter.getName();
            this.iDataType = tableFilter.getTable().getColumnType(n);
        }
        if (this.eArg != null) {
            this.eArg.resolve(tableFilter);
        }
        if (this.eArg2 != null) {
            this.eArg2.resolve(tableFilter);
        }
        if (this.sSelect != null) {
            this.sSelect.resolve(tableFilter);
            this.sSelect.resolve();
        }
        if (this.iDataType != 0) {
            return;
        }
        switch (this.iType) {
            case 3: {
                this.iDataType = this.sSelect.eColumn[0].iDataType;
                return;
            }
            case 9: {
                this.iDataType = this.eArg.iDataType;
                return;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                this.iDataType = this.eArg.iDataType;
                return;
            }
            case 15: {
                this.iDataType = 12;
                return;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                this.iDataType = -7;
                return;
            }
            case 40: {
                this.iDataType = 4;
                return;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                this.iDataType = this.eArg.iDataType;
                return;
            }
            case 50: 
            case 53: 
            case 91: 
            case 92: {
                this.iDataType = 4;
                return;
            }
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: {
                this.iDataType = 12;
                return;
            }
            case 57: {
                this.iDataType = 91;
                return;
            }
            case 58: {
                this.iDataType = 92;
                return;
            }
            case 59: {
                this.iDataType = 93;
                return;
            }
            case 60: 
            case 90: {
                this.iDataType = this.eArg2.iDataType;
                return;
            }
        }
    }

    boolean isResolved() {
        if (this.iType == 1) {
            return true;
        }
        if (this.iType == 2) {
            return this.tFilter != null;
        }
        return false;
    }

    static boolean isCompare(int n) {
        switch (n) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    String getTableName() {
        if (this.iType == 6) {
            return this.sTable;
        }
        if (this.iType == 2) {
            return this.tFilter.getTable().getName();
        }
        return "";
    }

    String getColumnName() {
        if (this.iType == 2) {
            return this.tFilter.getTable().getColumnName(this.iColumn);
        }
        return this.getAlias();
    }

    void swapCondition() throws SQLException {
        int n = 21;
        switch (this.iType) {
            case 22: {
                n = 25;
                break;
            }
            case 25: {
                n = 22;
                break;
            }
            case 24: {
                n = 23;
                break;
            }
            case 23: {
                n = 24;
                break;
            }
            default: {
                Trace.assert(false, "Expression.swapCondition");
            }
            case 21: 
        }
        this.iType = n;
        Expression expression = this.eArg;
        this.eArg = this.eArg2;
        this.eArg2 = expression;
    }

    Object getValue(int n) throws SQLException {
        Object object = this.getValue();
        if (object == null || this.iDataType == n) {
            return object;
        }
        String string = Column.convertObject(object);
        return Column.convertString(string, n);
    }

    int getDataType() {
        return this.iDataType;
    }

    final Object getValue() throws SQLException {
        switch (this.iType) {
            case 1: {
                return this.oData;
            }
            case 2: {
                try {
                    return this.tFilter.oCurrentData[this.iColumn];
                }
                catch (NullPointerException nullPointerException) {
                    throw Trace.error(7, this.sColumn);
                }
            }
            case 3: {
                return this.sSelect.getValue(this.iDataType);
            }
            case 9: {
                return Column.negate(this.eArg.getValue(this.iDataType), this.iDataType);
            }
            case 40: {
                if (this.eArg.iType == 6 || this.eArg.getValue() != null) {
                    return new Integer(1);
                }
                return new Integer(0);
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                return this.eArg.getValue();
            }
            case 31: {
                return new Boolean(this.test());
            }
            case 53: {
                String string = (String)this.eArg.getValue(12);
                return new Integer(string == null || string.length() < 1 ? 0 : string.length());
            }
            case 51: {
                String string = (String)this.eArg.getValue(12);
                if (string == null) {
                    return null;
                }
                return string.toLowerCase();
            }
            case 52: {
                String string = (String)this.eArg.getValue(12);
                if (string == null) {
                    return null;
                }
                return string.toUpperCase();
            }
            case 54: {
                String string = (String)this.eArg.getValue(12);
                if (string == null) {
                    return string;
                }
                int n = (Integer)this.eArg2.getValue(4);
                return string.substring(0, n < 0 ? 0 : (n < string.length() ? n : string.length()));
            }
            case 55: {
                String string = (String)this.eArg.getValue(12);
                if (string == null) {
                    return string;
                }
                int n = string.length() - (Integer)this.eArg2.getValue(4);
                if (string == null) {
                    return null;
                }
                return string.substring(n < 0 ? 0 : (n < string.length() ? n : string.length()));
            }
            case 56: {
                String string = (String)this.eArg.getValue(12);
                int n = (Integer)this.eArg2.getValue(4);
                if (string == null) {
                    return null;
                }
                return string.substring(n);
            }
            case 57: {
                return new Date(System.currentTimeMillis());
            }
            case 58: {
                return new Time(System.currentTimeMillis());
            }
            case 59: {
                return new Timestamp(System.currentTimeMillis());
            }
            case 61: {
                return this.eArg.getValue(this.iDataType);
            }
            case 90: {
                if (this.eArg.test()) {
                    return this.eArg2.eArg.getValue();
                }
                return this.eArg2.eArg2.getValue();
            }
        }
        Object object = null;
        Object object2 = null;
        if (this.eArg != null) {
            object = this.eArg.getValue(this.iDataType);
        }
        if (this.eArg2 != null) {
            object2 = this.eArg2.getValue(this.iDataType);
        }
        switch (this.iType) {
            case 10: {
                return Column.add(object, object2, this.iDataType);
            }
            case 11: {
                return Column.subtract(object, object2, this.iDataType);
            }
            case 12: {
                return Column.multiply(object, object2, this.iDataType);
            }
            case 14: {
                return Column.divide(object, object2, this.iDataType);
            }
            case 15: {
                return Column.concat(object, object2, this.iDataType);
            }
            case 50: {
                return Column.intOperation(object, object2, this.iDataType, 0);
            }
            case 91: {
                return Column.intOperation(object, object2, this.iDataType, 1);
            }
            case 92: {
                return Column.intOperation(object, object2, this.iDataType, 2);
            }
            case 60: {
                if (object == null) {
                    return object2;
                }
                return object;
            }
        }
        return new Boolean(this.test());
    }

    private boolean testValueList(String string) throws SQLException {
        if (this.iType == 5) {
            return this.hList.containsKey(string);
        }
        if (this.iType == 3) {
            Hashtable<String, Expression> hashtable = new Hashtable<String, Expression>();
            Result result = this.sSelect.getResult(0);
            Record record = result.rRoot;
            int n = result.iType[0];
            while (record != null) {
                String string2 = Column.createString(record.data[0], n);
                if (string2 != null) {
                    hashtable.put(string2, this);
                }
                record = record.next;
            }
            return hashtable.containsKey(string);
        }
        throw Trace.error(38);
    }

    boolean test() throws SQLException {
        switch (this.iType) {
            case 4: {
                return true;
            }
            case 20: {
                Trace.assert(this.eArg2 == null, "Expression.test");
                return !this.eArg.test();
            }
            case 28: {
                return this.eArg.test() && this.eArg2.test();
            }
            case 29: {
                return this.eArg.test() || this.eArg2.test();
            }
            case 27: {
                String string = (String)this.eArg2.getValue(12);
                Like like = new Like(string, this.cLikeEscape);
                String string2 = (String)this.eArg.getValue(12);
                return like.compare(string2);
            }
            case 30: {
                String string = (String)this.eArg.getValue(12);
                return this.eArg2.testValueList(string);
            }
            case 31: {
                Result result = this.eArg.sSelect.getResult(1);
                return result.rRoot != null;
            }
        }
        Object object = this.eArg.getValue();
        int n = this.eArg.iDataType;
        Object object2 = this.eArg2.getValue(n);
        int n2 = Column.compare(object, object2, n);
        switch (this.iType) {
            case 21: {
                return n2 == 0;
            }
            case 23: {
                return n2 > 0;
            }
            case 22: {
                return n2 >= 0;
            }
            case 25: {
                return n2 <= 0;
            }
            case 24: {
                return n2 < 0;
            }
            case 26: {
                return n2 != 0;
            }
        }
        Trace.assert(false, "Expression.test2");
        return false;
    }
}

