/*
 * Decompiled with CFR 0.152.
 */
package org.hsql;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsql.ByteArray;
import org.hsql.Table;
import org.hsql.Trace;

class Column {
    static boolean bIgnoreCase;
    static final int[] TYPES;
    static final int BIT = -7;
    static final int INTEGER = 4;
    static final int DOUBLE = 8;
    static final int VARCHAR = 12;
    static final int CHAR = 1;
    static final int LONGVARCHAR = -1;
    static final int DATE = 91;
    static final int TIME = 92;
    static final int DECIMAL = 3;
    static final int NULL = 0;
    static final int TINYINT = -6;
    static final int SMALLINT = 5;
    static final int BIGINT = -5;
    static final int REAL = 7;
    static final int FLOAT = 6;
    static final int NUMERIC = 2;
    static final int TIMESTAMP = 93;
    static final int BINARY = -2;
    static final int VARBINARY = -3;
    static final int LONGVARBINARY = -4;
    static final int OTHER = 1111;
    String sName;
    int iType;
    private boolean bNullable;
    private boolean bIdentity;

    Column(String string, boolean bl, int n, boolean bl2) {
        this.sName = string;
        this.bNullable = bl;
        this.iType = n;
        this.bIdentity = bl2;
    }

    boolean isIdentity() {
        return this.bIdentity;
    }

    static int getTypeNr(String string) throws SQLException {
        if (string.equals("INTEGER")) {
            return 4;
        }
        if (string.equals("INT")) {
            return 4;
        }
        if (string.equals("DOUBLE")) {
            return 8;
        }
        if (string.equals("VARCHAR")) {
            return 12;
        }
        if (string.equals("CHAR")) {
            return 1;
        }
        if (string.equals("CHARACTER")) {
            return 1;
        }
        if (string.equals("LONGVARCHAR")) {
            return -1;
        }
        if (string.equals("DATE")) {
            return 91;
        }
        if (string.equals("TIME")) {
            return 92;
        }
        if (string.equals("DECIMAL")) {
            return 3;
        }
        if (string.equals("BIT")) {
            return -7;
        }
        if (string.equals("TINYINT")) {
            return -6;
        }
        if (string.equals("SMALLINT")) {
            return 5;
        }
        if (string.equals("BIGINT")) {
            return -5;
        }
        if (string.equals("REAL")) {
            return 7;
        }
        if (string.equals("FLOAT")) {
            return 6;
        }
        if (string.equals("NUMERIC")) {
            return 2;
        }
        if (string.equals("TIMESTAMP")) {
            return 93;
        }
        if (string.equals("BINARY")) {
            return -2;
        }
        if (string.equals("VARBINARY")) {
            return -3;
        }
        if (string.equals("LONGVARBINARY")) {
            return -4;
        }
        if (string.equals("OBJECT")) {
            return 1111;
        }
        if (string.equals("DATETIME")) {
            return 93;
        }
        throw Trace.error(4, string);
    }

    static String getType(int n) throws SQLException {
        switch (n) {
            case 4: {
                return "INTEGER";
            }
            case 8: {
                return "DOUBLE";
            }
            case 12: {
                return "VARCHAR";
            }
            case 1: {
                return "CHAR";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 3: {
                return "DECIMAL";
            }
            case -7: {
                return "BIT";
            }
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case -5: {
                return "BIGINT";
            }
            case 7: {
                return "REAL";
            }
            case 6: {
                return "FLOAT";
            }
            case 2: {
                return "NUMERIC";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -2: {
                return "BINARY";
            }
            case -3: {
                return "VARBINARY";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case 1111: {
                return "OBJECT";
            }
        }
        throw Trace.error(4, n);
    }

    boolean isNullable() {
        return this.bNullable;
    }

    static Object add(Object object, Object object2, int n) throws SQLException {
        if (object == null || object2 == null) {
            return null;
        }
        switch (n) {
            case 4: {
                int n2 = (Integer)object;
                int n3 = (Integer)object2;
                return new Integer(n2 + n3);
            }
            case 6: 
            case 8: {
                double d = (Double)object;
                double d2 = (Double)object2;
                return new Double(d + d2);
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf((String)object) + (String)object2;
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                return bigDecimal.add(bigDecimal2);
            }
            case -6: 
            case 5: {
                short s = (Short)object;
                short s2 = (Short)object2;
                return new Short((short)(s + s2));
            }
            case -5: {
                long l = (Long)object;
                long l2 = (Long)object2;
                return new Long(l + l2);
            }
            case 7: {
                float f = ((Float)object).floatValue();
                float f2 = ((Float)object2).floatValue();
                return new Float(f + f2);
            }
        }
        throw Trace.error(21, n);
    }

    static Object concat(Object object, Object object2, int n) throws SQLException {
        if (object == null) {
            return object2;
        }
        if (object2 == null) {
            return object;
        }
        return String.valueOf(Column.convertObject(object)) + Column.convertObject(object2);
    }

    static Object negate(Object object, int n) throws SQLException {
        if (object == null) {
            return null;
        }
        switch (n) {
            case 4: {
                return new Integer(-((Integer)object).intValue());
            }
            case 6: 
            case 8: {
                return new Double(-((Double)object).doubleValue());
            }
            case 2: 
            case 3: {
                return ((BigDecimal)object).negate();
            }
            case -6: 
            case 5: {
                return new Short(-((Short)object).shortValue());
            }
            case -5: {
                return new Long(-((Long)object).longValue());
            }
            case 7: {
                return new Float(-((Float)object).floatValue());
            }
        }
        throw Trace.error(21, n);
    }

    static Object multiply(Object object, Object object2, int n) throws SQLException {
        if (object == null || object2 == null) {
            return null;
        }
        switch (n) {
            case 4: {
                int n2 = (Integer)object;
                int n3 = (Integer)object2;
                return new Integer(n2 * n3);
            }
            case 6: 
            case 8: {
                double d = (Double)object;
                double d2 = (Double)object2;
                return new Double(d * d2);
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                return bigDecimal.multiply(bigDecimal2);
            }
            case -6: 
            case 5: {
                short s = (Short)object;
                short s2 = (Short)object2;
                return new Short((short)(s * s2));
            }
            case -5: {
                long l = (Long)object;
                long l2 = (Long)object2;
                return new Long(l * l2);
            }
            case 7: {
                float f = ((Float)object).floatValue();
                float f2 = ((Float)object2).floatValue();
                return new Float(f * f2);
            }
        }
        throw Trace.error(21, n);
    }

    static Object divide(Object object, Object object2, int n) throws SQLException {
        if (object == null || object2 == null) {
            return null;
        }
        switch (n) {
            case 4: {
                int n2 = (Integer)object;
                int n3 = (Integer)object2;
                if (n3 == 0) {
                    return null;
                }
                return new Integer(n2 / n3);
            }
            case 6: 
            case 8: {
                double d = (Double)object;
                double d2 = (Double)object2;
                if (d2 == 0.0) {
                    return null;
                }
                return new Double(d / d2);
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                if (bigDecimal2.signum() == 0) {
                    return null;
                }
                return bigDecimal.divide(bigDecimal2, 5);
            }
            case -6: 
            case 5: {
                short s = (Short)object;
                short s2 = (Short)object2;
                if (s2 == 0) {
                    return null;
                }
                return new Short((short)(s / s2));
            }
            case -5: {
                long l = (Long)object;
                long l2 = (Long)object2;
                if (l2 == 0L) {
                    return null;
                }
                return new Long(l / l2);
            }
            case 7: {
                float f = ((Float)object).floatValue();
                float f2 = ((Float)object2).floatValue();
                if (f2 == 0.0f) {
                    return null;
                }
                return new Float(f / f2);
            }
        }
        throw Trace.error(21, n);
    }

    static Object intOperation(Object object, Object object2, int n, int n2) throws SQLException {
        Trace.assert(n == 4 && n2 >= 0 && n2 <= 2, "intOp");
        if (object == null || object2 == null) {
            return null;
        }
        int n3 = (Integer)object;
        int n4 = (Integer)object2;
        switch (n2) {
            case 0: {
                n3 %= n4;
                break;
            }
            case 1: {
                n3 &= n4;
                break;
            }
            case 2: {
                n3 |= n4;
                break;
            }
        }
        return new Integer(n3);
    }

    static Object subtract(Object object, Object object2, int n) throws SQLException {
        if (object == null || object2 == null) {
            return null;
        }
        switch (n) {
            case 4: {
                int n2 = (Integer)object;
                int n3 = (Integer)object2;
                return new Integer(n2 - n3);
            }
            case 6: 
            case 8: {
                double d = (Double)object;
                double d2 = (Double)object2;
                return new Double(d - d2);
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                return bigDecimal.subtract(bigDecimal2);
            }
            case -6: 
            case 5: {
                short s = (Short)object;
                short s2 = (Short)object2;
                return new Short((short)(s - s2));
            }
            case -5: {
                long l = (Long)object;
                long l2 = (Long)object2;
                return new Long(l - l2);
            }
            case 7: {
                float f = ((Float)object).floatValue();
                float f2 = ((Float)object2).floatValue();
                return new Float(f - f2);
            }
        }
        throw Trace.error(21, n);
    }

    static int compare(Object object, Object object2, int n) {
        int n2 = 0;
        if (object == null) {
            if (object2 == null) {
                return 0;
            }
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        switch (n) {
            case 4: {
                int n3 = (Integer)object;
                int n4 = (Integer)object2;
                n2 = n3 > n4 ? 1 : (n4 > n3 ? -1 : 0);
                break;
            }
            case 6: 
            case 8: {
                double d = (Double)object;
                double d2 = (Double)object2;
                n2 = d > d2 ? 1 : (d2 > d ? -1 : 0);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                String string = (String)object;
                String string2 = (String)object2;
                int n5 = bIgnoreCase ? string.toUpperCase().compareTo(string2.toUpperCase()) : string.compareTo(string2);
                n2 = n5 > 0 ? 1 : (n5 < 0 ? -1 : 0);
                break;
            }
            case 91: {
                Date date = (Date)object;
                Date date2 = (Date)object2;
                if (date.after(date2)) {
                    n2 = 1;
                    break;
                }
                if (!date.before(date2)) break;
                n2 = -1;
                break;
            }
            case 92: {
                Time time = (Time)object;
                Time time2 = (Time)object2;
                if (time.after(time2)) {
                    n2 = 1;
                    break;
                }
                if (!time.before(time2)) break;
                n2 = -1;
                break;
            }
            case 93: {
                Timestamp timestamp = (Timestamp)object;
                Timestamp timestamp2 = (Timestamp)object2;
                if (timestamp.after(timestamp2)) {
                    n2 = 1;
                    break;
                }
                if (!timestamp.before(timestamp2)) break;
                n2 = -1;
                break;
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                n2 = bigDecimal.compareTo(bigDecimal2);
                break;
            }
            case -7: {
                boolean bl = (Boolean)object;
                boolean bl2 = (Boolean)object2;
                n2 = bl == bl2 ? 0 : (bl2 ? -1 : 1);
                break;
            }
            case -6: 
            case 5: {
                short s = (Short)object;
                short s2 = (Short)object2;
                n2 = s > s2 ? 1 : (s2 > s ? -1 : 0);
                break;
            }
            case -5: {
                long l = (Long)object;
                long l2 = (Long)object2;
                n2 = l > l2 ? 1 : (l2 > l ? -1 : 0);
                break;
            }
            case 7: {
                float f = ((Float)object).floatValue();
                float f2 = ((Float)object2).floatValue();
                n2 = f > f2 ? 1 : (f2 > f ? -1 : 0);
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 1111: {
                n2 = ((ByteArray)object).compareTo((ByteArray)object2);
                break;
            }
        }
        return n2;
    }

    static Object convertString(String string, int n) throws SQLException {
        if (string == null) {
            return null;
        }
        switch (n) {
            case 4: {
                return new Integer(string);
            }
            case 6: 
            case 8: {
                return new Double(string);
            }
            case -1: 
            case 1: 
            case 12: {
                return string;
            }
            case 91: {
                return Date.valueOf(string);
            }
            case 92: {
                return Time.valueOf(string);
            }
            case 93: {
                return Timestamp.valueOf(string);
            }
            case 2: 
            case 3: {
                return new BigDecimal(string);
            }
            case -7: {
                return new Boolean(string);
            }
            case -6: 
            case 5: {
                return new Short(string);
            }
            case -5: {
                return new Long(string);
            }
            case 7: {
                return new Float(string);
            }
            case -4: 
            case -3: 
            case -2: 
            case 1111: {
                return new ByteArray(string);
            }
        }
        return null;
    }

    static String convertObject(Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    static Object convertObject(Object object, int n) throws SQLException {
        if (object == null) {
            return null;
        }
        return Column.convertString(object.toString(), n);
    }

    static String createString(Object object, int n) throws SQLException {
        if (object == null) {
            return "NULL";
        }
        switch (n) {
            case -4: 
            case -3: 
            case -2: 
            case 91: 
            case 92: 
            case 93: 
            case 1111: {
                return "'" + object.toString() + "'";
            }
            case -1: 
            case 1: 
            case 12: {
                return Column.createString((String)object);
            }
        }
        return object.toString();
    }

    static String createString(String string) {
        StringBuffer stringBuffer = new StringBuffer().append('\'');
        if (string != null) {
            int n = 0;
            int n2 = string.length();
            while (n < n2) {
                char c = string.charAt(n);
                if (c == '\'') {
                    stringBuffer.append(c);
                }
                stringBuffer.append(c);
                ++n;
            }
        }
        return stringBuffer.append('\'').toString();
    }

    static void writeData(DataOutput dataOutput, Object[] objectArray, Table table) throws IOException {
        int n = table.getInternalColumnCount();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = table.getType(n2);
            ++n2;
        }
        Column.writeData(dataOutput, n, nArray, objectArray);
    }

    static Object[] readData(DataInput dataInput, int n) throws IOException {
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = dataInput.readInt();
            Object object = null;
            switch (n3) {
                case 4: {
                    object = new Integer(dataInput.readInt());
                    break;
                }
                case 6: 
                case 8: {
                    object = new Double(dataInput.readDouble());
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    object = dataInput.readUTF();
                    break;
                }
                case 91: {
                    object = Date.valueOf(dataInput.readUTF());
                    break;
                }
                case 92: {
                    object = Time.valueOf(dataInput.readUTF());
                    break;
                }
                case 93: {
                    object = Timestamp.valueOf(dataInput.readUTF());
                    break;
                }
                case 2: 
                case 3: {
                    object = new BigDecimal(dataInput.readUTF());
                    break;
                }
                case -7: {
                    object = new Boolean(dataInput.readUTF());
                    break;
                }
                case -6: 
                case 5: {
                    object = new Short(dataInput.readUTF());
                    break;
                }
                case -5: {
                    object = new Long(dataInput.readUTF());
                    break;
                }
                case 7: {
                    object = new Float(dataInput.readUTF());
                    break;
                }
                case -4: 
                case -3: 
                case -2: 
                case 1111: {
                    object = new ByteArray(dataInput.readUTF());
                }
            }
            objectArray[n2] = object;
            ++n2;
        }
        return objectArray;
    }

    static void writeData(DataOutput dataOutput, int n, int[] nArray, Object[] objectArray) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object == null) {
                dataOutput.writeInt(0);
            } else {
                int n3 = nArray[n2];
                dataOutput.writeInt(n3);
                switch (n3) {
                    case 4: {
                        dataOutput.writeInt((Integer)object);
                        break;
                    }
                    case 6: 
                    case 8: {
                        dataOutput.writeDouble((Double)object);
                        break;
                    }
                    default: {
                        dataOutput.writeUTF(object.toString());
                        break;
                    }
                }
            }
            ++n2;
        }
    }

    static int getSize(Object[] objectArray, Table table) {
        int n = objectArray.length;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = table.getType(n2);
            ++n2;
        }
        return Column.getSize(objectArray, n, nArray);
    }

    static int getSize(Object[] objectArray, int n, int[] nArray) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            Object object = objectArray[n3];
            n2 += 4;
            if (object != null) {
                switch (nArray[n3]) {
                    case 4: {
                        n2 += 4;
                        break;
                    }
                    case 6: 
                    case 8: {
                        n2 += 8;
                        break;
                    }
                    default: {
                        n2 += Column.getUTFsize(object.toString());
                    }
                }
            }
            ++n3;
        }
        return n2;
    }

    static int getUTFsize(String string) {
        if (string == null) {
            string = "";
        }
        int n = string.length();
        int n2 = 2;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            n2 = c >= '\u0001' && c <= '\u007f' ? ++n2 : (c > '\u07ff' ? (n2 += 3) : (n2 += 2));
            ++n3;
        }
        return n2;
    }

    static Object sum(Object object, Object object2, int n) throws SQLException {
        if (object == null) {
            return object2;
        }
        if (object2 == null) {
            return object;
        }
        switch (n) {
            case 4: {
                return new Integer((Integer)object + (Integer)object2);
            }
            case 6: 
            case 8: {
                return new Double((Double)object + (Double)object2);
            }
            case 2: 
            case 3: {
                return ((BigDecimal)object).add((BigDecimal)object2);
            }
            case -6: 
            case 5: {
                return new Short((short)((Short)object + (Short)object2));
            }
            case -5: {
                return new Long((Long)object + (Long)object2);
            }
            case 7: {
                return new Float(((Float)object).floatValue() + ((Float)object2).floatValue());
            }
        }
        Trace.error(26);
        return null;
    }

    static Object avg(Object object, int n, int n2) throws SQLException {
        if (object == null || n2 == 0) {
            return null;
        }
        switch (n) {
            case 4: {
                return new Integer((Integer)object / n2);
            }
            case 6: 
            case 8: {
                return new Double((Double)object / (double)n2);
            }
            case 2: 
            case 3: {
                return ((BigDecimal)object).divide(new BigDecimal((double)n2), 5);
            }
            case -6: 
            case 5: {
                return new Short((short)((Short)object / n2));
            }
            case -5: {
                return new Long((Long)object / (long)n2);
            }
            case 7: {
                return new Float(((Float)object).floatValue() / (float)n2);
            }
        }
        Trace.error(26);
        return null;
    }

    static Object min(Object object, Object object2, int n) {
        if (object == null) {
            return object2;
        }
        if (object2 == null) {
            return object;
        }
        if (Column.compare(object, object2, n) < 0) {
            return object;
        }
        return object2;
    }

    static Object max(Object object, Object object2, int n) {
        if (object == null) {
            return object2;
        }
        if (object2 == null) {
            return object;
        }
        if (Column.compare(object, object2, n) > 0) {
            return object;
        }
        return object2;
    }

    static {
        TYPES = new int[]{-7, -6, -5, -4, -3, -2, -1, 1, 2, 3, 4, 5, 6, 7, 8, 12, 91, 92, 93, 1111};
    }
}

