/*
 * Decompiled with CFR 0.152.
 */
package org.hsql;

import java.sql.SQLException;
import java.util.Vector;
import org.hsql.Trace;
import org.hsql.User;

class Access {
    static final int SELECT = 1;
    static final int DELETE = 2;
    static final int INSERT = 4;
    static final int UPDATE = 8;
    static final int ALL = 15;
    private Vector uUser = new Vector();
    private User uPublic = this.createUser("PUBLIC", null, false);

    Access() throws SQLException {
    }

    static int getRight(String string) throws SQLException {
        if (string.equals("ALL")) {
            return 15;
        }
        if (string.equals("SELECT")) {
            return 1;
        }
        if (string.equals("UPDATE")) {
            return 8;
        }
        if (string.equals("DELETE")) {
            return 2;
        }
        if (string.equals("INSERT")) {
            return 4;
        }
        throw Trace.error(30, string);
    }

    static String getRight(int n) {
        if (n == 15) {
            return "ALL";
        }
        if (n == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & 1) != 0) {
            stringBuffer.append("SELECT,");
        }
        if ((n & 8) != 0) {
            stringBuffer.append("UPDATE,");
        }
        if ((n & 2) != 0) {
            stringBuffer.append("DELETE,");
        }
        if ((n & 4) != 0) {
            stringBuffer.append("INSERT,");
        }
        String string = stringBuffer.toString();
        return string.substring(0, string.length() - 1);
    }

    User createUser(String string, String string2, boolean bl) throws SQLException {
        User user;
        int n = 0;
        while (n < this.uUser.size()) {
            user = (User)this.uUser.elementAt(n);
            if (user.getName().equals(string)) {
                throw Trace.error(27, string);
            }
            ++n;
        }
        user = new User(string, string2, bl, this.uPublic);
        this.uUser.addElement(user);
        return user;
    }

    void dropUser(String string) throws SQLException {
        Trace.check(!string.equals("PUBLIC"), 29);
        int n = 0;
        while (n < this.uUser.size()) {
            User user = (User)this.uUser.elementAt(n);
            if (user.getName().equals(string)) {
                this.uUser.setElementAt(null, n);
                user.revokeAll();
                return;
            }
            ++n;
        }
        throw Trace.error(28, string);
    }

    User getUser(String string, String string2) throws SQLException {
        Trace.check(!string.equals("PUBLIC"), 29);
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        int n = this.getUser(string);
        User user = (User)this.uUser.elementAt(n);
        user.checkPassword(string2);
        return user;
    }

    void grant(String string, String string2, int n) throws SQLException {
        this.get(string).grant(string2, n);
    }

    void revoke(String string, String string2, int n) throws SQLException {
        this.get(string).revoke(string2, n);
    }

    Vector getUsers() {
        return this.uUser;
    }

    private int getUser(String string) throws SQLException {
        int n = 0;
        while (n < this.uUser.size()) {
            User user = (User)this.uUser.elementAt(n);
            if (user.getName().equals(string)) {
                return n;
            }
            ++n;
        }
        throw Trace.error(28, string);
    }

    private User get(String string) throws SQLException {
        int n = 0;
        while (n < this.uUser.size()) {
            User user = (User)this.uUser.elementAt(n);
            if (user.getName().equals(string)) {
                return user;
            }
            ++n;
        }
        throw Trace.error(28, string);
    }
}

