/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

class FindFile {
    public static void main(String[] stringArray) {
        try {
            Class.forName("org.hsql.jdbcDriver");
            Connection connection = DriverManager.getConnection("jdbc:HypersonicSQL:testfiles", "sa", "");
            if (stringArray.length == 1) {
                FindFile.listFiles(connection, stringArray[0]);
            } else if (stringArray.length == 2 && stringArray[0].equals("-init")) {
                FindFile.fillFileNames(connection, stringArray[1]);
            } else {
                System.out.println("Usage:");
                System.out.println("java FindFile -init .");
                System.out.println("  Re-create database from directory '.'");
                System.out.println("java FindFile name");
                System.out.println("  Find files like 'name'");
            }
            connection.close();
            return;
        }
        catch (Exception exception) {
            System.out.println(exception);
            return;
        }
    }

    static void listFiles(Connection connection, String string) throws SQLException {
        System.out.println("Files like '" + string + "'");
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT Path FROM Files WHERE UCASE(Path) LIKE UCASE('%" + string + "%') ESCAPE ':'");
        while (resultSet.next()) {
            System.out.println(resultSet.getString(1));
        }
        resultSet.close();
    }

    static void fillFileNames(Connection connection, String string) throws SQLException {
        System.out.println("Re-creating the database...");
        Statement statement = connection.createStatement();
        try {
            statement.executeUpdate("DROP TABLE Files");
        }
        catch (SQLException sQLException) {}
        statement.execute("CREATE TABLE Files(Path varchar(255),Name varchar(255))");
        statement.close();
        CallableStatement callableStatement = connection.prepareCall("INSERT INTO Files (Path,Name) VALUES (?,?)");
        FindFile.fillPath(string, "", callableStatement);
        callableStatement.close();
        System.out.println("Finished");
    }

    static void fillPath(String string, String string2, PreparedStatement preparedStatement) throws SQLException {
        File file = new File(string);
        if (file.isFile()) {
            preparedStatement.clearParameters();
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            preparedStatement.execute();
            return;
        }
        if (file.isDirectory()) {
            if (!string.endsWith(File.separator)) {
                string = String.valueOf(string) + File.separator;
            }
            String[] stringArray = file.list();
            int n = 0;
            while (n < stringArray.length) {
                FindFile.fillPath(String.valueOf(string) + stringArray[n], stringArray[n], preparedStatement);
                ++n;
            }
        }
    }

    FindFile() {
    }
}

