/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.MemoryImageSource;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import java.util.Vector;
import org.hsql.jdbcDriver;

public class DatabaseManager
extends Applet
implements ActionListener,
WindowListener,
ItemListener,
KeyListener {
    static final String[][] sJDBCTypes = new String[][]{{"HypersonicSQL In-Memory", "org.hsql.jdbcDriver", "jdbc:HypersonicSQL:."}, {"HypersonicSQL Standalone", "org.hsql.jdbcDriver", "jdbc:HypersonicSQL:test"}, {"HypersonicSQL Client/Server", "org.hsql.jdbcDriver", "jdbc:HypersonicSQL:http://localhost"}, {"JDBC-ODBC Brigde from Sun", "sun.jdbc.odbc.JdbcOdbcDriver", "jdbc:odbc:"}};
    String sDriverClass;
    Connection cConn;
    DatabaseMetaData dMeta;
    Statement sStatement;
    Menu mRecent;
    String[] sRecent;
    static int iMaxRecent = 24;
    int iRecent;
    TextArea txtCommand;
    Button butExecute;
    Tree tTree;
    Panel pResult;
    long lTime;
    int iResult;
    Grid gResult;
    TextArea txtResult;
    boolean bHelp;
    Frame fMain;
    Image imgEmpty;
    static Random rRandom = new Random(100L);
    Dialog dConnect;
    TextField txtDriver;
    TextField txtURL;
    TextField txtUser;
    TextField txtPassword;

    public void init() {
        DatabaseManager databaseManager = new DatabaseManager();
        databaseManager.main();
        databaseManager.connect("org.hsql.jdbcDriver", "jdbc:HypersonicSQL:.", "sa", "");
        databaseManager.insertTestData();
    }

    void insertTestData() {
        String[] stringArray = new String[]{"DROP TABLE Address", "DROP TABLE Product", "DROP TABLE Document", "DROP TABLE Position", "CREATE TABLE Address(ID INTEGER PRIMARY KEY,FirstName VARCHAR(255),LastName VARCHAR(255),Street VARCHAR(255),City VARCHAR(255))", "CREATE TABLE Product(ID INTEGER PRIMARY KEY,Name VARCHAR(255),Cost DECIMAL)", "CREATE TABLE Document(ID INTEGER PRIMARY KEY,AddressID INTEGER,Total DECIMAL)", "CREATE TABLE Position(DocumentID INTEGER,Position INTEGER,ProductID INTEGER,Quantity INTEGER,Price DECIMAL,PRIMARY KEY(DocumentID,Position))"};
        String[] stringArray2 = new String[]{"White", "Karsen", "Smith", "Ringer", "May", "King", "Fuller", "Miller", "Ott", "Sommer", "Schneider", "Steel", "Peterson", "Heiniger", "Clancy"};
        String[] stringArray3 = new String[]{"Mary", "James", "Anne", "George", "Sylvia", "Robert", "Janet", "Michael", "Andrew", "Bill", "Susanne", "Laura", "Bob", "Julia", "John"};
        String[] stringArray4 = new String[]{"Upland Pl.", "College Av.", "- 20th Ave.", "Seventh Av."};
        String[] stringArray5 = new String[]{"New York", "Dallas", "Boston", "Chicago", "Seattle", "San Fancisco", "Berne", "Oslo", "Paris", "Lyon", "Palo Alto", "Olten"};
        String[] stringArray6 = new String[]{"Iron", "Ice Tea", "Clock", "Chair", "Telephone", "Shoe"};
        try {
            int n = 0;
            while (n < stringArray.length) {
                try {
                    this.sStatement.execute(stringArray[n]);
                }
                catch (SQLException sQLException) {}
                ++n;
            }
            this.refreshTree();
            int n2 = 50;
            int n3 = 0;
            while (n3 < n2) {
                this.sStatement.execute("INSERT INTO Address VALUES(" + n3 + ",'" + DatabaseManager.random(stringArray3) + "','" + DatabaseManager.random(stringArray2) + "','" + DatabaseManager.random(554) + " " + DatabaseManager.random(stringArray4) + "','" + DatabaseManager.random(stringArray5) + "')");
                this.sStatement.execute("INSERT INTO Product VALUES(" + n3 + ",'" + DatabaseManager.random(stringArray6) + " " + DatabaseManager.random(stringArray6) + "'," + (20 + 2 * DatabaseManager.random(120)) + ")");
                this.sStatement.execute("INSERT INTO Document VALUES(" + n3 + "," + DatabaseManager.random(n2) + ",0.0)");
                int n4 = DatabaseManager.random(20) + 2;
                while (n4 >= 0) {
                    this.sStatement.execute("INSERT INTO Position VALUES(" + n3 + "," + n4 + "," + DatabaseManager.random(n2) + "," + (1 + DatabaseManager.random(24)) + ",1.5)");
                    --n4;
                }
                ++n3;
            }
            this.sStatement.execute("UPDATE Product SET Cost=Cost*.1");
            this.sStatement.execute("UPDATE Position SET Price=Price*SELECT Cost FROM Product prod WHERE ProductID=prod.ID");
            this.sStatement.execute("UPDATE Document SET Total=SELECT SUM(Price*Quantity) FROM Position WHERE DocumentID=Document.ID");
            String[] stringArray7 = new String[]{"SELECT * FROM Product", "SELECT * FROM Document", "SELECT * FROM Position", "SELECT * FROM Address a\nINNER JOIN Document d ON a.ID=d.AddressID", "SELECT * FROM Document d\nINNER JOIN Position p ON d.ID=p.DocumentID", "SELECT * FROM Address WHERE Street LIKE '1%' ORDER BY Lastname"};
            int n5 = 0;
            while (n5 < stringArray7.length) {
                this.addToRecent(stringArray7[n5]);
                ++n5;
            }
            this.refreshTree();
            this.txtCommand.setText("SELECT * FROM Address");
            this.execute();
            return;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return;
        }
    }

    public static String random(String[] stringArray) {
        return stringArray[DatabaseManager.random(stringArray.length)];
    }

    public static int random(int n) {
        n = rRandom.nextInt() % n;
        if (n < 0) {
            return -n;
        }
        return n;
    }

    public static void main(String[] stringArray) {
        DatabaseManager databaseManager = new DatabaseManager();
        databaseManager.main();
        databaseManager.connect();
    }

    boolean connect(String string, String string2, String string3, String string4) {
        try {
            if (this.cConn != null) {
                this.cConn.close();
            }
            this.sDriverClass = string;
            Class.forName(string).newInstance();
            this.cConn = DriverManager.getConnection(string2, string3, string4);
            this.dMeta = this.cConn.getMetaData();
            this.sStatement = this.cConn.createStatement();
        }
        catch (Exception exception) {
            System.out.println("DatabaseManager.connect: " + exception.getMessage());
            exception.printStackTrace();
            return false;
        }
        this.txtCommand.requestFocus();
        this.refreshTree();
        return true;
    }

    void connect() {
        this.dConnect = new Dialog(this.fMain, "Connect", true);
        this.dConnect.setLayout(new BorderLayout());
        Panel panel = new Panel(new GridLayout(6, 2, 10, 10));
        panel.add(this.createGrayLabel("Type:"));
        Choice choice = new Choice();
        choice.addItemListener(this);
        int n = 0;
        while (n < sJDBCTypes.length) {
            choice.add(sJDBCTypes[n][0]);
            ++n;
        }
        panel.add(choice);
        panel.add(this.createGrayLabel("Driver:"));
        this.txtDriver = new TextField("org.hsql.jdbcDriver");
        panel.add(this.txtDriver);
        panel.add(this.createGrayLabel("URL:"));
        this.txtURL = new TextField("jdbc:HypersonicSQL:.");
        panel.add(this.txtURL);
        panel.add(this.createGrayLabel("User:"));
        this.txtUser = new TextField("sa");
        panel.add(this.txtUser);
        panel.add(this.createGrayLabel("Password:"));
        this.txtPassword = new TextField("");
        this.txtPassword.setEchoChar('*');
        panel.add(this.txtPassword);
        Button button = new Button("Ok");
        button.setActionCommand("ConnectOk");
        button.addActionListener(this);
        panel.add(button);
        button = new Button("Cancel");
        button.setActionCommand("ConnectCancel");
        button.addActionListener(this);
        panel.add(button);
        this.dConnect.setLayout(new BorderLayout());
        this.dConnect.add("East", this.createGrayLabel(""));
        this.dConnect.add("West", this.createGrayLabel(""));
        this.dConnect.add("South", this.createGrayLabel(""));
        this.dConnect.add("North", this.createGrayLabel(""));
        this.dConnect.add("Center", panel);
        this.dConnect.doLayout();
        this.dConnect.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.dConnect.getSize();
        ((Component)this.dConnect).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.dConnect.show();
    }

    Label createGrayLabel(String string) {
        Label label = new Label(string);
        label.setBackground(SystemColor.control);
        return label;
    }

    void main() {
        this.fMain = new Frame("Hypersonic Database Manager");
        this.imgEmpty = this.createImage(new MemoryImageSource(2, 2, new int[16], 2, 2));
        this.fMain.setIconImage(this.imgEmpty);
        this.fMain.addWindowListener(this);
        MenuBar menuBar = new MenuBar();
        String[] stringArray = new String[]{"-Connect...", "--", "-Open Script...", "-Save Script...", "-Save Result...", "--", "-Exit"};
        this.addMenu(menuBar, "File", stringArray);
        String[] stringArray2 = new String[]{"RRefresh Tree", "--", "GResults in Grid", "TResults in Text", "--", "1Shrink Tree", "2Enlarge Tree", "3Shrink Command", "4Enlarge Command"};
        this.addMenu(menuBar, "View", stringArray2);
        String[] stringArray3 = new String[]{"SSELECT", "IINSERT", "UUPDATE", "DDELETE", "--", "-CREATE TABLE", "-DROP TABLE", "-CREATE INDEX", "-DROP INDEX", "--", "-SCRIPT", "-SHUTDOWN"};
        this.addMenu(menuBar, "Command", stringArray3);
        new Menu("Recent");
        this.mRecent = new Menu("Recent");
        menuBar.add(this.mRecent);
        String[] stringArray4 = new String[]{"-AutoCommit on", "-AutoCommit off", "OCommit", "LRollback", "--", "-Disable MaxRows", "-Set MaxRows to 100", "--", "-Logging on", "-Logging off", "--", "-Insert test data"};
        this.addMenu(menuBar, "Options", stringArray4);
        this.fMain.setMenuBar(menuBar);
        ((Component)this.fMain).setSize(640, 480);
        this.fMain.add("Center", this);
        this.initGUI();
        this.sRecent = new String[iMaxRecent];
        new jdbcDriver();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.fMain.getSize();
        ((Component)this.fMain).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.fMain.show();
        this.txtCommand.requestFocus();
    }

    void addMenu(MenuBar menuBar, String string, String[] stringArray) {
        Menu menu = new Menu(string);
        this.addMenuItems(menu, stringArray);
        menuBar.add(menu);
    }

    void addMenuItems(Menu menu, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            MenuItem menuItem = new MenuItem(stringArray[n].substring(1));
            char c = stringArray[n].charAt(0);
            if (c != '-') {
                menuItem.setShortcut(new MenuShortcut(c));
            }
            menuItem.addActionListener(this);
            menu.add(menuItem);
            ++n;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n' && keyEvent.isControlDown()) {
            keyEvent.consume();
            this.execute();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string = (String)itemEvent.getItem();
        int n = 0;
        while (n < sJDBCTypes.length) {
            if (string.equals(sJDBCTypes[n][0])) {
                ((TextComponent)this.txtDriver).setText(sJDBCTypes[n][1]);
                ((TextComponent)this.txtURL).setText(sJDBCTypes[n][2]);
            }
            ++n;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null && actionEvent.getSource() instanceof MenuItem) {
            string = ((MenuItem)actionEvent.getSource()).getLabel();
        }
        if (string.equals("Execute")) {
            this.execute();
            return;
        }
        if (string.equals("Exit")) {
            this.windowClosing(null);
            return;
        }
        if (string.equals("ConnectCancel")) {
            this.dConnect.dispose();
            return;
        }
        if (string.equals("Logging on")) {
            DriverManager.setLogStream(System.out);
            return;
        }
        if (string.equals("Logging off")) {
            DriverManager.setLogStream(null);
            return;
        }
        if (string.equals("ConnectOk")) {
            if (this.connect(this.txtDriver.getText(), this.txtURL.getText(), this.txtUser.getText(), this.txtPassword.getText())) {
                this.dConnect.dispose();
                return;
            }
        } else {
            if (string.equals("Refresh Tree")) {
                this.refreshTree();
                return;
            }
            if (string.startsWith("#")) {
                int n = Integer.parseInt(string.substring(1));
                this.txtCommand.setText(this.sRecent[n]);
                return;
            }
            if (string.equals("Connect...")) {
                this.connect();
                return;
            }
            if (string.equals("Results in Grid")) {
                this.iResult = 0;
                this.pResult.removeAll();
                this.pResult.add("Center", this.gResult);
                this.pResult.doLayout();
                return;
            }
            if (string.equals("Open Script...")) {
                FileDialog fileDialog = new FileDialog(this.fMain, "Open Script", 0);
                fileDialog.show();
                String string2 = fileDialog.getFile();
                if (string2 != null) {
                    this.txtCommand.setText(this.readFile(String.valueOf(fileDialog.getDirectory()) + string2));
                    return;
                }
            } else if (string.equals("Save Script...")) {
                FileDialog fileDialog = new FileDialog(this.fMain, "Save Script", 1);
                fileDialog.show();
                String string3 = fileDialog.getFile();
                if (string3 != null) {
                    this.writeFile(String.valueOf(fileDialog.getDirectory()) + string3, this.txtCommand.getText());
                    return;
                }
            } else if (string.equals("Save Result...")) {
                FileDialog fileDialog = new FileDialog(this.fMain, "Save Result", 1);
                fileDialog.show();
                String string4 = fileDialog.getFile();
                if (string4 != null) {
                    this.showResultInText();
                    this.writeFile(String.valueOf(fileDialog.getDirectory()) + string4, this.txtResult.getText());
                    return;
                }
            } else {
                if (string.equals("Results in Text")) {
                    this.iResult = 1;
                    this.pResult.removeAll();
                    this.pResult.add("Center", this.txtResult);
                    this.pResult.doLayout();
                    this.showResultInText();
                    return;
                }
                if (string.equals("AutoCommit on")) {
                    try {
                        this.cConn.setAutoCommit(true);
                        return;
                    }
                    catch (SQLException sQLException) {
                        return;
                    }
                }
                if (string.equals("AutoCommit off")) {
                    try {
                        this.cConn.setAutoCommit(false);
                        return;
                    }
                    catch (SQLException sQLException) {
                        return;
                    }
                }
                if (string.equals("Enlarge Tree")) {
                    Dimension dimension = this.tTree.getMinimumSize();
                    dimension.width += 20;
                    this.tTree.setMinimumSize(dimension);
                    this.fMain.pack();
                    return;
                }
                if (string.equals("Shrink Tree")) {
                    Dimension dimension = this.tTree.getMinimumSize();
                    dimension.width -= 20;
                    if (dimension.width >= 0) {
                        this.tTree.setMinimumSize(dimension);
                    }
                    this.fMain.pack();
                    return;
                }
                if (string.equals("Enlarge Command")) {
                    this.txtCommand.setRows(this.txtCommand.getRows() + 1);
                    this.fMain.pack();
                    return;
                }
                if (string.equals("Shrink Command")) {
                    int n = this.txtCommand.getRows() - 1;
                    this.txtCommand.setRows(n < 1 ? 1 : n);
                    this.fMain.pack();
                    return;
                }
                if (string.equals("Commit")) {
                    try {
                        this.cConn.commit();
                        return;
                    }
                    catch (SQLException sQLException) {
                        return;
                    }
                }
                if (string.equals("Insert test data")) {
                    this.insertTestData();
                    return;
                }
                if (string.equals("Rollback")) {
                    try {
                        this.cConn.rollback();
                        return;
                    }
                    catch (SQLException sQLException) {
                        return;
                    }
                }
                if (string.equals("Disable MaxRows")) {
                    try {
                        this.sStatement.setMaxRows(0);
                        return;
                    }
                    catch (SQLException sQLException) {
                        return;
                    }
                }
                if (string.equals("Set MaxRows to 100")) {
                    try {
                        this.sStatement.setMaxRows(100);
                        return;
                    }
                    catch (SQLException sQLException) {
                        return;
                    }
                }
                if (string.equals("SELECT")) {
                    this.showHelp("SELECT * FROM ", "SELECT [DISTINCT] \n{ selectExpression | table.* | * } [, ... ] \n[INTO newTable] \nFROM tableList \n[WHERE Expression] \n[ORDER BY selectExpression [{ASC | DESC}] [, ...] ] \n[GROUP BY Expression [, ...] ] \n[UNION [ALL] selectStatement]");
                    return;
                }
                if (string.equals("INSERT")) {
                    this.showHelp("INSERT INTO ", "INSERT INTO table [ (column [,...] ) ] \n{ VALUES(Expression [,...]) | SelectStatement }");
                    return;
                }
                if (string.equals("UPDATE")) {
                    this.showHelp("UPDATE ", "UPDATE table SET column = Expression [, ...] \n[WHERE Expression]");
                    return;
                }
                if (string.equals("DELETE")) {
                    this.showHelp("DELETE FROM ", "DELETE FROM table [WHERE Expression]");
                    return;
                }
                if (string.equals("CREATE TABLE")) {
                    this.showHelp("CREATE TABLE ", "CREATE TABLE name \n( columnDefinition [, ...] ) \n\ncolumnDefinition: \ncolumn DataType [ [NOT] NULL] [PRIMARY KEY] \nDataType: \n{ INTEGER | DOUBLE | VARCHAR | DATE | TIME |... }");
                    return;
                }
                if (string.equals("DROP TABLE")) {
                    this.showHelp("DROP TABLE ", "DROP TABLE table");
                    return;
                }
                if (string.equals("CREATE INDEX")) {
                    this.showHelp("CREATE INDEX ", "CREATE [UNIQUE] INDEX index ON \ntable (column [, ...])");
                    return;
                }
                if (string.equals("DROP INDEX")) {
                    this.showHelp("DROP INDEX ", "DROP INDEX table.index");
                    return;
                }
                if (string.equals("SCRIPT")) {
                    this.showHelp("SCRIPT", "SCRIPT ['file']\n\n(Hypersonic SQL only)");
                    return;
                }
                if (string.equals("SHUTDOWN")) {
                    this.showHelp("SHUTDOWN", "SHUTDOWN [IMMEDIATELY]\n\n(Hypersonic SQL only)");
                }
            }
        }
    }

    String readFile(String string) {
        try {
            int n;
            FileReader fileReader = new FileReader(string);
            char[] cArray = new char[1024];
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = fileReader.read(cArray, 0, 1024)) != -1) {
                stringBuffer.append(cArray, 0, n);
            }
            fileReader.close();
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            return iOException.getMessage();
        }
    }

    void writeFile(String string, String string2) {
        try {
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write(string2.toCharArray());
            fileWriter.close();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    void showHelp(String string, String string2) {
        this.txtCommand.setText(string);
        this.txtResult.setText(string2);
        this.bHelp = true;
        this.pResult.removeAll();
        this.pResult.add("Center", this.txtResult);
        this.pResult.doLayout();
        this.txtCommand.requestFocus();
        this.txtCommand.setCaretPosition(string.length());
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        try {
            this.cConn.close();
        }
        catch (Exception exception) {}
        this.fMain.dispose();
        System.exit(0);
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    void trace(String string) {
        System.out.println(string);
    }

    void execute() {
        String string = this.txtCommand.getText();
        String[] stringArray = new String[1];
        try {
            this.lTime = System.currentTimeMillis();
            this.sStatement.execute(string);
            this.lTime = System.currentTimeMillis() - this.lTime;
            int n = this.sStatement.getUpdateCount();
            if (n == -1) {
                this.formatResultSet(this.sStatement.getResultSet());
            } else {
                stringArray[0] = "update count";
                this.gResult.setHead(stringArray);
                stringArray[0] = String.valueOf(n);
                this.gResult.addRow(stringArray);
            }
            this.addToRecent(this.txtCommand.getText());
        }
        catch (SQLException sQLException) {
            this.lTime = System.currentTimeMillis() - this.lTime;
            stringArray[0] = "SQL Error";
            this.gResult.setHead(stringArray);
            stringArray[0] = sQLException.getMessage();
            this.gResult.addRow(stringArray);
        }
        if (this.iResult == 0) {
            if (this.bHelp) {
                this.pResult.removeAll();
                this.pResult.add("Center", this.gResult);
                this.pResult.doLayout();
                this.bHelp = false;
            }
            this.gResult.update();
            this.gResult.repaint();
        } else {
            this.showResultInText();
        }
        this.txtCommand.selectAll();
        this.txtCommand.requestFocus();
    }

    void formatResultSet(ResultSet resultSet) {
        if (resultSet == null) {
            String[] stringArray = new String[]{"Result"};
            this.gResult.setHead(stringArray);
            stringArray[0] = "(empty)";
            this.gResult.addRow(stringArray);
            return;
        }
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            String[] stringArray = new String[n];
            int n2 = 1;
            while (n2 <= n) {
                stringArray[n2 - 1] = resultSetMetaData.getColumnLabel(n2);
                ++n2;
            }
            this.gResult.setHead(stringArray);
            while (resultSet.next()) {
                int n3 = 1;
                while (n3 <= n) {
                    stringArray[n3 - 1] = resultSet.getString(n3);
                    if (resultSet.wasNull()) {
                        stringArray[n3 - 1] = "(null)";
                    }
                    ++n3;
                }
                this.gResult.addRow(stringArray);
            }
            resultSet.close();
            return;
        }
        catch (SQLException sQLException) {
            return;
        }
    }

    void showResultInText() {
        int n;
        int n2;
        int n3;
        String[] stringArray = this.gResult.getHead();
        int n4 = stringArray.length;
        Vector vector = this.gResult.getData();
        int[] nArray = new int[n4];
        int n5 = 0;
        while (n5 < n4) {
            nArray[n5] = stringArray[n5].length();
            ++n5;
        }
        int n6 = vector.size();
        int n7 = 0;
        while (n7 < n6) {
            stringArray = (String[])vector.elementAt(n7);
            int n8 = 0;
            while (n8 < n4) {
                n3 = stringArray[n8].length();
                if (n3 > nArray[n8]) {
                    nArray[n8] = n3;
                }
                ++n8;
            }
            ++n7;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringArray = this.gResult.getHead();
        n3 = 0;
        while (n3 < n4) {
            stringBuffer.append(stringArray[n3]);
            n2 = stringArray[n3].length();
            while (n2 <= nArray[n3]) {
                stringBuffer.append(' ');
                ++n2;
            }
            ++n3;
        }
        stringBuffer.append('\n');
        n2 = 0;
        while (n2 < n4) {
            n = 0;
            while (n < nArray[n2]) {
                stringBuffer.append('-');
                ++n;
            }
            stringBuffer.append(' ');
            ++n2;
        }
        stringBuffer.append('\n');
        n = 0;
        while (n < n6) {
            stringArray = (String[])vector.elementAt(n);
            int n9 = 0;
            while (n9 < n4) {
                stringBuffer.append(stringArray[n9]);
                int n10 = stringArray[n9].length();
                while (n10 <= nArray[n9]) {
                    stringBuffer.append(' ');
                    ++n10;
                }
                ++n9;
            }
            stringBuffer.append('\n');
            ++n;
        }
        stringBuffer.append("\n" + n6 + " row(s) in " + this.lTime + " ms");
        this.txtResult.setText(stringBuffer.toString());
    }

    private void addToRecent(String string) {
        int n = 0;
        while (n < iMaxRecent) {
            if (string.equals(this.sRecent[n])) {
                return;
            }
            ++n;
        }
        if (this.sRecent[this.iRecent] != null) {
            this.mRecent.remove(this.iRecent);
        }
        this.sRecent[this.iRecent] = string;
        if (string.length() > 43) {
            string = String.valueOf(string.substring(0, 40)) + "...";
        }
        MenuItem menuItem = new MenuItem(string);
        menuItem.setActionCommand("#" + this.iRecent);
        menuItem.addActionListener(this);
        this.mRecent.insert(menuItem, this.iRecent);
        this.iRecent = (this.iRecent + 1) % iMaxRecent;
    }

    private void initGUI() {
        Panel panel = new Panel();
        Panel panel2 = new Panel();
        this.pResult = new Panel();
        panel.setLayout(new BorderLayout());
        panel2.setLayout(new BorderLayout());
        this.pResult.setLayout(new BorderLayout());
        Font font = new Font("Dialog", 0, 12);
        this.txtCommand = new TextArea(5, 40);
        this.txtCommand.addKeyListener(this);
        this.txtResult = new TextArea(20, 40);
        this.txtCommand.setFont(font);
        this.txtResult.setFont(new Font("Courier", 0, 12));
        this.butExecute = new Button("Execute");
        this.butExecute.addActionListener(this);
        panel2.add("East", this.butExecute);
        panel2.add("Center", this.txtCommand);
        this.gResult = new Grid();
        this.setLayout(new BorderLayout());
        this.pResult.add("Center", this.gResult);
        panel.add("North", panel2);
        panel.add("Center", this.pResult);
        this.fMain.add("Center", panel);
        this.tTree = new Tree();
        this.tTree.setMinimumSize(new Dimension(200, 100));
        this.gResult.setMinimumSize(new Dimension(200, 300));
        this.fMain.add("West", this.tTree);
        this.doLayout();
        this.fMain.pack();
    }

    private void refreshTree() {
        this.tTree.removeAll();
        try {
            int n = Color.yellow.getRGB();
            int n2 = Color.orange.getRGB();
            int n3 = Color.red.getRGB();
            this.tTree.addRow("", this.dMeta.getURL(), "-", 0);
            String[] stringArray = new String[]{"TABLE"};
            ResultSet resultSet = this.dMeta.getTables(null, null, null, stringArray);
            Vector<String> vector = new Vector<String>();
            while (resultSet.next()) {
                vector.addElement(resultSet.getString(3));
            }
            resultSet.close();
            int n4 = 0;
            while (n4 < vector.size()) {
                String string;
                Object object;
                String string2 = (String)vector.elementAt(n4);
                String string3 = "tab-" + string2 + "-";
                this.tTree.addRow(string3, string2, "+", n);
                ResultSet resultSet2 = this.dMeta.getColumns(null, null, string2, null);
                while (resultSet2.next()) {
                    object = resultSet2.getString(4);
                    string = String.valueOf(string3) + "col-" + (String)object + "-";
                    this.tTree.addRow(string, (String)object, "+", n2);
                    String string4 = resultSet2.getString(6);
                    this.tTree.addRow(String.valueOf(string) + "t", "Type: " + string4);
                    boolean bl = resultSet2.getInt(11) != 0;
                    this.tTree.addRow(String.valueOf(string) + "n", "Nullable: " + bl);
                }
                resultSet2.close();
                this.tTree.addRow(String.valueOf(string3) + "ind", "Indices", "+", 0);
                object = this.dMeta.getIndexInfo(null, null, string2, false, false);
                string = null;
                while (object.next()) {
                    boolean bl = object.getBoolean(4);
                    String string5 = object.getString(6);
                    String string6 = String.valueOf(string3) + "ind-" + string5 + "-";
                    if (string == null || !string.equals(string5)) {
                        this.tTree.addRow(string6, string5, "+", n3);
                        this.tTree.addRow(String.valueOf(string6) + "u", "Unique: " + !bl);
                        string = string5;
                    }
                    String string7 = object.getString(9);
                    this.tTree.addRow(String.valueOf(string6) + "c-" + string7 + "-", string7);
                }
                object.close();
                ++n4;
            }
            this.tTree.addRow("p", "Properties", "+", 0);
            this.tTree.addRow("pu", "User: " + this.dMeta.getUserName());
            this.tTree.addRow("pr", "ReadOnly: " + this.cConn.isReadOnly());
            this.tTree.addRow("pa", "AutoCommit: " + this.cConn.getAutoCommit());
            this.tTree.addRow("pc", "Class: " + this.sDriverClass);
            this.tTree.addRow("pd", "Driver: " + this.dMeta.getDriverName());
            this.tTree.addRow("pp", "Product: " + this.dMeta.getDatabaseProductName());
            this.tTree.addRow("pv", "Version: " + this.dMeta.getDatabaseProductVersion());
        }
        catch (SQLException sQLException) {
            this.tTree.addRow("", "Error getting metadata:", "-", 0);
            this.tTree.addRow("-", sQLException.getMessage());
            this.tTree.addRow("-", sQLException.getSQLState());
        }
        this.tTree.update();
    }
}

