/*
 * GNU.FREE 2001
 *
 * Copyright (c) 1999, 2000, 2001 The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@thecouch.org>
 *
 * GNU site: http://www.gnu.org/software/gnu.free/gnufree.html
 * 
 * FREE e-democracy site: http://www.thecouch.org/free/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (gpl.txt); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package FreeTest;

import java.awt.*;
import java.awt.event.*;
import java.util.*;

import Free.awt.*;

public class TestFrame1 extends Frame 
{

	ScrollPane jScrollPane1 = new ScrollPane();
	TextArea jTextPane1 = new TextArea(10, 10);
	Button jButton1 = new Button();
	Button jButton2 = new Button();
	ScrollPane jScrollPane2 = new ScrollPane();
	TextArea jTextPane2 = new TextArea(10, 10);
	Label jLabel1 = new Label();
	Label jLabel2 = new Label();
	Button jButton3 = new Button();
	Button jButton4 = new Button();
	TextField jTextField1 = new TextField();
	Label jLabel3 = new Label();
	Button jButton5 = new Button();
	Button jButton6 = new Button();
	Button jButton7 = new Button();
	Button jButton8 = new Button();
	Button jButton9 = new Button();

	public TestFrame1()
	{
	}

	public Insets getInsets(){
	
		return new Insets( 20, 10, 10, 10);
	}
	
	public void initComponents() throws Exception
	{
		jScrollPane1.add(jTextPane1);
		jTextPane1.setVisible(true);
		jButton1.setLabel("Vote Boundary Tests");
		jButton2.setLabel("Vote Stamp Tests");
		jScrollPane2.add(jTextPane2);
		jLabel1.setFont( new Font("Dialog", Font.BOLD, 12));
		jLabel2.setFont( new Font("Dialog", Font.BOLD, 12));
		jLabel1.setText("Test Results");
		jLabel2.setText("Status");
		jButton3.setLabel("Vote MAC Tests");
		jButton4.setLabel("Vote Stress Test");
		jTextField1.setLocation(new java.awt.Point(390, 240));
		jLabel3.setText("No. of connections");
		jButton5.setLabel("ER Boundary Tests");
		jButton6.setLabel("ER Auth Tests");
		jButton7.setLabel("ER MAC Tests");
		jButton8.setLabel("ER Stress Test");
		jButton9.setLabel("ER AuthKey Tests");

		setLocation(new java.awt.Point(0, 0));
		setTitle("FREE: Test Suite");
		
		FreePanel scrollPanel = new FreePanel("FREE: Test Suite");
		scrollPanel.setInsets(3, 3, 3, 3);
		
		scrollPanel.addComponent( 1, 0, 1, 1, 0, 0, GridBagConstraints.NONE, 
			1.0f, 0.0f, jLabel2);
		scrollPanel.addComponent( 1, 2, 1, 1, 0, 0, GridBagConstraints.NONE, 
			1.0f, 0.0f, jLabel1);
		scrollPanel.addComponent( 2, 0, 19, 1, 0, 0, GridBagConstraints.BOTH, 
			0.4f, 1.0f, jTextPane1);
		scrollPanel.addComponent( 2, 2, 19, 1, 0, 0, GridBagConstraints.BOTH, 
			0.4f, 1.0f, jTextPane2);
			
		scrollPanel.addComponent( 3, 1, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			0.2f, 0.0f, jLabel3);
		scrollPanel.addComponent( 4, 1, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, 
			0.2f, 0.0f, jTextField1);
		scrollPanel.addComponent( 5, 1, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			0.2f, 1.0f, jButton1);
		scrollPanel.addComponent( 6, 1, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			0.2f, 1.0f, jButton2);
		scrollPanel.addComponent( 7, 1, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			0.2f, 1.0f, jButton3);
		scrollPanel.addComponent( 8, 1, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			0.2f, 1.0f, jButton4);
		scrollPanel.addComponent( 9, 1, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			0.2f, 1.0f, jButton5);
		scrollPanel.addComponent( 10, 1, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			0.2f, 1.0f, jButton6);
		scrollPanel.addComponent( 11, 1, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			0.2f, 1.0f, jButton7);
		scrollPanel.addComponent( 12, 1, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			0.2f, 1.0f, jButton8);
		scrollPanel.addComponent( 13, 1, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			0.2f, 1.0f, jButton9);
		
		FreePanel fp = new FreePanel();
		
		fp.addComponent( 1, 1, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 1.0f, scrollPanel);

		add(fp, BorderLayout.CENTER);
		setSize( 700, 500);
		
		jButton1.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton1ActionPerformed(e);
			}
		});
		jButton2.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton2ActionPerformed(e);
			}
		});
		jButton3.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton3ActionPerformed(e);
			}
		});
		jButton4.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton4ActionPerformed(e);
			}
		});
		jButton5.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton5ActionPerformed(e);
			}
		});
		jButton6.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton6ActionPerformed(e);
			}
		});
		jButton7.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton7ActionPerformed(e);
			}
		});
		jButton8.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton8ActionPerformed(e);
			}
		});
		jButton9.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton9ActionPerformed(e);
			}
		});
		addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent e) {
				thisWindowClosing(e);
			}
		});

	}
 
	// Show an informational message (black, plain text)
	protected void showInfo(String msg) {
		showMsg(msg);
	}
  
	// Show an warning message (red, bold text)
	protected void showError(String msg) {
		showMsg(msg);
	}
	
	// Show a text message using the specified AttributeSet
	protected void showMsg(String msg) {
		msg += "\n";
		jTextPane1.setText(jTextPane1.getText() + msg);
	}


	// Show an informational message (black, plain text)
	public void showInfo2(String msg) {
		showMsg2(msg);
	}
  
	// Show an warning message (red, bold text)
	public void showError2(String msg) {
		showMsg2(msg);
	}
	
	// Show a text message using the specified AttributeSet
	protected void showMsg2(String msg) {
		msg += "\n";
		jTextPane2.setText(jTextPane2.getText() + msg);
	}

	// Close the window when the close box is clicked
	void thisWindowClosing(java.awt.event.WindowEvent e)
	{
		setVisible(false);
		dispose();
		System.exit(0);
	}
	
	public void jButton1ActionPerformed(java.awt.event.ActionEvent e) {
	
		FTest.comms.isStress = false;
		Boundary.doVoteTests();
	
	}
	
	public void jButton2ActionPerformed(java.awt.event.ActionEvent e) {
	
		FTest.comms.isStress = false;
		Boundary.doStampTests();
		
	}
	
	public void jButton3ActionPerformed(java.awt.event.ActionEvent e) {
	
		FTest.comms.isStress = false;
		Boundary.doMACTests();
	
	}
	
	public void jButton4ActionPerformed(java.awt.event.ActionEvent e) {
	
		/* In this method we spin off multiple Stress classes which
		 * in turn start their own TCPClient thread to send a vote packet.
		 * Using this system we can simulate many simultaneous votes.
		 */

		int clients;
		String data;
		Integer t;

		t = new Integer(jTextField1.getText());
		clients = t.intValue();
		FTest.comms.stressClients = clients;

		Stress[] stressClients = new Stress[clients];  // array to hold threads
		
		try {
		
			showInfo2("Starting stress test...");
			showInfo2("Simulating " + clients + " clients.");

			FTest.comms.isStress = true;
			FTest.comms.stressCount = 0;

			// pre-create packet to ease processing load
			FTest.comms.setType('V');
			FTest.comms.setCheck(new Date());
			data = FTest.comms.getCheck().toString() + "-TEST";
			FTest.comms.setMessage("V|" + data + "|" + AuthSys.makeDigest(data));
		
			// initialise clients
			for (int i = 0; i < clients; i++) {
				stressClients[i] = new Stress();
			}
	
			FTest.comms.stressBefore = new Date();

			// go!
			for (int i = 0; i < clients; i++) {
				stressClients[i].start();
			}

		} catch (Exception exc) {
			FTest.frame.showError("Stress Test Error: " + exc.getMessage());
		}
	
	}
	
	public void jButton5ActionPerformed(java.awt.event.ActionEvent e) {

		FTest.comms.isStress = false;
		Boundary.doERTests();
	
	}
	
	public void jButton6ActionPerformed(java.awt.event.ActionEvent e) {
	
		FTest.comms.isStress = false;
		Boundary.doAuthTests();

	}
	
	public void jButton7ActionPerformed(java.awt.event.ActionEvent e) {
	
		FTest.comms.isStress = false;
		Boundary.doERMACTests();

	}
	
	public void jButton8ActionPerformed(java.awt.event.ActionEvent e) {

		/* In this method we spin off multiple Stress classes which
		 * in turn start their own TCPClient thread to send an Auth packet.
		 * Using this system we can simulate many simultaneous auth requests.
		 */

		int clients;
		String data;
		Integer t;

		t = new Integer(jTextField1.getText());
		clients = t.intValue();
		FTest.comms.stressClients = clients;

		Stress[] stressClients = new Stress[clients];  // array to hold threads
		
		try {
		
			showInfo2("Starting stress test...");
			showInfo2("Simulating " + clients + " clients.");

			FTest.comms.isStress = true;
			FTest.comms.stressCount = 0;

			// pre-create packet to ease processing load
			FTest.comms.setType('E');
			data = "TEST-TEST-TEST";
			FTest.comms.setMessage("E|" + data + "|" + AuthSys.makeDigest(data));
		
			// initialise clients
			for (int i = 0; i < clients; i++) {
				stressClients[i] = new Stress();
			}
	
			FTest.comms.stressBefore = new Date();

			// go!
			for (int i = 0; i < clients; i++) {
				stressClients[i].start();
			}

		} catch (Exception exc) {
			FTest.frame.showError("Stress Test Error: " + exc.getMessage());
		}
		
	}
	
	
	public void jButton9ActionPerformed(java.awt.event.ActionEvent e) {
	
		FTest.comms.isStress = false;
		Boundary.doERKeyTests();

	}
	
	
	
} //eof testframe1
