/*
 * GNU.FREE 2001
 *
 * Copyright (c) 1999, 2000, 2001 The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@thecouch.org>
 *
 * GNU site: http://www.gnu.org/software/gnu.free/gnufree.html
 * 
 * FREE e-democracy site: http://www.thecouch.org/free/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (gpl.txt); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
 
/**
 * Comms Class
 * @version 0.4 11 November 2000
 * @author Jason Kitcat
 */
 
package FreeTest;

import java.io.*;
import java.net.*;
import java.util.*;

public class Comms {

	private Thread talker;

	// constant to hold address of regional server
	protected static final String R_address = "stephenson.swingdigital.com";
	// constant to hold address of electoral roll server
	protected static final String ER_address = "gibson.swingdigital.com";
	// constant to store value being used as FREE port number
	// For security reasons I recommend this is changed regularly
	protected static final int freePort = 1111;
	
	private String fromServer;
	private Date check;
	private String message;
	private char type;
	protected int stressResult;
	protected Date stressBefore;
	protected Date stressAfter;
	protected boolean isStress;
	protected int stressClients;
	protected int stressCount;
	
	/* constructor */
	protected Comms() {
	
		// unneccessary but just in case!
		message = "";
		fromServer = "";
		stressResult = 0;
		stressClients = 0;
		stressCount = 0;
		isStress = false;
	
	}

	/* simple acessor method */
	protected void setFromServer(String x) {
	
		fromServer = x;
	
	}
	
	/* simple acessor method */
	protected String getFromServer() {
	
		return fromServer;
	
	}
	
	/* simple acessor method */
	protected Date getCheck() {
	
		return check;
	
	}
	
	/* simple acessor method */
	protected void setCheck(Date t) {
	
		check = t;
	
	}
	
	/* simple acessor method */
	protected String getMessage() {
	
		return message;
	
	}

	/* simple acessor method */
	protected void setMessage(String t) {
	
		message = t;
	
	}

	/* simple acessor method */
	protected char getType() {
	
		return type;
	
	}

	/* simple acessor method */
	protected void setType(char t) {
	
		type = t;
	
	}
	
	protected void doneStress() {

		long elapsed;

		stressAfter = new Date();

		stressCount += 1;
		elapsed = stressAfter.getTime() - stressBefore.getTime();

		FTest.frame.showInfo2("Client " + stressCount + "/" + stressClients + " has been successful.");
		FTest.frame.showInfo2("Time taken so far: " + Long.toString(elapsed) + " ms");
	}
	

	/**
	 * sendVote creates check date for security and sends vote packet
	 *
	 * @param party  String to hold voter's choice
	 */
	 protected void sendVote(String party) {	 
		
		Runnable tk = new TCPClient();
		talker = new Thread(tk);

		String reply;
		String data;
		
		check = new Date();
		data = check.toString() + "-" + party;

		try {
			
			message = "V|" + data + "|" + AuthSys.makeDigest(data);

			type = 'V';
		
	 		talker.start();

			reply = fromServer;
			
	 	} catch (Exception e) {
	 		FTest.frame.showError("sendVote IO Error: " + e.getMessage());
	 	}
	 			
	 }  //EOF sendVote


	/**
	 * sendVote2 does not create check date for security sends vote packet
	 *
	 * @param party  String to hold voter's choice
	 */
	 protected void sendVote2(String data) {	 
		
		Runnable tk = new TCPClient();
		talker = new Thread(tk);

		String reply;

		try {
			
			message = "V|" + data + "|" + AuthSys.makeDigest(data);

			type = 'V';
		
	 		talker.start();

			reply = fromServer;
			
	 	} catch (Exception e) {
	 		FTest.frame.showError("sendVote IO Error: " + e.getMessage());
	 	}
	 			
	 }  //EOF sendVote2


	/**
	 * sendVote3 creates check date for security and sends vote packet, but does not
	 * create MAC, this is supplied
	 *
	 * @param party  String to hold voter's choice
	 * @param MAC  Holds pseudo MAC to be sent
	 */
	 protected void sendVote3(String party, String MAC) {	 
		
		Runnable tk = new TCPClient();
		talker = new Thread(tk);

		String reply;
		String data;
		
		check = new Date();
		data = check.toString() + "-" + party;

		try {
			
			message = "V|" + data + "|" + MAC;

			type = 'V';
		
	 		talker.start();

			reply = fromServer;
			
	 	} catch (Exception e) {
	 		FTest.frame.showError("sendVote IO Error: " + e.getMessage());
	 	}
	 			
	 }  //EOF sendVote3


	/* IMPORTANT NOTE: sendAuth is only a demo implementation and is not secure. This
	   method will need reimplementation depending on how you want to authorise voters.
	   In later versions of FREE I hope to make this more flexible.
	 */

	/**
	 * sendAuth dispatches a packet to the ERServer for voter authentication
	 *
	 * @param data  Carries username, code and password
	 */
	protected void sendAuth(String data) {
	
		Runnable tk = new TCPClient();
		Thread talker = new Thread(tk);

		String reply;
		
		type = 'E';
		message = "E|";
			
		try {
			message = message + data + "|" + AuthSys.makeDigest(data);
		
		 	talker.start();
		 	
		 	reply = fromServer;
		 	
	 	} catch (Exception e) {
	 		FTest.frame.showError("sendDiag IO Error: " + e.getMessage());
	 	}
	
	} //EOF sendAuth
	 

	/**
	 * sendAuth2 dispatches a packet to the ERServer for voter authentication
	 *   it also doesn't calculate a MAC
	 *
	 * @param data  Carries username, code and password
	 * @param MAC  Fake MAC for insertion
	 */
	protected void sendAuth2(String data, String MAC) {
	
		Runnable tk = new TCPClient();
		Thread talker = new Thread(tk);

		String reply;
		
		type = 'E';
		message = "E|";
			
		try {
			message = message + data + "|" + MAC;
		
		 	talker.start();
		 	
		 	reply = fromServer;
		 	
	 	} catch (Exception e) {
	 		FTest.frame.showError("sendDiag IO Error: " + e.getMessage());
	 	}
	
	} //EOF sendAuth2s
	 

	/**
	 * sendKey delivers a key to an ERServer for confirming someone has voted.
	 *
	 * @param akey  The key to send
	 */
	 protected void sendKey(String akey) throws Exception {
		
		Runnable tk = new TCPClient();
		Thread talker = new Thread(tk);

		String reply;
		
		type = 'K';

		try {
			message = "K|" + akey + "|" + AuthSys.makeDigest(akey);
			
			FTest.frame.showInfo("Sending AuthKey: " + message);
			
	 		talker.start();  // start communications

		 	reply = fromServer;
		 	
	 	} catch (Exception e) {
	 		FTest.frame.showError("sendKey IO Error: " + e.getMessage());
	 	}
	 			
	 }  //EOF sendKey


	/**
	 * sendDiag dispatches any diagnostic packets
	 *
	 * @param msg  Data for packet
	 */
	 protected void sendDiag(String msg) {	 
		
		Runnable tk = new TCPClient();
		Thread talker = new Thread(tk);

		String reply;
		String data;
		
		type = 'D';
		data = "D|" + msg;
	
		try {
			message = data + "|" + AuthSys.makeDigest(msg);
		
		 	talker.start();
		 	
		 	reply = fromServer;
		 	
	 	} catch (Exception e) {
	 		FTest.frame.showError("sendDiag IO Error: " + e.getMessage());
	 	}
	 			
	 }  //EOF sendDiag

	
	
} //EOF Class