/*
 * GNU.FREE 2001
 *
 * Copyright (c) 1999, 2000, 2001 The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@thecouch.org>
 *
 * GNU site: http://www.gnu.org/software/gnu.free/gnufree.html
 * 
 * FREE e-democracy site: http://www.thecouch.org/free/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (gpl.txt); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
 
/**
 * Boundary Class
 * @version 0.2 11 November 2000
 * @author Jason Kitcat
 */
 
package FreeTest;

import java.util.*;

public class Boundary {

	private static int voteTestCount;
	private static int stampTestCount;
	private static int MACTestCount;
	private static int ERTestCount;
	private static int authTestCount;
	private static int ERMACTestCount;
	private static int ERKeyTestCount;


	/** variables to store test values */
	private static String[] testData = new String[10];
	private static String[] testData2 = new String[10];
	private static String[] testData3 = new String[10];
	private static String[] ERtestData = new String[12];
	private static String[] ERtestData2 = new String[12];
	private static String[] ERtestData3 = new String[10];
	private static String[] ERtestData4 = new String[12];
	
	/* Why do I store it in here and not a neat text file?
	 * Good question - but reading from text files isn't a
	 * platform independent operation, it is less secure and
	 * generally this is gonna be easier. ok?
	 */
	 
	
	/**
	 * Initialises the test data into the array
	 */
	protected static void setData() {

		voteTestCount = 0;	
		stampTestCount = 0;
		MACTestCount = 0;
		ERTestCount = 0;
		authTestCount = 0;
		ERMACTestCount = 0;
		ERKeyTestCount = 0;

		/* general vote boundary tests */

		// for use with sendVote
		testData[0] = "";
		testData[1] = "X";
		testData[2] = "X-X";
		testData[3] = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
		testData[4] = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX-X";
		testData[5] = "X-XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
		testData[6] = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX-XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
		testData[7] = "XXX-16/02/2000 17:12";
		testData[8] = "XXX-17:12";
		testData[9] = "XXX-16/02/2000";
		
		/* vote security stamp tests */

		// for use with sendVote2
		testData2[0] = "";
		testData2[1] = "X";
		testData2[2] = "X-X";
		testData2[3] = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
		testData2[4] = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX-X";
		testData2[5] = "X-XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
		testData2[6] = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX-XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
		testData2[7] = "XXX-16/02/2000 17:12";
		testData2[8] = "XXX-17:12";
		testData2[9] = "XXX-16/02/2000";

		/* vote MAC tests */

		// for use with sendVote3
		testData3[0] = "";
		testData3[1] = "AB2EF566A2FDGFGF";
		testData3[2] = "!@$^%$^&*(&&";
		testData3[3] = "||||";
		testData3[4] = "|FA43Q3JK";
		testData3[5] = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
		testData3[6] = "AB2EF566A2FDGFGF-AB2EF566A2FDGFGF";
		testData3[7] = "0";
		testData3[8] = "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!";
		testData3[9] = "34+88+72+98+10+26";
	
		/* general ER boundary tests */

		// for use with sendAuth
		ERtestData[0] = "";
		ERtestData[1] = "-";
		ERtestData[2] = "--";
		ERtestData[3] = "---";
		ERtestData[4] = " - - ";
		ERtestData[5] = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
		ERtestData[6] = "AB2EF566A2FDGFGF-AB2EF566A2FDGFGF";
		ERtestData[7] = "A-B-C";
		ERtestData[8] = "-B-C";
		ERtestData[9] = "A--C";
		ERtestData[10] = "A-B-";
		ERtestData[11] = "!@@$^%$^&(*^&-^";

		/* ER Auth tests */ /* NB currently same as above until DBase is done */

		// for use with sendAuth
		ERtestData2[0] = "";
		ERtestData2[1] = "-";
		ERtestData2[2] = "--";
		ERtestData2[3] = "---";
		ERtestData2[4] = " - - ";
		ERtestData2[5] = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
		ERtestData2[6] = "AB2EF566A2FDGFGF-AB2EF566A2FDGFGF";
		ERtestData2[7] = "A-B-C";
		ERtestData2[8] = "-B-C";
		ERtestData2[9] = "A--C";
		ERtestData2[10] = "A-B-";
		ERtestData2[11] = "!@@$^%$^&(*^&-^";

		/* ER MAC tests */

		// for use with sendAuth2
		ERtestData3[0] = "";
		ERtestData3[1] = "AB2EF566A2FDGFGF";
		ERtestData3[2] = "!@$^%$^&*(&&";
		ERtestData3[3] = "||||";
		ERtestData3[4] = "|FA43Q3JK";
		ERtestData3[5] = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
		ERtestData3[6] = "AB2EF566A2FDGFGF-AB2EF566A2FDGFGF";
		ERtestData3[7] = "0";
		ERtestData3[8] = "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!";
		ERtestData3[9] = "34+88+72+98+10+26";
		
		/* ER AuthKey tests */
		
		// for use with sendKey
		ERtestData4[0] = "";
		ERtestData4[1] = "AB2EF566A2FDGFGF";
		ERtestData4[2] = "!@$^%$^&*(&&";
		ERtestData4[3] = "||||";
		ERtestData4[4] = "|FA43Q3JK";
		ERtestData4[5] = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
		ERtestData4[6] = "AB2EF566A2FDGFGF-AB2EF566A2FDGFGF";
		ERtestData4[7] = "0";
		ERtestData4[8] = "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!";
		ERtestData4[9] = "34+88+72+98+10+26";
		ERtestData4[10] = "B7E4711F68AE27807D043F3E14BF4EA89D4357BE24C80E48"; // key taken from ERServer.log
		ERtestData4[11] = "FFB3FE2E96B6D1F4D1F637335FB263EAA0F3851F41E4759D3C242B030719A412"; // data taken from RTServer.keys

	} //EOF setData


	protected static void doVoteTests() {

		// set variables for profiling	
		Date before, after;
		long elapsed;
	
		/* general vote boundary tests */

		before = new Date();
		FTest.comms.sendVote(testData[voteTestCount]);
		after = new Date();
		
		elapsed = after.getTime() - before.getTime();
		FTest.frame.showInfo2("sendVote sent:");
		FTest.frame.showInfo2(testData[voteTestCount]);
		FTest.frame.showInfo2("Operation took: " + Long.toString(elapsed) + " ms");
			
		voteTestCount++;
		
		if (voteTestCount >= 10) {
			voteTestCount = 0;
		}
		
	} //EOF doVoteTests
	
	
	protected static void doStampTests() {
	
		// set variables for profiling	
		Date before, after;
		long elapsed;
	
		/* vote security stamp tests */

		before = new Date();
		FTest.comms.sendVote2(testData2[stampTestCount]);
		after = new Date();
		
		elapsed = after.getTime() - before.getTime();
		FTest.frame.showInfo2("sendVote2 sent:");
		FTest.frame.showInfo2(testData[stampTestCount]);
		FTest.frame.showInfo2("Operation took: " + Long.toString(elapsed) + " ms");
			
		stampTestCount++;
		
		if (stampTestCount >= 10) {
			stampTestCount = 0;
		}
	
	} //EOF doStampTests
	
	
	protected static void doMACTests() {
	
		// set variables for profiling	
		Date before, after;
		long elapsed;
	
		/* vote MAC tests */

		before = new Date();
		FTest.comms.sendVote3("LIBDEM",testData3[MACTestCount]);
		after = new Date();
		
		elapsed = after.getTime() - before.getTime();
		FTest.frame.showInfo2("sendVote3 sent:");
		FTest.frame.showInfo2(testData3[MACTestCount]);
		FTest.frame.showInfo2("Operation took: " + Long.toString(elapsed) + " ms");
			
		MACTestCount++;
		
		if (MACTestCount >= 10) {
			MACTestCount = 0;
		}
	
	} //EOF doMACTests


	protected static void doERTests() {

		// set variables for profiling	
		Date before, after;
		long elapsed;
	
		/* general ER boundary tests */

		before = new Date();
		FTest.comms.sendAuth(ERtestData[ERTestCount]);
		after = new Date();
		
		elapsed = after.getTime() - before.getTime();
		FTest.frame.showInfo2("sendAuth sent:");
		FTest.frame.showInfo2(ERtestData[ERTestCount]);
		FTest.frame.showInfo2("Operation took: " + Long.toString(elapsed) + " ms");
			
		ERTestCount++;
		
		if (ERTestCount >= 12) {
			ERTestCount = 0;
		}
		
	} //EOF doERTests
	
	
	protected static void doAuthTests() {
	
		// set variables for profiling	
		Date before, after;
		long elapsed;
	
		/* vote security stamp tests */

		before = new Date();
		FTest.comms.sendAuth(ERtestData2[authTestCount]);
		after = new Date();
		
		elapsed = after.getTime() - before.getTime();
		FTest.frame.showInfo2("sendAuth sent:");
		FTest.frame.showInfo2(ERtestData2[authTestCount]);
		FTest.frame.showInfo2("Operation took: " + Long.toString(elapsed) + " ms");
			
		authTestCount++;
		
		if (authTestCount >= 12) {
			authTestCount = 0;
		}
	
	} //EOF doAuthTests
	
	
	protected static void doERMACTests() {
	
		// set variables for profiling	
		Date before, after;
		long elapsed;
	
		/* vote MAC tests */

		before = new Date();
		FTest.comms.sendAuth2("test-test-test",ERtestData3[ERMACTestCount]);
		after = new Date();
		
		elapsed = after.getTime() - before.getTime();
		FTest.frame.showInfo2("sendAuth2 sent:");
		FTest.frame.showInfo2(ERtestData3[ERMACTestCount]);
		FTest.frame.showInfo2("Operation took: " + Long.toString(elapsed) + " ms");
			
		ERMACTestCount++;
		
		if (ERMACTestCount >= 10) {
			ERMACTestCount = 0;
		}
	
	} //EOF doERMACTests


	protected static void doERKeyTests() {
	
		// set variables for profiling	
		Date before, after;
		long elapsed;
	
		/* ER AuthKey tests */
		try {
			before = new Date();
			FTest.comms.sendKey(ERtestData4[ERKeyTestCount]);
			after = new Date();
		
			elapsed = after.getTime() - before.getTime();
			FTest.frame.showInfo2("sendKey sent:");
			FTest.frame.showInfo2(ERtestData4[ERMACTestCount]);
			FTest.frame.showInfo2("Operation took: " + Long.toString(elapsed) + " ms");
			
			ERKeyTestCount++;
		
			if (ERKeyTestCount >= 12) {
				ERKeyTestCount = 0;
			}
			
			} catch (Exception e) {
				FTest.frame.showError2("doERKeyTests errror: " + e.getMessage());
			}
	
	} //EOF doERKeyTests

} //EOF Class