/*
 * GNU.FREE 2001
 *
 * Copyright (c) 1999, 2000, 2001 The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@thecouch.org>
 *
 * GNU site: http://www.gnu.org/software/gnu.free/gnufree.html
 * 
 * FREE e-democracy site: http://www.thecouch.org/free/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (gpl.txt); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package FreeInstall;

import java.security.*;
import java.awt.*;
import java.io.*;
import java.util.*;
import Free.awt.*;

import org.apache.log4j.*;

 /**
  * <code>Install</code> provides a quick graphical way of customising FREE for a vote.
  *
  * Two swing frames guide the user through entering details before having the changes done.
  * Source code is backed up to .bak files while changes are made, these are only deleted
  * after successful alterations. Additionally all changes are logged to <code>FreeInstall.log</code>
  *
  * @version 0.61 27 February 2001
  * @author Jason Kitcat, Rajagopal C.V
  * @since 1.2.1
  */
public class Install {

	private static String[] installStrings;
	private static int installCounter;
	
	private static char quoteMark = '"';

	// logging categories
	protected static Category NORM;
	protected static Category DEV;

	// Swing frames
	protected static KeyInstallFrame frame5;
	protected static AuthInstallFrame frame4;
	protected static VoteInstallFrame frame3;
	protected static InstallFrame frame2;
	protected static StatusFrame frame;
	
	// Install variables
	protected static String regional_name;
	protected static String totaller_name;
	protected static String er_name;
	protected static String freePort;
	protected static String party1;
	protected static String party2;
	protected static String party3;
	protected static String party4;
	protected static String passphrase;
	protected static String secret_key1;
	protected static String secret_key2;
	protected static String MAC_key;

	public Install() {
		
	}

	// Main entry point
	static public void main(String[] args) {
	
		FreePanel.showSplash(4000);

		// init logging system
		ScreenAppender A1 = new ScreenAppender();
		PropertyConfigurator.configure("log4j.install.properties");			
		NORM = Category.getInstance("NORM");
		NORM.addAppender(A1);
		/* comment out the DEV portion to reduce log detail */
		DEV = Category.getInstance("DEV");
		DEV.addAppender(A1);

		installStrings = new String[25];
		
		installCounter = 0;
		
		try {
			frame = new StatusFrame();
			frame.initComponents();
			frame2 = new InstallFrame();
			frame2.initComponents();
			frame3 = new VoteInstallFrame();
			frame3.initComponents();
			frame4 = new AuthInstallFrame();
			frame4.initComponents();
			frame5 = new KeyInstallFrame();
			frame5.initComponents();
			frame2.setVisible(true);
		} catch (Exception e) {
			NORM.error(e.getMessage());
		}

	} //eof main
	
	


	/**
	 * Creates a key from a string input using a message digest and also
	 * a date as well as a secure random.
	 *
	 * @param skey  The password to seed the key as a string
	 * @returns  A string of the hex value of key
	 */
	 private static String buildKey(String pass) {
	 
	 	String result="";
	 
	 	try {
			String data = new Date().toString();
		
			SecureRandom sr = new SecureRandom();
			byte[] pseudoRandom = new byte[100];
			sr.nextBytes(pseudoRandom);

		 	MessageDigest md = MessageDigest.getInstance("SHA-1");
	 	
		 	byte dataBytes[] = data.getBytes();
		 	byte passBytes[] = pass.getBytes();
	 		md.update(passBytes);
		 	md.update(dataBytes);
		 	md.update(pseudoRandom);
	 		byte digest1[] = md.digest();
	 	
		 	md.update(passBytes);
		 	md.update(digest1);
	 		byte mac[] = md.digest();
	 
			/* convert to hex */
		 	StringBuffer hexString = new StringBuffer();
	 		for (int i=0;i<mac.length;i++) {
		 		hexString.append(Integer.toHexString(0xFF & mac[i]));
		 	}
	 	
		 	result = hexString.toString();
		 	
		 } catch (Exception e) {
			NORM.error("buildKey error: " + e.getMessage());
		}

	 	return result;
	 
	 } //eof buildKey


	/**
	 * checks String input to make sure it only contains safe characters.
	 * It's not pretty but regular expression packages tried all were far
	 * too slow.
	 *
	 * @param input  The String to check
	 * @returns  True if the string is ok
	 */
	 protected static boolean isSafe(String input) {
	 
	 	boolean ok = true;
	 	 
		for(int i = 0; (i<input.length())&&(ok==true); i++) {
	 
	 		switch (input.charAt(i)) {
	 			case 'a': ok = true; break;
	 			case 'b': ok = true; break;
	 			case 'c': ok = true; break;
	 			case 'd': ok = true; break;
	 			case 'e': ok = true; break;
	 			case 'f': ok = true; break;
	 			case 'g': ok = true; break;
	 			case 'h': ok = true; break;
	 			case 'i': ok = true; break;
	 			case 'j': ok = true; break;
	 			case 'k': ok = true; break;
	 			case 'l': ok = true; break;
	 			case 'm': ok = true; break;
	 			case 'n': ok = true; break;
	 			case 'o': ok = true; break;
	 			case 'p': ok = true; break;
	 			case 'q': ok = true; break;
	 			case 'r': ok = true; break;
	 			case 's': ok = true; break;
	 			case 't': ok = true; break;
	 			case 'u': ok = true; break;
	 			case 'v': ok = true; break;
	 			case 'w': ok = true; break;
	 			case 'x': ok = true; break;
	 			case 'y': ok = true; break;
	 			case 'z': ok = true; break;
	 			case 'A': ok = true; break;
	 			case 'B': ok = true; break;
	 			case 'C': ok = true; break;
	 			case 'D': ok = true; break;
	 			case 'E': ok = true; break;
	 			case 'F': ok = true; break;
	 			case 'G': ok = true; break;
	 			case 'H': ok = true; break;
	 			case 'I': ok = true; break;
	 			case 'J': ok = true; break;
	 			case 'K': ok = true; break;
	 			case 'L': ok = true; break;
	 			case 'M': ok = true; break;
	 			case 'N': ok = true; break;
	 			case 'O': ok = true; break;
	 			case 'P': ok = true; break;
	 			case 'Q': ok = true; break;
	 			case 'R': ok = true; break;
	 			case 'S': ok = true; break;
	 			case 'T': ok = true; break;
	 			case 'U': ok = true; break;
	 			case 'V': ok = true; break;
	 			case 'W': ok = true; break;
	 			case 'X': ok = true; break;
	 			case 'Y': ok = true; break;
	 			case 'Z': ok = true; break;
	 			case '1': ok = true; break;
	 			case '2': ok = true; break;
	 			case '3': ok = true; break;
	 			case '4': ok = true; break;
	 			case '5': ok = true; break;
	 			case '6': ok = true; break;
	 			case '7': ok = true; break;
	 			case '8': ok = true; break;
	 			case '9': ok = true; break;
	 			case '0': ok = true; break;
	 			case ';': ok = true; break;
	 			case ')': ok = true; break;
	 			case '(': ok = true; break;
	 			case '*': ok = true; break;
	 			case ' ': ok = true; break;
	 			case '=': ok = true; break;
	 			case '-': ok = true; break;
	 			case '_': ok = true; break;
	 			case '+': ok = true; break;
	 			case '@': ok = true; break;
	 			case ',': ok = true; break;
	 			case '.': ok = true; break;
	 			case '<': ok = true; break;
	 			case '>': ok = true; break;
	 			case '?': ok = true; break;
	 			default:  ok = false; break;
	 		} //eof case
	 		
		 } //eof for
	 
	 	return ok;
	 
	 } //eof isSafe


	/**
	 * Sets the installation strings and then processes the files.
	 *
	 */
	protected static void doInstallation() {
	
		NORM.info("FREE Install 0.4");

		NORM.info("Please wait... building keys.");
		secret_key1 = buildKey(secret_key1);
		secret_key2 = buildKey(secret_key2);
		NORM.info("Keys built.");
	
		/* FreeClient.Comms install strings */
		installStrings[0] = "protected static final String R_address = " + quoteMark + regional_name +  quoteMark + ";";
		installStrings[1] = "protected static final String ER_address = " +  quoteMark + er_name + quoteMark +  ";";
		installStrings[2] = "protected static final int freePort = " + freePort + ";";
		/* ERServer.ERServer install strings */
		installStrings[3] = "private static final int freePort = " + freePort + ";";
		/* ERServer.AuthKey install strings */
		installStrings[4] = "private static final String skey1 = " + quoteMark + secret_key1 + quoteMark + ";";
		installStrings[5] = "private static final String skey2 = " + quoteMark + secret_key2 + quoteMark + ";";
		installStrings[6] = "private static final String MACpass = " + quoteMark + MAC_key + quoteMark + ";";
		/* Free.AuthKey install strings */
		installStrings[7] = "private static final String skey1 = " + quoteMark + secret_key1 + quoteMark + ";";
		installStrings[8] = "private static final String skey2 = " + quoteMark + secret_key2 + quoteMark + ";";
		installStrings[9] = "private static final String MACpass = " + quoteMark + MAC_key + quoteMark + ";";
		/* Free.Comms install strings */
		installStrings[10] = "protected static final String T_address = " + quoteMark + totaller_name + quoteMark + ";";
		installStrings[11] = "protected static final String ER_address = " + quoteMark + er_name + quoteMark + ";";
		installStrings[12] = "protected static final int freePort = " + freePort + ";";
		/* FreeClient.VoteFrame install strings */
		installStrings[13] = "jToggleButton1.setText(" + quoteMark + party1 + quoteMark + ");";
		installStrings[14] = "jToggleButton2.setText(" + quoteMark + party2 + quoteMark + ");";
		installStrings[15] = "jToggleButton3.setText(" + quoteMark + party3 + quoteMark + ");";
		installStrings[16] = "jToggleButton4.setText(" + quoteMark + party4 + quoteMark + ");";
		installStrings[17] = "choice = " + quoteMark + party1 + quoteMark + ";";
		installStrings[18] = "choice = " + quoteMark + party2 + quoteMark + ";";
		installStrings[19] = "choice = " + quoteMark + party3 + quoteMark + ";";
		installStrings[20] = "choice = " + quoteMark + party4 + quoteMark + ";";
		/* Free.util.AuthSys install strings */
		installStrings[21] = "private static final String phrase = " + quoteMark + passphrase + quoteMark + ";";
		
		boolean t = false;
		
		t = processFile("FreeClient/Comms.java");
		t = processFile("ERServer/ERServer.java");
		t = processFile("ERServer/AuthKey.java");
		t = processFile("Free/AuthKey.java");
		t = processFile("Free/Comms.java");
		t = processFile("FreeClient/VoteFrame.java");
		t = processFile("Free/util/AuthSys.java");
		
		NORM.info("INSTALLATION COMPLETE!");
		
		frame.jButton1.setVisible(true);		
	
	} //EOF doInstallation()



	/**
	 * This code is based on <code>CodeSwitcher</code> from the Hypersonic SQL
	 * distribution.
	 *
	 * @param name	Filename to check for tags and alter
	 * @returns		Boolean of success or failure
	 */
	private static boolean processFile(String name) {
	
		File f=new File(name);
		File fnew=new File(name+".new");
		int state=0; // 0=normal 1=inside_if 2=inside_else
		boolean working=false;
		try {
			LineNumberReader read=new LineNumberReader(new FileReader(f));
			FileWriter write=new FileWriter(fnew);
			NORM.info("Opened " + name + " for editing.");
			int i=1;
			while(true) {
				String line=read.readLine();
				if(line==null) {
					break;
				}
				if(working) {
					if(line.equals("/*") || line.equals("*/")) {
						continue;
					}
				}
				if(!line.startsWith("//#")) { //if no token reprint line
					if (working) {
						write.write(installStrings[installCounter] + "\r\n");
						DEV.info("Wrote: " + installStrings[installCounter]);
						installCounter++;
						working = false;
						state = 0;
					} else {
						write.write(line+"\r\n");
					}
				} else {  //otherwise we've hit a token
					int t=0;
					if(line.startsWith("//#ifdef ")) {
						if(state!=0) {
							printError("'#ifdef' not allowed inside '#ifdef'");
							return false;
						}
						write.write(line+"\r\n");
						state=1;
						String s=line.substring(9);
						if(s.equals("INSTALL")) {
							working=true;
						}
					}
				}
			}
		
			read.close();
			write.flush();
			write.close();
			File fbak=new File(name+".bak");
			fbak.delete();
			f.renameTo(fbak);
			File fcopy=new File(name);
			fnew.renameTo(fcopy);
			fbak.delete();
			NORM.info(name + " edited successfully!");
			return true;
		} catch(Exception e) {
			printError(e.getMessage());
			return false;
		}
		
	} //EOF processFile()
	
	
	static void printError(String e) {

		NORM.error("Problem with: " + e);
  
 	} //EOF printError()


}  //EOF Install
