/*
 * GNU.FREE 2001
 *
 * Copyright (c) 1999, 2000, 2001 The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@thecouch.org>
 *
 * GNU site: http://www.gnu.org/software/gnu.free/gnufree.html
 * 
 * FREE e-democracy site: http://www.thecouch.org/free/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (gpl.txt); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package FreeClient;

import java.awt.*;
import java.awt.event.*;

import Free.awt.*;

/**
 * The main voting screen where voters pick their choice and it is sent to a server.
 *
 * @version 0.6 30 January 2001
 * @author Jason Kitcat, Rajagopal C.V

 */

public class VoteFrame extends Frame {

	private String choice;

	private final CheckboxGroup group = new CheckboxGroup();



	ScrollPane jScrollPane1 = new ScrollPane();

	TextArea jTextPane1 = new TextArea(10, 10);

	Label jLabel1 = new Label();

	

	Checkbox jToggleButton1 = new Checkbox();

	Checkbox jToggleButton2 = new Checkbox();

	Checkbox jToggleButton3 = new Checkbox();

	Checkbox jToggleButton4 = new Checkbox();

	

	Button jButton1 = new Button();

	Button jButton2 = new Button();

	Label jLabel2 = new Label();

	Button jButton3 = new Button();

	Button jButton4 = new Button();



	public Insets getInsets(){ return new Insets(30, 10, 10, 10);}



		

	protected VoteFrame() {
	
		choice = "";

		jToggleButton1.setCheckboxGroup(group);

		jToggleButton2.setCheckboxGroup(group);

		jToggleButton3.setCheckboxGroup(group);

		jToggleButton4.setCheckboxGroup(group);



		jLabel1.setText("Please make your choice:");

//#ifdef INSTALL
		jToggleButton1.setLabel("GREEN");

//#ifdef INSTALL
		jToggleButton2.setLabel("LABOUR");

//#ifdef INSTALL
		jToggleButton3.setLabel("LIB DEM");

//#ifdef INSTALL
		jToggleButton4.setLabel("TORY");

	

		jLabel2.setText("Are you sure?");

		jButton1.setLabel("Yes");

		jButton2.setLabel("No");



		jButton3.setLabel("Retry");

		jButton4.setLabel("Quit");


		FreePanel buttonPane = new FreePanel();

		buttonPane.setSize(100, 50);


		buttonPane.addComponent( 0, 0, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, 

			1.0f, 0.0f, jToggleButton1);

		buttonPane.addComponent( 0, 1, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, 

			1.0f, 0.0f, jToggleButton2);

		buttonPane.addComponent( 0, 2, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, 

			1.0f, 0.0f, jToggleButton3);

		buttonPane.addComponent( 0, 3, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, 

			1.0f, 0.0f, jToggleButton4);


		
		FreePanel scrollPanel = new FreePanel("Voting Status");

		scrollPanel.setInsets(3, 3, 3, 3);


		scrollPanel.addComponent( 0, 0, 1, 4, 0, 0, GridBagConstraints.BOTH, 

			1.0f, 1.0f, jTextPane1);

		scrollPanel.setInsets(1, 0, 1, 0);

		scrollPanel.addComponent( 1, 0, 1, 4, 0, 0, GridBagConstraints.HORIZONTAL, 

			1.0f, 0.0f, buttonPane);

		scrollPanel.setInsets(3, 3, 3, 3);

		scrollPanel.addComponent( 2, 0, 1, 1, 0, 0, GridBagConstraints.BOTH, 

			1.0f, 0.0f, jButton1);

		scrollPanel.addComponent( 2, 1, 1, 1, 0, 0, GridBagConstraints.BOTH, 

			1.0f, 0.0f, jButton2);

		scrollPanel.addComponent( 2, 2, 1, 1, 0, 0, GridBagConstraints.BOTH, 

			1.0f, 0.0f, jButton3);

		scrollPanel.addComponent( 2, 3, 1, 1, 0, 0, GridBagConstraints.BOTH, 

			1.0f, 0.0f, jButton4);



		add(scrollPanel);

		

		setTitle("FREE: Voting Screen");

		setSize(new java.awt.Dimension(460, 300));

	} //eof VoteFrame()

	

	class focusListener extends FocusAdapter {

		Color t_col = getBackground();

		public void focusGained( FocusEvent e){

				((Checkbox)e.getSource()).setBackground(Color.gray);

		}

		public void focusLost( FocusEvent e){

				((Checkbox)e.getSource()).setBackground(t_col);

		}

		

	} // eof focusListener

	

	class itemListener implements ItemListener{

		public void itemStateChanged(ItemEvent e){



			if(e.getSource() == jToggleButton1){

				jToggleButton1StateChanged(e);

			}

			else if(e.getSource() == jToggleButton2){

				

				jToggleButton2StateChanged(e);

			}

			else if(e.getSource() == jToggleButton3){



				jToggleButton3StateChanged(e);

			}

			else if(e.getSource() == jToggleButton4){



				jToggleButton4StateChanged(e);

			}

		}



	} //eof itemListener

	

	public void initComponents() throws Exception {


		jToggleButton1.addItemListener(new itemListener());

		jToggleButton1.addFocusListener(new focusListener());

		

		jToggleButton2.addItemListener(new itemListener());

		jToggleButton2.addFocusListener(new focusListener());



		jToggleButton3.addItemListener(new itemListener());

		jToggleButton3.addFocusListener(new focusListener());



		jToggleButton4.addItemListener(new itemListener());

		jToggleButton4.addFocusListener(new focusListener());



		jButton1.addActionListener(new java.awt.event.ActionListener() {

			public void actionPerformed(java.awt.event.ActionEvent e) {

				jButton1ActionPerformed(e);

			}

		});

		jButton2.addActionListener(new java.awt.event.ActionListener() {

			public void actionPerformed(java.awt.event.ActionEvent e) {

				jButton2ActionPerformed(e);

			}

		});

		jButton3.addActionListener(new java.awt.event.ActionListener() {

			public void actionPerformed(java.awt.event.ActionEvent e) {

				jButton3ActionPerformed(e);

			}

		});

		jButton4.addActionListener(new java.awt.event.ActionListener() {

			public void actionPerformed(java.awt.event.ActionEvent e) {

				jButton4ActionPerformed(e);

			}

		});

		addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent e) {
				thisWindowClosing(e);

			}

		});
		
		jButton1.setEnabled(false);
		jButton2.setEnabled(false);
		jButton3.setEnabled(false);
		jButton4.setEnabled(false);
		jLabel2.setVisible(false);

	} //eof initComponents()
	


	// Show an informational message (black, plain text)
	protected void showInfo(String msg) {

		showMsg(msg);

	}

  

	// Show an warning message (red, bold text)
	protected void showError(String msg) {

		showMsg(msg);

	}

	

	// Show a text message using the specified AttributeSet

	protected void showMsg(String msg) {

		msg += "\n";

		jTextPane1.setText(jTextPane1.getText() + msg);

	}





	// Close the window when the close box is clicked
	void thisWindowClosing(java.awt.event.WindowEvent e)

	{

	}

	

	protected void jToggleButton1StateChanged(ItemEvent e) {

//#ifdef INSTALL
		choice = "GREEN";

		jLabel2.setVisible(true);
		showInfo("Are you sure?");

		jButton1.setEnabled(true);

		jButton2.setEnabled(true);

	}

	

	protected void jToggleButton2StateChanged(ItemEvent e) {

//#ifdef INSTALL
		choice = "LABOUR";

		jLabel2.setVisible(true);
		showInfo("Are you sure?");

		jButton1.setEnabled(true);

		jButton2.setEnabled(true);

	}

	

	protected void jToggleButton3StateChanged(ItemEvent e) {

//#ifdef INSTALL
		choice = "LIB DEM";

		jLabel2.setVisible(true);
		showInfo("Are you sure?");

		jButton1.setEnabled(true);

		jButton2.setEnabled(true);

	}

	

	protected void jToggleButton4StateChanged(ItemEvent e) {

//#ifdef INSTALL
		choice = "TORY";

		jLabel2.setVisible(true);
		showInfo("Are you sure?");

		jButton1.setEnabled(true);

		jButton2.setEnabled(true);

	}

	

	protected void jButton1ActionPerformed(java.awt.event.ActionEvent e) {

		jLabel2.setVisible(false);

		jButton1.setEnabled(false);

		jButton2.setEnabled(false);

		showInfo("Sending your vote...");

		FClient.comms.sendVote(choice);

		jToggleButton1.setEnabled(false);
		jToggleButton2.setEnabled(false);
		jToggleButton3.setEnabled(false);
		jToggleButton4.setEnabled(false);

	}

	

	protected void jButton2ActionPerformed(java.awt.event.ActionEvent e) {

		jLabel2.setVisible(false);

		jButton1.setEnabled(false);

		jButton2.setEnabled(false);

		choice = "";		

	}

	

	protected void jButton3ActionPerformed(java.awt.event.ActionEvent e) {
		jButton3.setEnabled(false);
		jButton4.setEnabled(false);

		jButton1.setEnabled(false);

		jButton2.setEnabled(false);

		FClient.comms.sendVote(choice);

		showInfo("Sending your vote again...");
	}
	
	protected void jButton4ActionPerformed(java.awt.event.ActionEvent e) {

		jButton1.setEnabled(false);

		jButton2.setEnabled(false);

		setVisible(false);
		dispose();
		System.exit(0);
	}
	
	protected void voteOK() {	

		jButton1.setEnabled(false);

		jButton2.setEnabled(false);

		jButton4.setEnabled(true);

		jButton4.setEnabled(true);

		showInfo("Your vote has been registered. Thank You.\r\nClick Quit to finish.\r\n");
	}
	
	protected void voteErr() {

		jButton1.setEnabled(false);

		jButton2.setEnabled(false);

		jButton3.setEnabled(true);

		jButton4.setEnabled(true);

		showError("Sorry, it's our fault,\r\nbut there was a problem sending your vote.\r\nEither Retry or Quit.\r\nIf you do Quit you cannot try again.\r\n");

	}



	public static void main( String args[]) throws Exception{



		VoteFrame v = new VoteFrame();

		v.initComponents();

		v.setVisible(true);



	}

	

}

