/*
 * GNU.FREE 2001
 *
 * Copyright (c) 1999, 2000, 2001 The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@thecouch.org>
 *
 * GNU site: http://www.gnu.org/software/gnu.free/gnufree.html
 * 
 * FREE e-democracy site: http://www.thecouch.org/free/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (gpl.txt); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
 
package FreeClient;

import java.io.*;
import java.net.*;

/**
 * TCPClient opens connections to servers and sends/receives all data.
 *
 * While TCPClient performs all the connection-level operations and deals
 * with errors, all data is passed to <code>ClientProtocol</code> for
 * for processing.
 *
 * @version 0.8 9 February 2001
 * @author Jason Kitcat
 */
public class TCPClient implements Runnable {

	/**
	 * run() delivers a packet to the server whose DNS address is chosen.
	 * 
	 */
	public void run() {
	
		String serverName="";
		String packetMsg;
		int port;
		Socket freeSocket = null;
		PrintWriter out = null;
		BufferedReader in = null;
		
		/* get data */
		if (FClient.comms.getType()=='V') {
			serverName = FClient.comms.R_address;
		} else if (FClient.comms.getType()=='D') {
			serverName = FClient.comms.R_address;
		} else if (FClient.comms.getType()=='E') {
			serverName = FClient.comms.ER_address;
		} else {
			FClient.frame.showInfo("Unrecognised packet type");
			if (FClient.ercheck) {  // make sure we're sending errors to the right screen
				FClient.frame4.showError("Couldn't get I/O for the connection to: " + serverName);
				FClient.frame4.status=false;
				FClient.frame4.jButton1.setVisible(true);
				FClient.frame4.jButton2.setVisible(true);
				FClient.frame4.showInfo("Click OK to try again.");
			} else {
				FClient.frame.showError("Couldn't get I/O for the connection to: " + serverName);
				FClient.frame.voteErr();
			}
		}
		
		packetMsg = FClient.comms.getMessage() + "\r\n";
		port = FClient.comms.freePort;
		
		/* send packet */
		try {
			freeSocket = new Socket(serverName, port); // open connection
			out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(freeSocket.getOutputStream())), true);
			in = new BufferedReader(new InputStreamReader(freeSocket.getInputStream()));
			
			out.println(packetMsg); // write packet
			
		} catch (UnknownHostException e) {
			if (FClient.ercheck) {  // make sure we're sending errors to the right screen
				FClient.frame4.showError("Unknown host: " + serverName);
				FClient.frame4.status=false;
				FClient.frame4.jButton1.setEnabled(true);
				FClient.frame4.jButton2.setEnabled(true);
				FClient.frame4.showInfo("Click OK to try again.");
			} else {
				FClient.frame.showError("Unknown host: " + serverName);
				FClient.frame.voteErr();
			}
		} catch (IOException e) {
			if (FClient.ercheck) {  // make sure we're sending errors to the right screen
				FClient.frame4.showError("Couldn't get I/O for the connection to: " + serverName);
				FClient.frame4.status=false;
				FClient.frame4.jButton1.setEnabled(true);
				FClient.frame4.jButton2.setEnabled(true);
				FClient.frame4.showInfo("Click OK to try again.");
			} else {
				FClient.frame.showError("Couldn't get I/O for the connection to: " + serverName);
				FClient.frame.voteErr();
			}
		} catch (Exception e) {
			if (FClient.ercheck) {  // make sure we're sending errors to the right screen
				FClient.frame4.showError("Error connecting: " + e.getMessage());
				FClient.frame4.status=false;
				FClient.frame4.jButton1.setEnabled(true);
				FClient.frame4.jButton2.setEnabled(true);
				FClient.frame4.showInfo("Click OK to try again.");
			} else {
				FClient.frame.showError("Error connecting: " + e.getMessage());
				FClient.frame.voteErr();
			}
		}
		
		String inputData = "NONE";
		String outputData = "NONE";
		
		/* read response */
		try {
			
			while (FClient.carryOn) {
			
				if (in.ready()) {  // if there's data 
				
					inputData = in.readLine();
					
					if (!inputData.equals("")) { // check real data has arrived
		
						outputData = ClientProtocol.process(inputData);
						
						if ((outputData.equals("DONE"))|(outputData.equals("ERROR"))) {
						
							break;
							
						} else if (outputData.charAt(0)=='X') {
						
							out.println(outputData);
							
							break;
							
						} else {
						
							out.println(outputData);
							
						}
						
					}
					
				}
			
			}
						
			
		} catch (Exception e) {
			if (FClient.ercheck) {  // make sure we're sending errors to the right screen
				FClient.frame4.showError("Connection Error: " + e.getMessage());
			} else {	
				FClient.frame.showError("Connection Error: " + e.getMessage());
			}
		} finally {
			//tidy up
			try {
				out.close();
				in.close();
				freeSocket.close();
			} catch (Exception e) {
				if (FClient.ercheck) {  // make sure we're sending errors to the right screen
					FClient.frame4.showError("Error shutting connection: " + e.getMessage());
				} else {
					FClient.frame.showError("Error shutting connection: " + e.getMessage());
				}
			}
			FClient.comms.timer.stopThread();
			FClient.comms.setFromServer(outputData);
		}
		
		FClient.comms.timer.stopThread();
	
	} //EOF run
	
} //EOF TCPClient