/*
 * GNU.FREE 2001
 *
 * Copyright (c) 1999, 2000, 2001 The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@thecouch.org>
 *
 * GNU site: http://www.gnu.org/software/gnu.free/gnufree.html
 * 
 * FREE e-democracy site: http://www.thecouch.org/free/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (gpl.txt); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
 
package FreeClient;

import java.awt.*;
import java.awt.event.*;

import Free.awt.*;

/**
 * Intro screen to explain to users what FREE does.
 *
 * @version 0.2 15 March 2000
 * @author Jason Kitcat, Rajagopal C.V
 */
public class FCFrame2 extends Frame 
{

	Label jLabel1 = new Label();
	TextArea jTextPane1 = new TextArea();
	Button jButton1 = new Button();

	protected FCFrame2() {

		setTitle("FREE: Introduction");
		jLabel1.setText("Introduction:");
		jButton1.setLabel("OK");
		
		FreePanel scrollPanel = new FreePanel("Introduction:");
		scrollPanel.setInsets(3, 3, 3, 3);
		
		scrollPanel.addComponent( 0, 0, 1, 2, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 1.0f, jTextPane1);
		FreePanel buttonPane = new FreePanel();
		scrollPanel.addComponent( 1, 1, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jButton1);
			
		setSize(new java.awt.Dimension(350, 450));
		add(scrollPanel);

	}

	protected void initComponents() throws Exception
	{
		jButton1.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton1ActionPerformed(e);
			}
		});
		addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowOpened(java.awt.event.WindowEvent e) {
				thisWindowOpened(e);
			}
			public void windowClosing(java.awt.event.WindowEvent e) {
				thisWindowClosing(e);
			}
		});
	}
  
	// Show an informational message (black, plain text)
	protected void showInfo(String msg) {
		showMsg(msg);
	}
  
	// Show an warning message (red, bold text)
	protected void showError(String msg) {
		showMsg(msg);
	}
	
	// Show a text message using the specified AttributeSet
	protected void showMsg(String msg) {
		msg += "\n";
		jTextPane1.setText(jTextPane1.getText() + msg);
	}

	// Close the window when the close box is clicked
	void thisWindowClosing(java.awt.event.WindowEvent e)
	{
		setVisible(false);
		dispose();
		
		FClient.frame3.setVisible(true);
		
	}
	
	protected void thisWindowOpened(java.awt.event.WindowEvent e) {
	
		showInfo("Welcome to the FREE Voting System.\n\r\n\rThis system is specially designed to allow you to vote in full confidence. You can feel assured because FREE is designed for:\n\r\n\r- PRIVACY\n\rAt no time is a link ever made between who you are and what you have voted. Your choice is 100% private.\n\r\n\r- SECURITY\n\rFREE uses special security systems designed to prevent anybody voting multiple times or any third party from throwing the outcome of a vote.\n\r\n\r- RELIABILITY\n\rMany different computers are used by FREE, so that if one fails the whole vote won't be affected. FREE allows votes to be cheaper, faster and more accurate.\n\r\n\rThank you for voting - democracy needs you.\n\r\n\r");
					
	}
	
	protected void jButton1ActionPerformed(java.awt.event.ActionEvent e) {
	
		setVisible(false);
			
		FClient.ercheck = true;
		FClient.frame3.setVisible(true);
				
		dispose();
	}
	
}
