/*
 * GNU.FREE 2001
 *
 * Copyright (c) 1999, 2000, 2001 The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@thecouch.org>
 *
 * GNU site: http://www.gnu.org/software/gnu.free/gnufree.html
 * 
 * FREE e-democracy site: http://www.thecouch.org/free/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (gpl.txt); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
  
package FreeClient;

import java.io.*;
import java.net.*;
import java.util.*;
import Free.util.*;

/**
 * Comms is the key class for launching communications with servers.
 *
 * The class launches a thread for TCP/IP communications and also contains
 * the methods for building packets. These packets are then held in
 * <code>message</code> for retrieval by <code>TCPClient</code>
 *
 * @version 0.7 17 January 2001
 * @author Jason Kitcat
 */
public class Comms {

	private Thread talker;
	private Runnable tk;
	protected TimeOutThread timer;
	
	/** constant to hold address of regional server */
//#ifdef INSTALL
	protected static final String R_address = "stephenson.swingdigital.com";
	/** constant to hold address of electoral roll server gibson.swingdigital.com*/
//#ifdef INSTALL
	protected static final String ER_address = "212.42.168.209";
	/** constant to store value being used as FREE port number
	 * For security reasons I recommend this is changed regularly
	 */
//#ifdef INSTALL
	protected static final int freePort = 1111;
	
	/** For returning data from <code>TCPClient</code>. Not currently used. */
	private String fromServer;
	/** Holds the check time/date stamp for FREE security protocol */
	private Date check;
	/** A string holding the packet to be initially sent to a server */
	private String message;
	/** Stores the AuthKey from ERServer until sent to RTServer when cleared */
	private String ERAuthKey;
	/** Stores the type of packet being sent, using the same flags as for
	 * section 1 of a FREE packet. This is used to determine which server
	 * to send <code>message</code> to.
	 */
	private char type;
	
	/* constructor */
	protected Comms() {
	
		// unneccessary but just in case!
		message = "";
		fromServer = "";
		ERAuthKey="";
	
	}

	/* simple acessor method */
	protected void setFromServer(String x) {
	
		fromServer = x;
	
	}
	
	/* simple acessor method */
	protected Date getCheck() {
	
		return check;
	
	}
	
	/* simple acessor method */
	protected String getERAuthKey() {
	
		return ERAuthKey;
	
	}
	
	/* simple acessor method */
	protected void setERAuthKey(String x) {
	
		ERAuthKey = x;
	
	}

	/* simple acessor method */
	protected void noCheck() {
	
		check = null;
	
	}
	
	/* simple acessor method */
	protected String getMessage() {
	
		return message;
	
	}

	/* simple acessor method */
	protected char getType() {
	
		return type;
	
	}

	/**
	 * sendVote creates check date for security and sends a vote packet.
	 *
	 * @param party  String to hold voter's choice
	 */
	 protected void sendVote(String party) {	 
		
		tk = new TCPClient();
		talker = new Thread(tk);

		String reply;
		
		FClient.carryOn = true;
		
		check = new Date();

		try {
			
			message = "V|" + check.toString() + "-" + party + "-" + ERAuthKey + "|" + AuthSys.makeDigest(check.toString() + "-" + party + "-" + ERAuthKey);

			type = 'V';
			
			timer = new TimeOutThread();
			timer.start(); // start timeout system
		
	 		talker.start();  // start communications

			reply = fromServer;
			
	 	} catch (Exception e) {
	 		FClient.frame.showError("sendVote IO Error: " + e.getMessage());
	 	}
	 			
	 }  //EOF sendVote


	/* IMPORTANT NOTE: sendAuth is only a demo implementation and is not necessarily secure.
	   This method will need reimplementation depending on how you want to authorise voters.
	   In later versions of FREE I hope to make this more flexible. e.g. support smart cards.
	 */

	/**
	 * sendAuth dispatches a packet to the ERServer for voter authentication.
	 * Since 1.5 the PIN and password have been sent as digests.
	 *
	 * @param name  Name of user
	 * @param code  A unique code for this election only
	 * @param password  Self explanatory
	 */
	protected void sendAuth(String name, String code, String password) {
	
		tk = new TCPClient();
		talker = new Thread(tk);

		String reply, data;
		
		FClient.carryOn = true;
		
		type = 'E';
			
		try {
			message = "E|" + name + "-" + AuthSys.makeDigest(code) + "-" + AuthSys.makeDigest(password) + "|" + AuthSys.makeDigest(name + "-" + AuthSys.makeDigest(code) + "-" + AuthSys.makeDigest(password));
		
			timer = new TimeOutThread();
			timer.start(); // start timeout system
		
	 		talker.start();  // start communications
		 	
		 	reply = fromServer;
		 	
	 	} catch (Exception e) {
	 		FClient.frame4.showError("sendAuth IO Error: " + e.getMessage());
	 		FClient.frame4.status=false;
	 		FClient.frame4.jButton1.setVisible(true);
	 		FClient.frame4.jButton2.setVisible(true);
	 		FClient.frame4.showError("Click OK to try again.");
	 	}
	
	} //EOF sendAuth
	 

	/**
	 * sendDiag dispatches any diagnostic packets for debugging.
	 *
	 * @param msg  Data for packet
	 */
	 protected void sendDiag(String msg) {	 
		
		tk = new TCPClient();
		talker = new Thread(tk);

		String reply;
		
		FClient.carryOn = true;
		
		type = 'D';
	
		try {
			message = "D|" + msg + "|" + AuthSys.makeDigest(msg);
			
			timer = new TimeOutThread();
			timer.start(); // start timeout system
		
	 		talker.start();  // start communications
		 	
		 	reply = fromServer;
		 	
	 	} catch (Exception e) {
	 		FClient.frame.showError("sendDiag IO Error: " + e.getMessage());
	 	}
	 			
	 }  //EOF sendDiag

	
} //EOF Class