/*
 * GNU.FREE 2001
 *
 * Copyright (c) 1999, 2000, 2001 The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@thecouch.org>
 *
 * GNU site: http://www.gnu.org/software/gnu.free/gnufree.html
 * 
 * FREE e-democracy site: http://www.thecouch.org/free/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (gpl.txt); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
  
package Free.util;


/**
 * Packet is the data type that represents all FREE packets used in its protocols.
 *
 * @version 0.4 25 March 2000
 * @author Jason Kitcat
 */
public class Packet {


private char type;
private String message;
private String digest;

/** constructor which parses Strings into valid packets
 *
 * @param p  A String containing the data to parse
 */
public Packet(String p) {

	int i=2;

	type = p.charAt(0);
	while (p.charAt(i)!='|') {
		i++;
	}
	
	// defensive code
	if (i == 2) {
		message = "";
	} else {
		message = p.substring(2,(i));
	}
	digest = p.substring(i+1);

}

/** returns a printable value of Packet.
 *
 * @returns  The concatenation of the various data fields into a string
 */
public String toString() {

	String out;
	
	out = type + "|" + message + "|" + digest;
	
	return out;
	
}

/** return the data portion of Packet */
public String getMessage() {

	return message;
	
}

/** return message digest of Packet */
public String getDigest() {

	return digest;
	
}

/** return type of Packet */
public char getType() {

	return type;
	
}

} //EOF Packet