/*
 * GNU.FREE 2001
 *
 * Copyright (c) 1999, 2000, 2001 The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@thecouch.org>
 *
 * GNU site: http://www.gnu.org/software/gnu.free/gnufree.html
 * 
 * FREE e-democracy site: http://www.thecouch.org/free/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (gpl.txt); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
 
package Free;

import java.io.*;
import java.net.*;

/**
 * TCPClient allows <code>RTServer</code> to connect as a client to
 * a totaller server when the ballot has closed.
 *
 * While TCPClient performs all the connection-level operations and deals
 * with errors, all data is passed to <code>ClientProtocol</code> for
 * for processing.
 *
 * @version 0.9 26 February 2001
 * @author Jason Kitcat
 */
public class TCPClient implements Runnable {

	/**
	 * run() delivers a packet to the server whose DNS address is chosen
	 * 
	 */
	public void run() {
	
		String serverName="";
		String packetMsg;
		int port;
		Socket freeSocket = null;
		PrintWriter out = null;
		BufferedReader in = null;
		
		/* get data */
		if (RTServer.comms.getType()=='T') {
			serverName = RTServer.comms.T_address;
		} else if (RTServer.comms.getType()=='D') {
			serverName = RTServer.comms.ER_address;
		} else if (RTServer.comms.getType()=='K') {
			serverName = RTServer.comms.ER_address;
		} else if (RTServer.comms.getType()=='Q') {
			serverName = RTServer.comms.ER_address;
		} else {
			// let's get defensive
			RTServer.NORM.warn("Unknown packet type");
			RTServer.carryOn = false;
		}
		
		packetMsg = RTServer.comms.getMessage() + "\r\n";
		port = RTServer.comms.freePort;
		
		/* send packet */
		try {
			freeSocket = new Socket(serverName, port);  // establish connection
			out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(freeSocket.getOutputStream())), true);
			in = new BufferedReader(new InputStreamReader(freeSocket.getInputStream()));			
	
			out.println(packetMsg); // write packet
			
		} catch (UnknownHostException e) {
			RTServer.NORM.error("Unknown host: " + serverName);
			RTServer.NORM.error("Terminal Total Error: Quitting Total process!");
			RTServer.frame.jButton1.setEnabled(true);
			RTServer.carryOn = false;
		} catch (IOException e) {
			RTServer.NORM.error("Couldn't get I/O for the connection to: " + serverName);
			RTServer.NORM.error("Terminal Total Error: Quitting Total process!");
			RTServer.frame.jButton1.setEnabled(true);
			RTServer.carryOn = false;
		} catch (Exception e) {
			RTServer.NORM.error("Connection error: " + e.getMessage());
			RTServer.NORM.error("Terminal Total Error: Quitting Total process!");
			RTServer.frame.jButton1.setEnabled(true);
			RTServer.carryOn = false;
		}
		
		String inputData = "NONE";
		String outputData = "NONE";
		
		/* read response */
		try {
			
			while (RTServer.carryOn) {
			
				if (in.ready()) {  // if there's data 
				
					inputData = in.readLine();
					
					if (!inputData.equals("")) { // check real data has arrived
		
						if(RTServer.DEV.isDebugEnabled()) {
							RTServer.DEV.debug("Received: " + inputData);
						}
						outputData = ClientProtocol.process(inputData);
						
						if ((outputData.equals("DONE"))|(outputData.equals("ERROR"))) {
						
							break;
							
						} else if (outputData.charAt(0)=='X') {
						
							out.println(outputData);
							
							break;
							
						} else {
						
							out.println(outputData);
							
						}
						
					}
					
				}
			
			}
									
		} catch (Exception e) {
			RTServer.NORM.error("Error: " + e.getMessage());
		} finally {
			//tidy up
			try {
				out.close();
				in.close();
				freeSocket.close();
				RTServer.NORM.info("Closing connection.");
			} catch (Exception e) {
				RTServer.NORM.error("Error shutting connection: " + e.getMessage());
			}
			
			RTServer.comms.timer.stopThread();
			RTServer.comms.setFromServer(outputData);
		}

		RTServer.comms.timer.stopThread();
		
	} //EOF run
	
} //EOF TCPClient