/*
 * GNU.FREE 2001
 *
 * Copyright (c) 1999, 2000, 2001 The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@thecouch.org>
 *
 * GNU site: http://www.gnu.org/software/gnu.free/gnufree.html
 * 
 * FREE e-democracy site: http://www.thecouch.org/free/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (gpl.txt); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
 
package Free;

import java.net.*;
import java.io.*;
import java.awt.*;
import Free.awt.*;

import org.apache.log4j.*;

/**
 * This is the main class which launches the <code>RTServer</code> program,
 * splash screen and preloads some objects.
 *
 * Worthy of note is the <code>startDaemon</code> which fires up the database,
 * logging system and TCP/IP server initialisation code.
 *
 * @version 0.10 26 February 2001
 * @author Jason Kitcat, Rajagopal C.V
 */
public class RTServer {

	// Time, in milliseconds, before a connection times out
	protected static final long timeOutTime = 300000;

	// variable for stopping comms after time out
	protected static boolean carryOn = true;
	
	// Tells us whether we're a regional or totaller server
	protected static char serverType;
	
	// Stores how many regional servers there are
	protected static int rServers;

	// Stores how many regional servers have sent totals
	protected static int rServersDone;

	// AWT frames
	protected static RTFrame frame;
	protected static Intro frame2;
	protected static DBFrame frame3;
	protected static TCPServer serv;
	protected static CryptFrame frame1;
	
	// Key for communicating to totaller server
	protected static Comms comms;
	
	// logging categories
	protected static Category NORM;
	protected static Category DEV;

	protected RTServer() 
	{
		try {
			// For native Look and Feel, uncomment the following code.
			/*
			try {
				UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
			} 
			catch (Exception e) { 
			}
			*/
			
			rServers = 0;
			rServersDone = 0;
						
			FreePanel.showSplash(4000);
			
			// initiate GUI
			frame2 = new Intro();
			frame2.initComponents();
			frame2.setVisible(true);
			frame1 = new CryptFrame();
			frame1.initComponents();
			frame = new RTFrame();
			frame.initComponents();
			frame3 = new DBFrame();
			frame3.initComponents();
			
			// initiate communications
			comms = new Comms();
			
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}

	// Main entry point
	static protected void main(String[] args) 
	{
		new RTServer();
	}
	

	/**
	 * Fires up the database, logging system and TCP/IP server.
	 *
	 * It also checks to see what mode the software is running in and adapts
	 * the GUI accordingly. Logging is done with <code>log4j</code>, more info
	 * is available from
	 * <a href="http://www.log4j.org/">http://www.log4j.org/</a>.
	 *
	 */
	protected static void startDaemon() {
	
		try {
		
			// init logging system
			ScreenAppender A1 = new ScreenAppender();
			PropertyConfigurator.configure("log4j.rtserver.properties");			
			NORM = Category.getInstance("NORM");
			NORM.addAppender(A1);
			/* comment out the DEV portion to reduce log detail */
			DEV = Category.getInstance("DEV");
			DEV.addAppender(A1);

			NORM.info("FREE RTServer 0.9 starting up...");

			// start up our database
			DBase.init();

			// intialise AuthSys
			AuthKey.init();
			
			// launch TCPServer services
			serv = new TCPServer();
			serv.startServer(comms.freePort);

			if (RTServer.serverType == 'R') {
				RTServer.frame.jButton1.setVisible(true);
				NORM.info("Regional server mode");
			} else {
				RTServer.frame.jButton1.setVisible(false);
				NORM.info("Totaller server mode");
			}
			
			NORM.info("Server daemon started");

		}
		catch (Exception e) {
			e.printStackTrace();
		}
		
	
	} //EOF startDaemon

	
} //EOF Class
