/*
 * GNU.FREE 2001
 *
 * Copyright (c) 1999, 2000, 2001 The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@thecouch.org>
 *
 * GNU site: http://www.gnu.org/software/gnu.free/gnufree.html
 * 
 * FREE e-democracy site: http://www.thecouch.org/free/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (gpl.txt); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
 
package Free;

import java.awt.*;
import java.awt.event.*;

import Free.awt.*;

/**
 * Asks user to choose mode to run RTServer in.
 *
 * @version 0.6 31 January 2001
 * @author Jason Kitcat, Rajagopal C.V
 */
public class Intro extends Frame 
{
	private final CheckboxGroup group = new CheckboxGroup();

	Checkbox jRadioButton1;
	Checkbox jRadioButton2;
	Label jLabel1 = new Label();
	Label jLabel2 = new Label();
	TextField jTextField1 = new TextField();
	Button jButton1 = new Button();
	Label jLabel3 = new Label();

	public Insets getInsets(){

		return new Insets( 30, 10, 10, 10);
	}

	protected Intro()
	{

		setTitle("FREE: Settings");
		jRadioButton1 = new Checkbox("Regional Server", group, false);
		jRadioButton2 = new Checkbox("Totaller Server", group, false);
		jButton1.setLabel("OK");
		jLabel1.setText("What kind of server is this?");
		
		jLabel2.setText("How many regional servers?");

		jLabel3.setText("You've missed one!");
		jLabel3.setVisible(false);
	
		FreePanel scrollPanel = new FreePanel("FREE: Settings");
		scrollPanel.setInsets(3, 3, 3, 3);
		
		scrollPanel.addComponent( 1, 0, 1, 2, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 1.0f, jLabel1);
		scrollPanel.addComponent( 2, 0, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jRadioButton1);
		scrollPanel.addComponent( 3, 0, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jRadioButton2);
		scrollPanel.addComponent( 4, 1, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jLabel2);
		scrollPanel.addComponent( 5, 1, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jTextField1);
		scrollPanel.addComponent( 6, 1, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jButton1);
		scrollPanel.addComponent( 7, 1, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jLabel3);
			
		add(scrollPanel, BorderLayout.CENTER);
		setSize(new java.awt.Dimension(425, 275));


	}


	class itemListener implements ItemListener{
		public void itemStateChanged(ItemEvent e){
			if(e.getSource() == jRadioButton1){
				jRadioButton1StateChanged(e);
			}
			else if(e.getSource() == jRadioButton2){

				jRadioButton2StateChanged(e);
			}
		}

	}
	public void initComponents() throws Exception
	{

		jRadioButton1.addItemListener(new itemListener());
		jRadioButton2.addItemListener(new itemListener());
		
		jButton1.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton1ActionPerformed(e);
			}
		});
		addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent e) {
				thisWindowClosing(e);
			}
		});
	}
  
	// Close the window when the close box is clicked
	void thisWindowClosing(java.awt.event.WindowEvent e)
	{
	}
	
	public void jRadioButton1StateChanged(ItemEvent e) {
		jLabel2.setEnabled(false);
		jTextField1.setEnabled(false);
		jButton1.setEnabled(true);
		RTServer.serverType = 'R';
	}

	public void jRadioButton2StateChanged(ItemEvent e) {
		jLabel2.setEnabled(true);
		jTextField1.setEnabled(true);
		jButton1.setEnabled(true);
		RTServer.serverType = 'T';
	}
		
	public void jButton1ActionPerformed(java.awt.event.ActionEvent e) {
	
			if (RTServer.serverType == 'T') {
				if (jTextField1.getText().equals("")) {
					jLabel3.setVisible(true);
				} else {
					Integer t;
					t = new Integer(jTextField1.getText());
					RTServer.rServers = t.intValue();
					
					setVisible(false);
					RTServer.frame1.setVisible(true);

					dispose();
				}
			} else {
				setVisible(false);
				RTServer.frame1.setVisible(true);

				dispose();
			}
	
	}
}
