/*
 * GNU.FREE 2001
 *
 * Copyright (c) 1999, 2000, 2001 The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@thecouch.org>
 *
 * GNU site: http://www.gnu.org/software/gnu.free/gnufree.html
 * 
 * FREE e-democracy site: http://www.thecouch.org/free/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (gpl.txt); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
 
package Free;

import java.io.*;
import java.net.*;
import java.util.*;

import Free.util.*;

/**
 * Comms is the key class for launching communications with servers.
 *
 * The class launches a thread for TCP/IP communications and also contains
 * the methods for building packets. These packets are then held in
 * <code>message</code> for retrieval by <code>TCPClient</code>
 *
 * @version 0.91 7 February 2001
 * @author Jason Kitcat
 */
public class Comms {

	private Thread talker;
	protected TimeOutThread timer;

	/** constant to hold address of totaller server */
//#ifdef INSTALL
	protected static final String T_address = "bear.swingdigital.com";
	/** constant to hold address of electoral roll server */
//#ifdef INSTALL
	protected static final String ER_address = "gibson.swingdigital.com";
	/** constant to store value being used as FREE port number
	 * for security reasons I recommend this is changed regularly
	 */
//#ifdef INSTALL
	protected static final int freePort = 1111;
	/** stores total packet data while waiting to be sent */
	protected Vector totalData = new Vector(1);
	/** keeps track of where we are in the Vector */
	protected int tdCount;
	
	/** For returning data from <code>TCPClient</code>. Not currently used. */
	private String fromServer;
	/** Holds the check time/date stamp for FREE security protocol */
	private Date check;
	/** A string holding the packet to be initially sent to a server */
	private String message;
	/** Stores the type of packet being sent, using the same flags as for
	 * section 1 of a FREE packet. This is used to determine which server
	 * to send <code>message</code> to.
	 */
	private char type;
	
	/* constructor */
	protected Comms() {
	
		// unneccessary but just in case!
		message = "";
		fromServer = "";
	
	}

	/* simple acessor method */
	protected void setFromServer(String x) {
	
		fromServer = x;
	
	}
	
	/* simple acessor method */
	protected Date getCheck() {
	
		return check;
	
	}
	
	
	/* simple acessor method */
	protected void noCheck() {
	
		check = null;
	
	}

	/* simple acessor method */
	protected String getMessage() {
	
		return message;
	
	}

	/* simple acessor method */
	protected char getType() {
	
		return type;
	
	}

	/**
	 * sendTotals creates check date for security, calculates vote counts and sends
	 * on to the Totaller server.
	 *
	 */
	 protected void sendTotals() {	 
				
		Runnable tk = new TCPClient();
		talker = new Thread(tk);

		String reply = "";
		String result = "";
		
		RTServer.carryOn = true;
		check = new Date();
		
		tdCount = 0;

		try {

			RTServer.NORM.info("Calculating and sending totals...");
			
			/* DO SQL STUFF HERE */
			totalData = DBase.getTotals();
			/* NB Several packets needed for all parties */
			/* when finished we send T|DONE|MAC */
			
			message = "T|" + check.toString() + "-" + totalData.elementAt(tdCount) + "|" + AuthSys.makeDigest(check.toString() + "-" + totalData.elementAt(tdCount)); // do first total
			
			if(RTServer.DEV.isDebugEnabled()){
				RTServer.DEV.debug("First total: " + message);
			}
			
			type = 'T';
			
			timer = new TimeOutThread();
			timer.start(); // start timeout system
		
	 		talker.start();  // start communications

			reply = fromServer;
			
	 	} catch (Exception e) {
	 		RTServer.NORM.error("sendTotal IO Error: " + e.getMessage());
	 	}
	 			
	 }  //EOF sendTotals


	/**
	 * sendKey delivers a key to an ERServer for confirming someone has voted.
	 *
	 * @param akey  The key to send
	 */
	 protected void sendKey(String akey) throws Exception {
		
		Runnable tk = new TCPClient();
		Thread talker = new Thread(tk);

		String reply;
		
		RTServer.carryOn = true;
		type = 'K';

		try {
			message = "K|" + akey + "|" + AuthSys.makeDigest(akey);
			
			if(RTServer.DEV.isDebugEnabled()) {
				RTServer.DEV.debug("Sending AuthKey: " + message);
			}
		
			timer = new TimeOutThread();
			timer.start(); // start timeout system
		
	 		talker.start();  // start communications

		 	reply = fromServer;
		 	
	 	} catch (Exception e) {
	 		RTServer.NORM.error("sendKey IO Error: " + e.getMessage());
	 	}
	 			
	 }  //EOF sendKey


	/**
	 * getTotalVoted communicates with the ERServer to find out how many people
	 * voted. This can be compared with the number of votes registered to give
	 * an idea of validity.
	 *
	 */
	 protected void getTotalVoted() {
		
		try {
			Runnable tk = new TCPClient();
			Thread talker = new Thread(tk);

			String reply;
		
			RTServer.carryOn = true;
			type = 'Q';
	
			/* Get verification data from ERServer */
			RTServer.NORM.info("Getting verification data from ERServer...");
			
			message = "Q|TOTALVOTED|" + AuthSys.makeDigest("TOTALVOTED");
		
			if(RTServer.DEV.isDebugEnabled()) {
				RTServer.DEV.debug("Sending: " + message);
			}

			timer = new TimeOutThread();
			timer.start(); // start timeout system
	
	 		talker.start();  // start communications

		 	reply = fromServer;
		 } catch (Exception e) {
		 	RTServer.NORM.error("Verification check error: " + e.getMessage());
		 	RTServer.carryOn = false;
		 }
		 	
	 }  //EOF getTotalVoted


	/**
	 * sendDiag dispatches any diagnostic packets for debugging.
	 *
	 * @param msg  Data for packet
	 */
	 protected void sendDiag(String msg) {	 
		
		Runnable tk = new TCPClient();
		Thread talker = new Thread(tk);

		String reply;
		
		RTServer.carryOn = true;
		type = 'D';
	
		try {
			message = "D|" + msg + "|" + AuthSys.makeDigest(msg);
			
			if(RTServer.DEV.isDebugEnabled()) {
				RTServer.DEV.debug("Sending: " + message);
			}
		
			timer = new TimeOutThread();
			timer.start(); // start timeout system
		
	 		talker.start();  // start communications

		 	reply = fromServer;
		 	
	 	} catch (Exception e) {
	 		RTServer.NORM.error("sendDiag IO Error: " + e.getMessage());
	 	}
	 			
	 }  //EOF sendDiag

	
} //EOF Class