/*
 * GNU.FREE 2001
 *
 * Copyright (c) 1999, 2000, 2001 The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@thecouch.org>
 *
 * GNU site: http://www.gnu.org/software/gnu.free/gnufree.html
 * 
 * FREE e-democracy site: http://www.thecouch.org/free/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (gpl.txt); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package Free.awt;

import java.awt.*;

/**
 * RxImageLabel
 *
 * @version 0.1 30 January 2001
 * @author Rajagopal C.V
 * @since 1.5
 */
public class RxImageLabel extends Canvas{

	Image FileImage;
	public RxImageLabel(String imageFile){
		imageFile = imageFile+".gif";
		FileImage = Toolkit.getDefaultToolkit().getImage(imageFile);
		MediaTracker tracker = new MediaTracker(this);
		tracker.addImage(FileImage, 0);
		try{
			tracker.waitForAll();
		}
		catch(InterruptedException e){};
	}

	public void addNotify(){
		super.addNotify();
		setSize(FileImage.getWidth(this), FileImage.getHeight(this));
	}

	public void setText(String image){
		image = image + ".gif";
		FileImage = Toolkit.getDefaultToolkit().getImage(image);
		MediaTracker tracker = new MediaTracker(this);
		tracker.addImage(FileImage, 0);
		try{
			tracker.waitForAll();
		}
		catch(InterruptedException e){};
		setSize(FileImage.getWidth(this), FileImage.getHeight(this));
		repaint();
	}
	
	public Dimension preferredSize(){
		return new Dimension(FileImage.getWidth(this), 
			FileImage.getHeight(this));
	}
	
	public void paint(Graphics g){
		super.paint(g);
		// g.drawImage(FileImage, 10, 10, FileImage.getWidth(this), 
		g.drawImage(FileImage, 0, 0, FileImage.getWidth(this), 
			FileImage.getHeight(this), this);
	}

}


