/*
 * GNU.FREE 2001
 *
 * Copyright (c) 1999, 2000, 2001 The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@thecouch.org>
 *
 * GNU site: http://www.gnu.org/software/gnu.free/gnufree.html
 * 
 * FREE e-democracy site: http://www.thecouch.org/free/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (gpl.txt); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
  
package ERServer;

import org.apache.log4j.*;
import org.apache.log4j.spi.*;
 
/**
 * Implements the <code>org.apache.log4j.Appender</code> interface to provide screen
 * display of logging output.
 *
 * This provides many advantages in that not only is error reporting faster with log4j
 * than the previous hand coded system. It also reduces redundancy by allowing only one
 * command to write simultaneously to the log file and to the screen. Additionally this
 * class is aware of of the Category/Priority system providing further flexibility.
 *
 * @version 0.3  18 January 2001
 * @author Jason Kitcat
 * @since 1.2
 */
public class ScreenAppender implements Appender {

	private String name;

	public void doAppend(LoggingEvent le) {

		if (le.priority.toInt() < 6) {  // if WARN or worse
			ERServer.frame.showError("[" + le.priority.toString() + "] " + le.message);
		} else {  // else INFO or DEBUG
			ERServer.frame.showInfo("[" + le.priority.toString() + "] " + le.message);
		}

	} //EOF doAppend
	
	
	public void addFilter(Filter newFilter) {
	
		// no filter support needed
	
	}
	
	
	public void clearFilters() {
	
		// no filters
		
	}
	
		
	public void close() {
	
		// the ScreenAppender should never be closed
		// except during valid shutdown thus this
		// method is not needed
	
	}


	public boolean requiresLayout()	{
	
		// we don't need a layout
		return false;		
	
	}

	
	public void setErrorHandler(ErrorHandler errorHandler) {
	
		// not supported
	
	}
	
	
	public void setLayout(Layout l) {
	
		// do nothing as FREE screens
		// have a set layout
		
	}
	
	
	public void activateOptions() {
	
		// do nothing as no
		// ambiguous options
		
	}
	
	
	public String[] getOptionStrings() {
	
		String [] s = new String[1];
		
		s[0] = name;
		
		return s;
	
	}
	
	
	public void setOption(String option, String value) {
	
		name = value;
		
		// no other options so must be that!
		
	}
	
	
	public String getName() {
	
		return name;
		
	}
	

	public void setName(String n) {
	
		name = n;
		
	}
	
} //EOF ScreenAppender