/*
 * GNU.FREE 2001
 *
 * Copyright (c) 1999, 2000, 2001 The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@thecouch.org>
 *
 * GNU site: http://www.gnu.org/software/gnu.free/gnufree.html
 * 
 * FREE e-democracy site: http://www.thecouch.org/free/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (gpl.txt); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
  
package ERServer;

import java.net.*;
import java.io.*;
import Free.awt.*;
import java.awt.*;

import org.apache.log4j.*;

/**
 * Launches the ERServer program and initalises the GUI.
 *
 * The database is also initialised. Additionally the log system
 * is prepared. Logging is done with <code>log4j</code>, more info
 * is available from
 * <a href="http://www.log4j.org">www.log4j.org</a>.
 *
 *
 * @version 0.9  20 February 2001
 * @author Jason Kitcat, Rajagopal C.V
 */
public class ERServer 
{
	/* SECURITY NOTE: VERY IMPORTANT! */
	// constant to store value being used as FREE port number
	// For security reasons I recommend this is changed every election
//#ifdef INSTALL
	private static final int freePort = 1111;

	// AWT frames
	protected static ERFrame1 frame;
	protected static CryptFrame frame1;
	protected static ERFrame2 frame2;
	
	// Our server
	protected static TCPServer serv;
	
	// logging categories
	protected static Category NORM;
	protected static Category DEV;

	protected ERServer() 
	{
		try {
					
			FreePanel.showSplash(4000);
			
			// initiate GUI
			frame = new ERFrame1();
			frame.initComponents();
			frame1 = new CryptFrame();
			frame1.initComponents();
			frame2 = new ERFrame2();
			frame2.initComponents();
			frame1.setVisible(true);

		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}

	// Main entry point
	static protected void main(String[] args) 
	{
		new ERServer();

	}

	/**
	 * Fires up the database, logging system and TCP/IP server.
	 *
	 * It also checks to see what mode the software is running in and adapts
	 * the GUI accordingly. Logging is done with <code>log4j</code>, more info
	 * is available from
	 * <a href="http://www.log4j.org/">http://www.log4j.org/</a>.
	 *
	 */
	protected static void startDaemon() {
	
		try {
		
			// init logging system
			ScreenAppender A1 = new ScreenAppender();
			PropertyConfigurator.configure("log4j.erserver.properties");			
			NORM = Category.getInstance("NORM");
			NORM.addAppender(A1);
			/* comment out the DEV portion to reduce log detail */
			DEV = Category.getInstance("DEV");
			DEV.addAppender(A1);
			
			ERServer.NORM.info("FREE ERServer 0.7 starting up...");
			
			// initialise database
			DBase.init();

			// intialise AuthSys
			AuthKey.init();
				
			// launch TCPServer services
			serv = new TCPServer();
			serv.startServer(freePort);
			
			ERServer.NORM.info("Server daemon started");

		}
		catch (Exception e) {
			e.printStackTrace();
		}
		
	
	} //EOF startDaemon

} //EOF Class
