/*
 * GNU.FREE 2001
 *
 * Copyright (c) 1999, 2000, 2001 The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@thecouch.org>
 *
 * GNU site: http://www.gnu.org/software/gnu.free/gnufree.html
 * 
 * FREE e-democracy site: http://www.thecouch.org/free/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (gpl.txt); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
  
package ERServer;

import java.io.*;
import java.sql.*;
import java.util.*;
import org.hsql.*;

import cryptix.provider.key.RawSecretKey;
import cryptix.provider.padding.OneAndZeroes;
import cryptix.provider.cipher.Blowfish;
import cryptix.util.core.Hex;

import xjava.security.Cipher;
import xjava.security.FeedbackCipher;
import xjava.security.SecretKey;

import java.security.*;

import Free.util.*;
import Free.DBPool.*;

/**
 * DBase creates databases, tables and interacts with these through JDBC and SQL.
 *
 * Implementation of the databases is with 
 * <a href="http://hsql.oron.ch">Hypersonic SQL</a> which is written
 * totally in Java.
 *
 * This implementation was created to support the demoonstration security
 * authorisation system. To implement a new (e.g. biometric) auth system
 * then you *WILL* need to change some SQL. It won't hurt.
 *
 * @version 1.3  20 February 2001
 * @author Jason Kitcat
 */
public class DBase {

	private static final String username = "sa";
	private static final String password = "";
	// USER SUPPLIED SESSION WORD
	protected static String cryptword = "";
	

	/**
	 * initialises the Hypersonic SQL database.
	 *
	 */
	protected static void init() {
	
		try {

			Class.forName("org.hsql.jdbcDriver"); // Load the Hypersonic SQL JDBC driver

			/* Prepare the pool with currently 10 connections */
			new JDCConnectionDriver("org.hsql.jdbcDriver","jdbc:HypersonicSQL:erserver",username, password);

			/* Get a connection from the pool */
			Connection freeConn = getConnection();
			Statement freeStat = freeConn.createStatement();
			
			/* make table for Electoral Roll */
			try {
				ResultSet r = freeStat.executeQuery("SELECT name FROM Roll"); //check for the table
			} catch (SQLException sqle) {
				if(ERServer.DEV.isDebugEnabled()) {
					ERServer.DEV.debug("Roll table didn't exist so creating it");
				}
				freeStat.execute("CREATE TABLE Roll(name VARCHAR(255), code VARCHAR(255), pword VARCHAR(255), voted CHAR(1))");
			}

			DatabaseMetaData dbMetaData = freeConn.getMetaData();

			freeStat.close();
			
			ERServer.NORM.info("Database intialised");
			ERServer.DEV.debug("DB Using: "  + dbMetaData.getDatabaseProductName() + " " + dbMetaData.getDatabaseProductVersion());

		} catch(Exception e) {
			ERServer.NORM.error("Database error: " + e.toString());
		}
			
	} //EOF init()


	/**
	 * Provides a database connection from the pool.
	 *
	 * @returns  A working connection
	 */
	private static Connection getConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:jdc:jdcpool");
    }
    

	/**
	 * checks String input to make sure it only contains safe characters.
	 * It's not pretty but regular expression packages tried all were far
	 * too slow.
	 *
	 * @param input  The String to check
	 * @returns  True if the string is ok
	 */
	 protected static boolean isSafe(String input) throws Exception{
	 
	 	boolean ok = true;
	 	 
		for(int i = 0; (i<input.length())&&(ok==true); i++) {
	 
	 		switch (input.charAt(i)) {
	 			case 'a': ok = true; break;
	 			case 'b': ok = true; break;
	 			case 'c': ok = true; break;
	 			case 'd': ok = true; break;
	 			case 'e': ok = true; break;
	 			case 'f': ok = true; break;
	 			case 'g': ok = true; break;
	 			case 'h': ok = true; break;
	 			case 'i': ok = true; break;
	 			case 'j': ok = true; break;
	 			case 'k': ok = true; break;
	 			case 'l': ok = true; break;
	 			case 'm': ok = true; break;
	 			case 'n': ok = true; break;
	 			case 'o': ok = true; break;
	 			case 'p': ok = true; break;
	 			case 'q': ok = true; break;
	 			case 'r': ok = true; break;
	 			case 's': ok = true; break;
	 			case 't': ok = true; break;
	 			case 'u': ok = true; break;
	 			case 'v': ok = true; break;
	 			case 'w': ok = true; break;
	 			case 'x': ok = true; break;
	 			case 'y': ok = true; break;
	 			case 'z': ok = true; break;
	 			case 'A': ok = true; break;
	 			case 'B': ok = true; break;
	 			case 'C': ok = true; break;
	 			case 'D': ok = true; break;
	 			case 'E': ok = true; break;
	 			case 'F': ok = true; break;
	 			case 'G': ok = true; break;
	 			case 'H': ok = true; break;
	 			case 'I': ok = true; break;
	 			case 'J': ok = true; break;
	 			case 'K': ok = true; break;
	 			case 'L': ok = true; break;
	 			case 'M': ok = true; break;
	 			case 'N': ok = true; break;
	 			case 'O': ok = true; break;
	 			case 'P': ok = true; break;
	 			case 'Q': ok = true; break;
	 			case 'R': ok = true; break;
	 			case 'S': ok = true; break;
	 			case 'T': ok = true; break;
	 			case 'U': ok = true; break;
	 			case 'V': ok = true; break;
	 			case 'W': ok = true; break;
	 			case 'X': ok = true; break;
	 			case 'Y': ok = true; break;
	 			case 'Z': ok = true; break;
	 			case '1': ok = true; break;
	 			case '2': ok = true; break;
	 			case '3': ok = true; break;
	 			case '4': ok = true; break;
	 			case '5': ok = true; break;
	 			case '6': ok = true; break;
	 			case '7': ok = true; break;
	 			case '8': ok = true; break;
	 			case '9': ok = true; break;
	 			case '0': ok = true; break;
	 			case ';': ok = true; break;
	 			case ')': ok = true; break;
	 			case '(': ok = true; break;
	 			case '*': ok = true; break;
	 			case '\'': ok = true; break;
	 			case ' ': ok = true; break;
	 			case '=': ok = true; break;
	 			case '-': ok = true; break;
	 			case '_': ok = true; break;
	 			case '+': ok = true; break;
	 			case '@': ok = true; break;
	 			case ',': ok = true; break;
	 			case '.': ok = true; break;
	 			case '<': ok = true; break;
	 			case '>': ok = true; break;
	 			case '?': ok = true; break;
	 			default:  ok = false; break;
	 		} //eof case
	 		
		 } //eof for
	 
	 	return ok;
	 
	 } //eof isSafe


	/**
	 * Encrypts string data before being inserted into database
	 *
	 * @param data  The string to encrypt
	 * @returns  Encrypted string
	 */
	 private static String encrypt(String data) throws Exception {
	 
	 	RawSecretKey key;
	 	byte[] ect;
		Cipher blowalg = Cipher.getInstance(new Blowfish(),null,new OneAndZeroes());
	 	
		/* build a Blowfish (16-round) key using ECB */
		key = new RawSecretKey("Blowfish", Hex.fromString(cryptword));
        
		blowalg.initEncrypt(key);
		ect = blowalg.crypt(StringByteTools.asciiGetBytes(data));

		return Hex.toString(ect);

	} //eof encrypt()


	/**
	 * Decrypts data pulled from the database returning normal strings.
	 *
	 * @param data  The encrypted string
	 * @returns  Decrypted string
	 */
	protected static String decrypt(String data) throws Exception {

		RawSecretKey key;
	 	byte[] dect;
		Cipher blowalg = Cipher.getInstance(new Blowfish(),null,new OneAndZeroes());
	 	
		/* build a Blowfish (16-round) key using ECB */
		key = new RawSecretKey("Blowfish", Hex.fromString(cryptword));
        
		blowalg.initDecrypt(key);
		dect = blowalg.crypt(Hex.fromString(data));

		return new String(dect);

	} //eof decrypt()


	/**
	 * Counts how many people have voted.
	 *
	 * @returns  An integer of how many people voted
	 */
	protected static int usersVoted() throws Exception {
	
		ResultSet result;
		boolean res;
		int count;
	
		/* Get a connection from the pool */
		Connection freeConn = getConnection();
		Statement freeStat = freeConn.createStatement();
		
		/* search for the data */
		res = freeStat.execute("SELECT COUNT(voted) FROM Roll WHERE voted='" + encrypt("T") + "'");
		result = freeStat.getResultSet();
		
		/* check answer */
		res = result.next();
		if (!res) {
			count = 0;
		} else {
			count = new Integer(result.getString(1)).intValue();
		}
		
		freeStat.close();
					
		return count;

	} //EOF usersVoted()


	/**
	 * checks Electoral Roll information against that in the database.
	 *
	 * @param name  String representing the voter's name
	 * @param code  String representing the voter's vote-specific code
	 * @param pword String representing the voter's password
	 * @returns    A boolean, true if the details match with one in the database
	 */
	protected static boolean checkER(String name, String code, String pword) throws Exception {
	
		ResultSet result;
		boolean temp, res;
	
		/* boundary check the data first */
		// only if the data is alphanumeric, punctuation or spaces do we carry on
		if (isSafe(name)&&isSafe(code)&&isSafe(pword)) {

			/* Get a connection from the pool */
			Connection freeConn = getConnection();
			Statement freeStat = freeConn.createStatement();
			
			/* search for the data */
			res = freeStat.execute("SELECT voted FROM Roll WHERE name = '" + encrypt(name) + "' AND code = '" + encrypt(code) + "' AND pword = '" + encrypt(pword) + "'");
			result = freeStat.getResultSet();
		
			/* check answer */
			res = result.next();
			if (!res) {
				temp = false;
			} else {
				if (decrypt(result.getString(1)).equals("F")) {  // they haven't already voted
					temp = true;
					freeStat.execute("UPDATE Roll SET voted = '" + encrypt("C") + "' WHERE name = '" + encrypt(name) + "' AND code = '" + encrypt(code) + "' AND pword = '" + encrypt(pword) + "'");
				} else if (decrypt(result.getString(1)).equals("C")) {  // their vote hasn't been registered but they have logged in before
					temp = true;
					// no need to change database but write to log just in case
					ERServer.NORM.info("DBase.checkER(): User already tried to vote but not confirmed");
				} else {  // otherwise they've already voted
					temp = false;
				}
			}
		
			freeStat.close();
			
		} else {
		
			temp = false;
			throw new Exception("checkER - invalid character(s) used");
			
		}
		
		return temp;

	} //EOF checkER()

	
	/**
	 * A little processor intensive and might need tuning but this method finds the user
	 * entry in the Electoral Roll that matches the received key and sets it has having
	 * voted.
	 *
	 * @param name  String representing the voter's name
	 * @param code  String representing the voter's vote-specific code
	 * @param pword String representing the voter's password
	 * @returns    A boolean, true if the details match with one in the database
	 */
	protected static void confirmVoted(String akey) throws Exception {
	
		ResultSet results;
		int count;
		boolean carryon = true;
		boolean res;
	
		/* Get a connection from the pool */
		Connection freeConn = getConnection();
		Statement freeStat = freeConn.createStatement();
			
		/* search for the data */
		// only select data which has been through stage one authentication
		res = freeStat.execute("SELECT * FROM Roll WHERE voted = '" + encrypt("C") + "'");
		
		/* crunch to find one that matches */
		count = freeStat.getUpdateCount();
		results = freeStat.getResultSet();
		if (!res) {  // if no result data records
			throw new Exception("No voters were found who were confirmed as logged in");
		} else {  // otherwise calculate and find
			while(results.next()&&carryon) {
				if (akey.equals(AuthKey.build(decrypt(results.getString(1)),decrypt(results.getString(2)),decrypt(results.getString(3)),1))) {
					// update db to set user as having voted
					freeStat.execute("UPDATE Roll SET voted = '" + encrypt("T") + "' WHERE name = '" + results.getString(1) + "' AND code = '" + results.getString(2) + "' AND pword = '" + results.getString(3) + "'");
					carryon = false;
				}
			}
		}
		
		// if we didn't find a match something is wrong
		if (carryon) {
			throw new Exception("No matching AuthKey found.");
		}
				
		freeStat.close();
		
	} //EOF confirmVoted()


	/**
	 * Goes through all Electoral Roll data to create keys made with key 1 and writes them
	 * to a file for export.
	 *
	 */
	protected static void makeAllKeys() throws Exception {
	
		ERServer.NORM.info("Building all keys...");
		
		File keyFile = new File("rtserver.keys");
		FileWriter out = new FileWriter(keyFile);
		ResultSet results;
		int count;
		boolean res;
		String temp;
	
		/* Get a connection from the pool */
		Connection freeConn = getConnection();
		Statement freeStat = freeConn.createStatement();
			
		/* search for the data */
		// only select data which has been through stage one authentication
		res = freeStat.execute("SELECT * FROM Roll");
		
		/* crunch to build each key */
		count = freeStat.getUpdateCount();
		results = freeStat.getResultSet();
		if (!res) {  // if no result data records
			throw new Exception("No data to make keys with");
		} else {  // otherwise do work
			while(results.next()) {
				// build + encrypt output
				temp = AuthKey.build(decrypt(results.getString(1)),decrypt(results.getString(2)),decrypt(results.getString(3)),1);
				temp = AuthKey.encrypt(temp,1);
				out.write(temp + "\r\n");
			}
		}
						
		out.close();
		freeStat.close();

		ERServer.NORM.info("Done! Wrote rtserver.keys for export.");
		
	} //EOF makeAllKeys()


	/**
	 * executes the SQL command sent as a parameter and returns the result to DB Console.
	 *
	 * @param  sqlCommand  A string containing SQL
	 */
	protected static void doSQL(String sqlCommand) {
	
		ResultSet results;
		boolean res;
		int count;
		
		try {
			/* Is it a custom command? Denoted by a '~' */
			if (sqlCommand.charAt(0) == '~') {
				// parse into SQL
				String data, name, code, pword;
				int i=0;
				int t=0;

				data = sqlCommand.substring(2);
									
				// parse to get seperate data fields
				while (data.charAt(i)!='-') {
					i++;
				}
				name = data.substring(0,i);

				t = i+2;
					
				while (data.charAt(t)!='-') {
					t++;
				}
			
				code = data.substring((i+1),t);									
				pword = data.substring(t+1);

				sqlCommand = "INSERT INTO Roll VALUES ('" + encrypt(name) + "', '" + encrypt(AuthSys.makeDigest(code)) + "', '" + encrypt(AuthSys.makeDigest(pword)) + "', '" + encrypt("F") + "');";
			}			
		
			/* boundary check the data first */
			// only if the data is alphanumeric, punctuation or spaces do we carry on
			if (isSafe(sqlCommand)) {
							
				ERServer.DEV.info("Executing: " + sqlCommand);
		
				/* Get a connection from the pool */
				Connection freeConn = getConnection();
				Statement freeStat = freeConn.createStatement();
			
				/* execute SQL */
				res = freeStat.execute(sqlCommand);
										
				/* display results */
				count = freeStat.getUpdateCount();
				results = freeStat.getResultSet();
				if (!res) {  // if no result data records
					ERServer.frame2.showInfo(count + " record(s) affected.");
					ERServer.frame2.showInfo("-DONE-");
				} else {  // otherwise show results
					while(results.next()) {
						ERServer.frame2.showInfo(decrypt(results.getString(1)) + "  " + decrypt(results.getString(2)) + "  " + decrypt(results.getString(3)) + "  " + decrypt(results.getString(4)));
					}  //FIXME: Improve flexibility as assumes four columns of results
					ERServer.frame2.showInfo("-DONE-");
				}
      
				freeStat.close();
				
			} else {
			
				throw new Exception("doSQL - invalid character(s) used");
				
			}
			
		} catch(Exception sqle) {
			ERServer.frame2.showError("Database error: " + sqle.toString());
			ERServer.NORM.error("Database error: " + sqle.toString());
		}
		
	} //EOF doSQL()
	


} //EOF Class