/*
 * Decompiled with CFR 0.152.
 */
package org.hsql;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsql.ByteArray;
import org.hsql.Column;
import org.hsql.Record;
import org.hsql.Result;
import org.hsql.Trace;

public class jdbcResultSet
implements ResultSet,
ResultSetMetaData {
    private Result rResult;
    private Record nCurrent;
    private int iCurrentRow;
    private int iUpdateCount;
    private boolean bInit;
    private int iColumnCount;
    private boolean bWasNull;

    public boolean next() {
        this.bWasNull = false;
        if (this.rResult == null) {
            return false;
        }
        if (!this.bInit) {
            this.nCurrent = this.rResult.rRoot;
            this.bInit = true;
            this.iCurrentRow = 1;
        } else {
            this.nCurrent = this.nCurrent.next;
            ++this.iCurrentRow;
        }
        if (this.nCurrent == null) {
            this.iCurrentRow = 0;
            return false;
        }
        return true;
    }

    public void close() {
        this.iUpdateCount = -1;
        this.rResult = null;
    }

    public boolean wasNull() {
        return this.bWasNull;
    }

    public int findColumn(String string) throws SQLException {
        int n = 0;
        while (n < this.iColumnCount) {
            if (string.equalsIgnoreCase(this.rResult.sLabel[n])) {
                return n + 1;
            }
            ++n;
        }
        throw Trace.error(7);
    }

    public String getString(int n) throws SQLException {
        this.checkColumn(--n);
        this.checkAvailable();
        Object object = this.nCurrent.data[n];
        this.checkNull(object);
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public boolean getBoolean(int n) throws SQLException {
        Object object;
        if ((object = this.getColumnInType(--n, -7)) == null) {
            return false;
        }
        return (Boolean)object;
    }

    public byte getByte(int n) throws SQLException {
        throw Trace.error(4);
    }

    public short getShort(int n) throws SQLException {
        Object object;
        if ((object = this.getColumnInType(--n, 5)) == null) {
            return 0;
        }
        return (Short)object;
    }

    public int getInt(int n) throws SQLException {
        Object object;
        if ((object = this.getColumnInType(--n, 4)) == null) {
            return 0;
        }
        return (Integer)object;
    }

    public long getLong(int n) throws SQLException {
        Object object;
        if ((object = this.getColumnInType(--n, -5)) == null) {
            return 0L;
        }
        return (Long)object;
    }

    public float getFloat(int n) throws SQLException {
        Object object;
        if ((object = this.getColumnInType(--n, 7)) == null) {
            return 0.0f;
        }
        return ((Float)object).floatValue();
    }

    public double getDouble(int n) throws SQLException {
        Object object;
        if ((object = this.getColumnInType(--n, 8)) == null) {
            return 0.0;
        }
        return (Double)object;
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return (BigDecimal)this.getColumnInType(--n, 3);
    }

    public byte[] getBytes(int n) throws SQLException {
        Object object;
        if ((object = this.getColumnInType(--n, -2)) == null) {
            return null;
        }
        return ((ByteArray)object).byteValue();
    }

    public Date getDate(int n) throws SQLException {
        return (Date)this.getColumnInType(--n, 91);
    }

    public Time getTime(int n) throws SQLException {
        return (Time)this.getColumnInType(--n, 92);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return (Timestamp)this.getColumnInType(--n, 93);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        return this.getUnicodeStream(n);
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        return new ByteArrayInputStream(this.getBytes(n));
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        return new ByteArrayInputStream(this.getBytes(n));
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() {
        return null;
    }

    public void clearWarnings() {
    }

    public String getCursorName() throws SQLException {
        throw Trace.error(21);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this;
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public Object getObject(int n) throws SQLException {
        this.checkColumn(--n);
        this.checkAvailable();
        Object object = this.nCurrent.data[n];
        this.checkNull(object);
        if (object == null) {
            return null;
        }
        if (this.rResult.iType[n] == 1111) {
            object = ((ByteArray)this.nCurrent.data[n]).deserialize();
        }
        if (object == null) {
            return null;
        }
        return object;
    }

    jdbcResultSet(Result result) throws SQLException {
        if (result.iMode == 0) {
            this.iUpdateCount = result.iUpdateCount;
        } else {
            if (result.iMode == 1) {
                throw new SQLException(result.sError);
            }
            this.iUpdateCount = -1;
            this.rResult = result;
            this.iColumnCount = result.getColumnCount();
        }
        this.bWasNull = false;
    }

    int getUpdateCount() {
        return this.iUpdateCount;
    }

    boolean isResult() {
        return this.rResult != null;
    }

    private void checkColumn(int n) throws SQLException {
        if (n < 0 || n >= this.iColumnCount) {
            Trace.error(7, n);
        }
    }

    private void checkAvailable() throws SQLException {
        if (this.rResult == null || !this.bInit || this.nCurrent == null) {
            Trace.error(41);
        }
    }

    private Object getColumnInType(int n, int n2) throws SQLException {
        this.checkColumn(n);
        this.checkAvailable();
        int n3 = this.rResult.iType[n];
        Object object = this.nCurrent.data[n];
        this.checkNull(object);
        if (n2 == n3) {
            return object;
        }
        try {
            return Column.convertObject(object, n2);
        }
        catch (Exception exception) {
            String string = "type: " + Column.getType(n3) + " (" + n3 + ") expected: " + Column.getType(n2) + " value: " + object.toString();
            throw Trace.error(38, string);
        }
    }

    private void checkNull(Object object) {
        if (object == null) {
            this.bWasNull = true;
            return;
        }
        this.bWasNull = false;
    }

    public int getColumnCount() {
        return this.iColumnCount;
    }

    public boolean isAutoIncrement(int n) {
        return false;
    }

    public boolean isCaseSensitive(int n) {
        return true;
    }

    public boolean isSearchable(int n) {
        return true;
    }

    public boolean isCurrency(int n) {
        return false;
    }

    public int isNullable(int n) {
        return 1;
    }

    public boolean isSigned(int n) {
        return true;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        this.checkColumn(--n);
        return 0;
    }

    public String getColumnLabel(int n) throws SQLException {
        this.checkColumn(--n);
        return this.rResult.sLabel[n];
    }

    public String getColumnName(int n) throws SQLException {
        this.checkColumn(--n);
        return this.rResult.sName[n];
    }

    public String getSchemaName(int n) {
        return "";
    }

    public int getPrecision(int n) {
        return 0;
    }

    public int getScale(int n) {
        return 0;
    }

    public String getTableName(int n) throws SQLException {
        this.checkColumn(--n);
        return this.rResult.sTable[n];
    }

    public String getCatalogName(int n) {
        return "";
    }

    public int getColumnType(int n) throws SQLException {
        this.checkColumn(--n);
        return this.rResult.iType[n];
    }

    public String getColumnTypeName(int n) throws SQLException {
        this.checkColumn(--n);
        return Column.getType(this.rResult.iType[n]);
    }

    public boolean isReadOnly(int n) {
        return false;
    }

    public boolean isWritable(int n) {
        return true;
    }

    public boolean isDefinitelyWritable(int n) {
        return true;
    }
}

