/*
 * Decompiled with CFR 0.152.
 */
package org.hsql;

import java.sql.SQLException;
import java.util.Vector;
import org.hsql.Cache;
import org.hsql.Channel;
import org.hsql.Column;
import org.hsql.Index;
import org.hsql.Log;
import org.hsql.Node;
import org.hsql.Record;
import org.hsql.Result;
import org.hsql.Row;
import org.hsql.Trace;

class Table {
    private String sName;
    private Vector vColumn;
    private Vector vIndex;
    private int iVisibleColumns;
    private int iColumnCount;
    private int iPrimaryKey;
    private boolean bCached;
    private Log lLog;
    private int iIndexCount;
    private int iIdentityColumn;
    private int iIdentityId;
    Cache cCache;

    Table(Log log, String string, boolean bl) {
        this.lLog = log;
        if (bl) {
            this.cCache = this.lLog.cCache;
            this.bCached = true;
        }
        this.sName = string;
        this.iPrimaryKey = -1;
        this.iIdentityColumn = -1;
        this.vColumn = new Vector();
        this.vIndex = new Vector();
    }

    void addColumn(String string, int n) throws SQLException {
        this.addColumn(string, n, true, false);
    }

    void addColumn(Column column) throws SQLException {
        this.addColumn(column.sName, column.iType, column.isNullable(), column.isIdentity());
    }

    void addColumn(String string, int n, boolean bl, boolean bl2) throws SQLException {
        if (bl2) {
            Trace.check(n == 4, 38, string);
            Trace.check(this.iIdentityColumn == -1, 8, string);
            this.iIdentityColumn = this.iColumnCount;
        }
        Trace.assert(this.iPrimaryKey == -1, "Table.addColumn");
        this.vColumn.addElement(new Column(string, bl, n, bl2));
        ++this.iColumnCount;
    }

    void addColumns(Result result) throws SQLException {
        int n = 0;
        while (n < result.getColumnCount()) {
            this.addColumn(result.sLabel[n], result.iType[n], true, false);
            ++n;
        }
    }

    String getName() {
        return this.sName;
    }

    int getInternalColumnCount() {
        return this.iColumnCount;
    }

    int getColumnCount() {
        return this.iVisibleColumns;
    }

    int getIndexCount() {
        return this.iIndexCount;
    }

    int getIdentityColumn() {
        return this.iIdentityColumn;
    }

    int getColumnNr(String string) throws SQLException {
        int n = this.searchColumn(string);
        if (n == -1) {
            throw Trace.error(7, string);
        }
        return n;
    }

    int searchColumn(String string) {
        int n = 0;
        while (n < this.iColumnCount) {
            if (string.equals(((Column)this.vColumn.elementAt((int)n)).sName)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    String getColumnName(int n) {
        return this.getColumn((int)n).sName;
    }

    int getColumnType(int n) {
        return this.getColumn((int)n).iType;
    }

    boolean getColumnIsNullable(int n) {
        return this.getColumn(n).isNullable();
    }

    Index getPrimaryIndex() throws SQLException {
        if (this.iPrimaryKey == -1) {
            return null;
        }
        return this.getIndex(0);
    }

    Index getIndexForColumn(int n) throws SQLException {
        int n2 = 0;
        while (n2 < this.iIndexCount) {
            Index index = this.getIndex(n2);
            if (index.getColumns()[0] == n) {
                return index;
            }
            ++n2;
        }
        return null;
    }

    String getIndexRoots() throws SQLException {
        Trace.assert(this.bCached, "Table.getIndexRootData");
        String string = "";
        int n = 0;
        while (n < this.iIndexCount) {
            Node node = this.getIndex(n).getRoot();
            string = node != null ? String.valueOf(string) + node.getKey() + " " : String.valueOf(string) + "-1 ";
            ++n;
        }
        string = String.valueOf(string) + this.iIdentityId;
        return string;
    }

    void setIndexRoots(String string) throws SQLException {
        Trace.check(this.bCached, 3);
        int n = 0;
        int n2 = 0;
        while (n2 < this.iIndexCount) {
            int n3 = string.indexOf(32, n);
            int n4 = Integer.parseInt(string.substring(n, n3));
            if (n4 != -1) {
                Row row = this.cCache.getRow(n4, this);
                Node node = row.getNode(n2);
                this.getIndex(n2).setRoot(node);
            }
            n = n3 + 1;
            ++n2;
        }
        this.iIdentityId = Integer.parseInt(string.substring(n));
    }

    Index getNextIndex(Index index) {
        int n = 0;
        if (index != null) {
            while (n < this.iIndexCount && this.getIndex(n) != index) {
                ++n;
            }
            ++n;
        }
        if (n < this.iIndexCount) {
            return this.getIndex(n);
        }
        return null;
    }

    int getType(int n) {
        return this.getColumn((int)n).iType;
    }

    void createPrimaryKey(int n) throws SQLException {
        Trace.assert(this.iPrimaryKey == -1, "Table.createPrimaryKey(column)");
        this.iVisibleColumns = this.iColumnCount;
        this.iPrimaryKey = n;
        int[] nArray = new int[]{n};
        this.createIndex(nArray, "SYSTEM_PK", true);
    }

    void createPrimaryKey() throws SQLException {
        Trace.assert(this.iPrimaryKey == -1, "Table.createPrimaryKey");
        this.addColumn("SYSTEM_ID", 4, true, true);
        this.createPrimaryKey(this.iColumnCount - 1);
        this.iVisibleColumns = this.iColumnCount - 1;
    }

    void createIndex(Index index) throws SQLException {
        this.createIndex(index.getColumns(), index.getName(), index.isUnique());
    }

    void createIndex(int[] nArray, String string, boolean bl) throws SQLException {
        Trace.assert(this.iPrimaryKey != -1, "createIndex");
        int n = 0;
        while (n < this.iIndexCount) {
            Index index = this.getIndex(n);
            if (string.equals(index.getName())) {
                throw Trace.error(23);
            }
            ++n;
        }
        int n2 = nArray.length;
        int[] nArray2 = new int[bl ? n2 : n2 + 1];
        int[] nArray3 = new int[bl ? n2 : n2 + 1];
        int n3 = 0;
        while (n3 < n2) {
            nArray2[n3] = nArray[n3];
            nArray3[n3] = this.getColumn((int)nArray2[n3]).iType;
            ++n3;
        }
        if (!bl) {
            nArray2[n2] = this.iPrimaryKey;
            nArray3[n2] = this.getColumn((int)this.iPrimaryKey).iType;
        }
        Index index = new Index(string, nArray2, nArray3, bl);
        if (this.iIndexCount != 0) {
            Trace.assert(this.isEmpty(), "createIndex");
        }
        this.vIndex.addElement(index);
        ++this.iIndexCount;
    }

    void checkDropIndex(String string) throws SQLException {
        int n = 0;
        while (n < this.iIndexCount) {
            if (string.equals(this.getIndex(n).getName())) {
                Trace.check(n != 0, 18);
                return;
            }
            ++n;
        }
        throw Trace.error(13, string);
    }

    boolean isEmpty() {
        return this.getIndex(0).getRoot() == null;
    }

    Object[] getNewRow() {
        return new Object[this.iColumnCount];
    }

    void moveData(Table table) throws SQLException {
        Object[] objectArray;
        Index index = table.getPrimaryIndex();
        Node node = index.first();
        while (node != null) {
            objectArray = node.getData();
            this.insert(objectArray, null);
            node = index.next(node);
        }
        index = this.getPrimaryIndex();
        node = index.first();
        while (node != null) {
            objectArray = node.getData();
            table.delete(objectArray, null);
            node = index.next(node);
        }
    }

    void insert(Result result, Channel channel) throws SQLException {
        Record record = result.rRoot;
        int n = result.getColumnCount();
        while (record != null) {
            Object[] objectArray = this.getNewRow();
            int n2 = 0;
            while (n2 < n) {
                objectArray[n2] = record.data[n2];
                ++n2;
            }
            this.insert(objectArray, channel);
            record = record.next;
        }
    }

    /*
     * Unable to fully structure code
     */
    void insert(Object[] var1_1, Channel var2_2) throws SQLException {
        block13: {
            if (this.iIdentityColumn != -1) {
                var3_3 = (Integer)var1_1[this.iIdentityColumn];
                if (var3_3 == null) {
                    var1_1[this.iIdentityColumn] = new Integer(this.iIdentityId++);
                } else {
                    var4_5 = var3_3;
                    if (this.iIdentityId <= var4_5) {
                        this.iIdentityId = var4_5 + 1;
                    }
                }
            }
            var3_4 = 0;
            while (var3_4 < this.iColumnCount) {
                if (var1_1[var3_4] == null && !this.getColumn(var3_4).isNullable()) {
                    throw Trace.error(11);
                }
                ++var3_4;
            }
            var4_5 = 0;
            try {
                var5_6 = new Row(this, var1_1);
                while (var4_5 < this.iIndexCount) {
                    var6_8 = var5_6.getNode(var4_5);
                    this.getIndex(var4_5).insert(var6_8);
                    ++var4_5;
                }
                break block13;
            }
            catch (SQLException var5_7) {
                --var4_5;
                ** while (var4_5 >= 0)
            }
lbl-1000:
            // 1 sources

            {
                this.getIndex(var4_5).delete(var1_1, var4_5 == 0);
                --var4_5;
                continue;
            }
lbl30:
            // 1 sources

            throw var5_7;
        }
        if (var2_2 != null) {
            var2_2.addTransactionInsert(this, var1_1);
        }
        if (this.lLog != null) {
            this.lLog.write(this.getInsertStatement(var1_1));
        }
        if (this.cCache != null) {
            this.cCache.cleanUp();
        }
    }

    void delete(Object[] objectArray, Channel channel) throws SQLException {
        int n = 1;
        while (n < this.iIndexCount) {
            this.getIndex(n).delete(objectArray, false);
            ++n;
        }
        this.getIndex(0).delete(objectArray, true);
        if (channel != null) {
            channel.addTransactionDelete(this, objectArray);
        }
        if (this.lLog != null) {
            this.lLog.write(this.getDeleteStatement(objectArray));
        }
        if (this.cCache != null) {
            this.cCache.cleanUp();
        }
    }

    String getInsertStatement(Object[] objectArray) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("INSERT INTO ");
        stringBuffer.append(this.getName());
        stringBuffer.append(" VALUES(");
        int n = 0;
        while (n < this.iVisibleColumns) {
            stringBuffer.append(Column.createString(objectArray[n], this.getColumn((int)n).iType));
            stringBuffer.append(',');
            ++n;
        }
        stringBuffer.setCharAt(stringBuffer.length() - 1, ')');
        return stringBuffer.toString();
    }

    boolean isCached() {
        return this.bCached;
    }

    Index getIndex(String string) {
        int n = 0;
        while (n < this.iIndexCount) {
            Index index = this.getIndex(n);
            if (string.equals(index.getName())) {
                return index;
            }
            ++n;
        }
        return null;
    }

    Column getColumn(int n) {
        return (Column)this.vColumn.elementAt(n);
    }

    private Index getIndex(int n) {
        return (Index)this.vIndex.elementAt(n);
    }

    private String getDeleteStatement(Object[] objectArray) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("DELETE FROM ");
        stringBuffer.append(this.sName);
        stringBuffer.append(" WHERE ");
        if (this.iVisibleColumns < this.iColumnCount) {
            int n = 0;
            while (n < this.iVisibleColumns) {
                stringBuffer.append(this.getColumn((int)n).sName);
                stringBuffer.append('=');
                stringBuffer.append(Column.createString(objectArray[n], this.getColumn((int)n).iType));
                if (n < this.iVisibleColumns - 1) {
                    stringBuffer.append(" AND ");
                }
                ++n;
            }
        } else {
            stringBuffer.append(this.getColumn((int)this.iPrimaryKey).sName);
            stringBuffer.append("=");
            stringBuffer.append(Column.createString(objectArray[this.iPrimaryKey], this.getColumn((int)this.iPrimaryKey).iType));
        }
        return stringBuffer.toString();
    }
}

