/*
 * Decompiled with CFR 0.152.
 */
package org.hsql;

import java.sql.SQLException;
import java.util.Vector;
import org.hsql.Channel;
import org.hsql.Column;
import org.hsql.Database;
import org.hsql.Expression;
import org.hsql.Record;
import org.hsql.Result;
import org.hsql.Select;
import org.hsql.Table;
import org.hsql.TableFilter;
import org.hsql.Tokenizer;
import org.hsql.Trace;

class Parser {
    private Database dDatabase;
    private Tokenizer tTokenizer;
    private Channel cChannel;
    private String sTable;
    private String sToken;
    private Object oData;
    private int iType;
    private int iToken;

    Parser(Database database, Tokenizer tokenizer, Channel channel) {
        this.dDatabase = database;
        this.tTokenizer = tokenizer;
        this.cChannel = channel;
    }

    Result processSelect() throws SQLException {
        Select select = this.parseSelect();
        if (select.sIntoTable == null) {
            return select.getResult(this.cChannel.getMaxRows());
        }
        Result result = select.getResult(0);
        Table table = new Table(this.dDatabase.getLog(), select.sIntoTable, false);
        table.addColumns(result);
        table.createPrimaryKey();
        table.insert(result, this.cChannel);
        this.dDatabase.linkTable(table);
        int n = result.getSize();
        result = new Result();
        result.iUpdateCount = n;
        return result;
    }

    Result processUpdate() throws SQLException {
        Result result;
        Object object;
        String string = this.tTokenizer.getString();
        this.cChannel.checkReadWrite();
        this.cChannel.check(string, 8);
        Table table = this.dDatabase.getTable(string, this.cChannel);
        TableFilter tableFilter = new TableFilter(table, null, false);
        this.tTokenizer.getThis("SET");
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Expression> vector2 = new Vector<Expression>();
        int n = 0;
        string = null;
        do {
            ++n;
            int n2 = table.getColumnNr(this.tTokenizer.getString());
            vector.addElement(new Integer(n2));
            this.tTokenizer.getThis("=");
            object = this.parseExpression();
            ((Expression)object).resolve(tableFilter);
            vector2.addElement((Expression)object);
        } while ((string = this.tTokenizer.getString()).equals(","));
        Expression expression = null;
        if (string.equals("WHERE")) {
            expression = this.parseExpression();
            expression.resolve(tableFilter);
            tableFilter.setCondition(expression);
        } else {
            this.tTokenizer.back();
        }
        object = new int[n];
        Expression[] expressionArray = new Expression[n];
        int[] nArray = new int[n];
        int n3 = 0;
        while (n3 < n) {
            object[n3] = (Integer)vector.elementAt(n3);
            expressionArray[n3] = (Expression)vector2.elementAt(n3);
            nArray[n3] = table.getType((int)object[n3]);
            ++n3;
        }
        int n4 = 0;
        if (tableFilter.findFirst()) {
            Object object2;
            Object object3;
            result = new Result();
            Result result2 = new Result();
            int n5 = table.getColumnCount();
            do {
                if (expression != null && !expression.test()) continue;
                object3 = tableFilter.oCurrentData;
                result.add((Object[])object3);
                object2 = table.getNewRow();
                int n6 = 0;
                while (n6 < n5) {
                    object2[n6] = object3[n6];
                    ++n6;
                }
                int n7 = 0;
                while (n7 < n) {
                    object2[object[n7]] = expressionArray[n7].getValue(nArray[n7]);
                    ++n7;
                }
                result2.add((Object[])object2);
            } while (tableFilter.next());
            this.cChannel.beginNestedTransaction();
            object3 = result.rRoot;
            object2 = result2.rRoot;
            try {
                while (object3 != null) {
                    table.delete(object3.data, this.cChannel);
                    table.insert(object2.data, this.cChannel);
                    ++n4;
                    object3 = object3.next;
                    object2 = object2.next;
                }
                this.cChannel.endNestedTransaction(false);
            }
            catch (SQLException sQLException) {
                this.cChannel.endNestedTransaction(true);
                throw sQLException;
            }
        }
        result = new Result();
        result.iUpdateCount = n4;
        return result;
    }

    Result processDelete() throws SQLException {
        Result result;
        this.tTokenizer.getThis("FROM");
        String string = this.tTokenizer.getString();
        this.cChannel.checkReadWrite();
        this.cChannel.check(string, 2);
        Table table = this.dDatabase.getTable(string, this.cChannel);
        TableFilter tableFilter = new TableFilter(table, null, false);
        string = this.tTokenizer.getString();
        Expression expression = null;
        if (string.equals("WHERE")) {
            expression = this.parseExpression();
            expression.resolve(tableFilter);
            tableFilter.setCondition(expression);
        } else {
            this.tTokenizer.back();
        }
        int n = 0;
        if (tableFilter.findFirst()) {
            result = new Result();
            do {
                if (expression != null && !expression.test()) continue;
                result.add(tableFilter.oCurrentData);
            } while (tableFilter.next());
            Record record = result.rRoot;
            while (record != null) {
                table.delete(record.data, this.cChannel);
                ++n;
                record = record.next;
            }
        }
        result = new Result();
        result.iUpdateCount = n;
        return result;
    }

    Result processInsert() throws SQLException {
        Object object;
        int n;
        this.tTokenizer.getThis("INTO");
        String string = this.tTokenizer.getString();
        this.cChannel.checkReadWrite();
        this.cChannel.check(string, 4);
        Table table = this.dDatabase.getTable(string, this.cChannel);
        string = this.tTokenizer.getString();
        Vector<String> vector = null;
        if (string.equals("(")) {
            block15: {
                vector = new Vector<String>();
                n = 0;
                do {
                    vector.addElement(this.tTokenizer.getString());
                    ++n;
                    string = this.tTokenizer.getString();
                    if (string.equals(")")) break block15;
                } while (string.equals(","));
                throw Trace.error(1, string);
            }
            string = this.tTokenizer.getString();
        }
        n = 0;
        int n2 = vector == null ? table.getColumnCount() : vector.size();
        if (string.equals("VALUES")) {
            block16: {
                this.tTokenizer.getThis("(");
                object = table.getNewRow();
                int n3 = 0;
                do {
                    int n4;
                    if (vector == null) {
                        n4 = n3;
                        if (n3 > n2) {
                            throw Trace.error(31);
                        }
                    } else {
                        n4 = table.getColumnNr((String)vector.elementAt(n3));
                    }
                    object[n4] = this.getValue(table.getType(n4));
                    ++n3;
                    string = this.tTokenizer.getString();
                    if (string.equals(")")) break block16;
                } while (string.equals(","));
                throw Trace.error(1, string);
            }
            table.insert((Object[])object, this.cChannel);
            n = 1;
        } else if (string.equals("SELECT")) {
            object = this.processSelect();
            Record record = ((Result)object).rRoot;
            Trace.check(n2 == ((Result)object).getColumnCount(), 31);
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            int n5 = 0;
            while (n5 < n2) {
                int n6 = vector == null ? n5 : table.getColumnNr((String)vector.elementAt(n5));
                nArray[n5] = n6;
                nArray2[n5] = table.getType(n6);
                ++n5;
            }
            this.cChannel.beginNestedTransaction();
            try {
                while (record != null) {
                    Object[] objectArray = table.getNewRow();
                    int n7 = 0;
                    while (n7 < n2) {
                        objectArray[nArray[n7]] = Column.convertObject(record.data[n7], nArray2[n7]);
                        ++n7;
                    }
                    table.insert(objectArray, this.cChannel);
                    ++n;
                    record = record.next;
                }
                this.cChannel.endNestedTransaction(false);
            }
            catch (SQLException sQLException) {
                this.cChannel.endNestedTransaction(true);
                throw sQLException;
            }
        } else {
            throw Trace.error(1, string);
        }
        object = new Result();
        ((Result)object).iUpdateCount = n;
        return object;
    }

    private Select parseSelect() throws SQLException {
        Expression expression;
        Expression expression2;
        Select select = new Select();
        String string = this.tTokenizer.getString();
        if (string.equals("DISTINCT")) {
            select.bDistinct = true;
        } else {
            this.tTokenizer.back();
        }
        Vector<Expression> vector = new Vector<Expression>();
        do {
            expression2 = this.parseExpression();
            string = this.tTokenizer.getString();
            if (string.equals("AS")) {
                expression2.setAlias(this.tTokenizer.getName());
                string = this.tTokenizer.getString();
            } else if (this.tTokenizer.wasName()) {
                expression2.setAlias(string);
                string = this.tTokenizer.getString();
            }
            vector.addElement(expression2);
        } while (string.equals(","));
        if (string.equals("INTO")) {
            select.sIntoTable = this.tTokenizer.getString();
            string = this.tTokenizer.getString();
        }
        if (!string.equals("FROM")) {
            throw Trace.error(1, string);
        }
        expression2 = null;
        Vector<TableFilter> vector2 = new Vector<TableFilter>();
        vector2.addElement(this.parseTableFilter(false));
        while (true) {
            if ((string = this.tTokenizer.getString()).equals("LEFT")) {
                string = this.tTokenizer.getString();
                if (string.equals("OUTER")) {
                    string = this.tTokenizer.getString();
                }
                Trace.check(string.equals("JOIN"), 1, string);
                vector2.addElement(this.parseTableFilter(true));
                this.tTokenizer.getThis("ON");
                expression2 = this.addCondition(expression2, this.parseExpression());
                continue;
            }
            if (string.equals("INNER")) {
                this.tTokenizer.getThis("JOIN");
                vector2.addElement(this.parseTableFilter(false));
                this.tTokenizer.getThis("ON");
                expression2 = this.addCondition(expression2, this.parseExpression());
                continue;
            }
            if (!string.equals(",")) break;
            vector2.addElement(this.parseTableFilter(false));
        }
        this.tTokenizer.back();
        int n = vector2.size();
        TableFilter[] tableFilterArray = new TableFilter[n];
        int n2 = 0;
        while (n2 < n) {
            tableFilterArray[n2] = (TableFilter)vector2.elementAt(n2);
            ++n2;
        }
        select.tFilter = tableFilterArray;
        n = vector.size();
        int n3 = 0;
        while (n3 < n) {
            expression = (Expression)vector.elementAt(n3);
            if (expression.getType() == 6) {
                int n4 = n3;
                Table table = null;
                String string2 = expression.getTableName();
                int n5 = 0;
                while (n5 < tableFilterArray.length) {
                    TableFilter tableFilter = tableFilterArray[n5];
                    expression.resolve(tableFilter);
                    if (string2 == null || string2.equals(tableFilter.getName())) {
                        table = tableFilter.getTable();
                        int n6 = table.getColumnCount();
                        int n7 = 0;
                        while (n7 < n6) {
                            Expression expression3 = new Expression(tableFilter.getName(), table.getColumnName(n7));
                            vector.insertElementAt(expression3, n4++);
                            ++n;
                            ++n7;
                        }
                    }
                    ++n5;
                }
                Trace.check(table != null, 3, string2);
                --n;
                vector.removeElementAt(n4);
            }
            ++n3;
        }
        select.iResultLen = n;
        string = this.tTokenizer.getString();
        if (string.equals("WHERE")) {
            expression2 = this.addCondition(expression2, this.parseExpression());
            string = this.tTokenizer.getString();
        }
        select.eCondition = expression2;
        if (string.equals("GROUP")) {
            this.tTokenizer.getThis("BY");
            n = 0;
            do {
                vector.addElement(this.parseExpression());
                string = this.tTokenizer.getString();
                ++n;
            } while (string.equals(","));
            select.iGroupLen = n;
        }
        if (string.equals("ORDER")) {
            this.tTokenizer.getThis("BY");
            n = 0;
            do {
                expression = this.parseExpression();
                string = this.tTokenizer.getString();
                if (string.equals("DESC")) {
                    expression.setDescending();
                    string = this.tTokenizer.getString();
                } else if (string.equals("ASC")) {
                    string = this.tTokenizer.getString();
                }
                vector.addElement(expression);
                ++n;
            } while (string.equals(","));
            select.iOrderLen = n;
        }
        n = vector.size();
        select.eColumn = new Expression[n];
        int n8 = 0;
        while (n8 < n) {
            select.eColumn[n8] = (Expression)vector.elementAt(n8);
            ++n8;
        }
        if (string.equals("UNION")) {
            string = this.tTokenizer.getString();
            if (string.equals("ALL")) {
                select.iUnionType = 2;
            } else {
                select.iUnionType = 1;
                this.tTokenizer.back();
            }
            this.tTokenizer.getThis("SELECT");
            select.sUnion = this.parseSelect();
        } else if (string.equals("INTERSECT")) {
            this.tTokenizer.getThis("SELECT");
            select.iUnionType = 3;
            select.sUnion = this.parseSelect();
        } else if (string.equals("EXCEPT") || string.equals("MINUS")) {
            this.tTokenizer.getThis("SELECT");
            select.iUnionType = 4;
            select.sUnion = this.parseSelect();
        } else {
            this.tTokenizer.back();
        }
        return select;
    }

    private TableFilter parseTableFilter(boolean bl) throws SQLException {
        Object object;
        String string = this.tTokenizer.getString();
        Table table = null;
        if (string.equals("(")) {
            this.tTokenizer.getThis("SELECT");
            object = this.parseSelect();
            Result result = ((Select)object).getResult(0);
            table = new Table(null, "SYSTEM_SUBQUERY", false);
            this.tTokenizer.getThis(")");
            table.addColumns(result);
            table.createPrimaryKey();
            table.insert(result, this.cChannel);
        } else {
            this.cChannel.check(string, 1);
            table = this.dDatabase.getTable(string, this.cChannel);
        }
        object = null;
        string = this.tTokenizer.getString();
        if (string.equals("AS")) {
            object = this.tTokenizer.getName();
        } else if (this.tTokenizer.wasName()) {
            object = string;
        } else {
            this.tTokenizer.back();
        }
        return new TableFilter(table, (String)object, bl);
    }

    private Expression addCondition(Expression expression, Expression expression2) {
        if (expression == null) {
            return expression2;
        }
        if (expression2 == null) {
            return expression;
        }
        return new Expression(28, expression, expression2);
    }

    private Object getValue(int n) throws SQLException {
        Expression expression = this.parseExpression();
        expression.resolve(null);
        return expression.getValue(n);
    }

    private Expression parseExpression() throws SQLException {
        this.read();
        if (this.iToken == 42 || this.iToken == 43 || this.iToken == 40 || this.iToken == 41 || this.iToken == 44) {
            int n = this.iToken;
            this.read();
            Expression expression = new Expression(n, this.readOr(), null);
            this.tTokenizer.back();
            return expression;
        }
        Expression expression = this.readOr();
        this.tTokenizer.back();
        return expression;
    }

    private Expression readOr() throws SQLException {
        Expression expression = this.readAnd();
        while (this.iToken == 29) {
            int n = this.iToken;
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readAnd());
        }
        return expression;
    }

    private Expression readAnd() throws SQLException {
        Expression expression = this.readCondition();
        while (this.iToken == 28) {
            int n = this.iToken;
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readCondition());
        }
        return expression;
    }

    private Expression readCondition() throws SQLException {
        if (this.iToken == 20) {
            int n = this.iToken;
            this.read();
            return new Expression(n, this.readCondition(), null);
        }
        if (this.iToken == 31) {
            int n = this.iToken;
            this.read();
            this.readThis(101);
            Trace.check(this.iToken == 103, 1);
            Expression expression = new Expression(this.parseSelect());
            this.read();
            this.readThis(102);
            return new Expression(n, expression, null);
        }
        Expression expression = this.readConcat();
        boolean bl = false;
        if (this.iToken == 20) {
            bl = true;
            this.read();
        }
        if (this.iToken == 27) {
            this.read();
            Expression expression2 = this.readConcat();
            char c = '\u0000';
            if (this.sToken.equals("ESCAPE")) {
                this.read();
                Expression expression3 = this.readTerm();
                Trace.check(expression3.getType() == 1, 32);
                String string = (String)expression3.getValue(12);
                if (string == null || string.length() < 1) {
                    throw Trace.error(32, string);
                }
                c = string.charAt(0);
            }
            expression = new Expression(27, expression, expression2);
            expression.setLikeEscape(c);
        } else if (this.iToken == 107) {
            this.read();
            Expression expression4 = new Expression(22, expression, this.readConcat());
            this.readThis(28);
            Expression expression5 = new Expression(25, expression, this.readConcat());
            expression = new Expression(28, expression4, expression5);
        } else if (this.iToken == 30) {
            int n = this.iToken;
            this.read();
            this.readThis(101);
            Expression expression6 = null;
            if (this.iToken == 103) {
                expression6 = new Expression(this.parseSelect());
                this.read();
            } else if (this.iToken == 1) {
                Vector<Object> vector = new Vector<Object>();
                while (true) {
                    vector.addElement(Column.convertObject(this.oData, 12));
                    this.read();
                    if (this.iToken != 104) break;
                    this.read();
                }
                expression6 = new Expression(vector);
            }
            this.readThis(102);
            expression = new Expression(n, expression, expression6);
        } else {
            Trace.check(!bl, 1);
            if (Expression.isCompare(this.iToken)) {
                int n = this.iToken;
                this.read();
                return new Expression(n, expression, this.readConcat());
            }
            return expression;
        }
        if (bl) {
            expression = new Expression(20, expression, null);
        }
        return expression;
    }

    private void readThis(int n) throws SQLException {
        Trace.check(this.iToken == n, 1);
        this.read();
    }

    private Expression readConcat() throws SQLException {
        Expression expression = this.readSum();
        while (this.iToken == 106) {
            int n = 15;
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readSum());
        }
        return expression;
    }

    private Expression readSum() throws SQLException {
        Expression expression = this.readFactor();
        while (true) {
            int n;
            if (this.iToken == 100) {
                n = 10;
            } else {
                if (this.iToken != 9) break;
                n = 11;
            }
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readFactor());
        }
        return expression;
    }

    private Expression readFactor() throws SQLException {
        Expression expression = this.readTerm();
        while (this.iToken == 12 || this.iToken == 14 || this.iToken == 50) {
            int n = this.iToken;
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readTerm());
        }
        return expression;
    }

    private Expression readTerm() throws SQLException {
        Expression expression = null;
        if (this.iToken == 2) {
            expression = new Expression(this.sTable, this.sToken);
            this.read();
        } else if (this.iToken == 9) {
            int n = this.iToken;
            this.read();
            expression = new Expression(n, this.readTerm(), null);
        } else if (this.iToken == 100) {
            this.read();
            expression = this.readTerm();
        } else if (this.iToken == 101) {
            this.read();
            expression = this.readOr();
            if (this.iToken != 102) {
                throw Trace.error(1, this.sToken);
            }
            this.read();
        } else if (this.iToken == 1) {
            expression = new Expression(this.iType, this.oData);
            this.read();
        } else if (this.iToken == 103) {
            expression = new Expression(this.parseSelect());
            this.read();
        } else if (this.iToken == 12) {
            expression = new Expression(this.sTable, null);
            this.read();
        } else if (this.iToken == 51 || this.iToken == 52 || this.iToken == 53) {
            int n = this.iToken;
            this.read();
            this.readThis(101);
            expression = new Expression(n, this.readOr(), null);
            this.readThis(102);
        } else if (this.iToken == 54 || this.iToken == 55 || this.iToken == 60 || this.iToken == 91 || this.iToken == 92 || this.iToken == 15) {
            int n = this.iToken;
            this.read();
            this.readThis(101);
            expression = this.readOr();
            this.readThis(104);
            expression = new Expression(n, expression, this.readOr());
            this.readThis(102);
        } else if (this.iToken == 105) {
            this.read();
            this.readThis(101);
            expression = this.readOr();
            this.readThis(104);
            expression = new Expression(56, expression, this.readOr());
            if (this.sToken.equals(",")) {
                this.readThis(104);
                expression = new Expression(54, expression, this.readOr());
            }
            this.readThis(102);
        } else if (this.iToken == 57 || this.iToken == 58 || this.iToken == 59) {
            expression = new Expression(this.iToken, null, null);
            this.read();
            this.readThis(101);
            this.readThis(102);
        } else if (this.iToken == 90) {
            int n = this.iToken;
            this.read();
            this.readThis(101);
            expression = this.readOr();
            this.readThis(104);
            Expression expression2 = this.readOr();
            this.readThis(104);
            expression2 = new Expression(n, expression2, this.readOr());
            expression = new Expression(n, expression, expression2);
            this.readThis(102);
        } else if (this.iToken == 61) {
            int n = this.iToken;
            this.read();
            this.readThis(101);
            expression = this.readOr();
            this.readThis(104);
            int n2 = Column.getTypeNr(this.sToken);
            expression = new Expression(n, expression, null);
            expression.setDataType(n2);
            this.read();
            this.readThis(102);
        } else {
            throw Trace.error(1, this.sToken);
        }
        return expression;
    }

    private void read() throws SQLException {
        this.sToken = this.tTokenizer.getString();
        if (this.tTokenizer.wasValue()) {
            this.iToken = 1;
            this.oData = this.tTokenizer.getAsValue();
            this.iType = this.tTokenizer.getType();
            return;
        }
        if (this.tTokenizer.wasName()) {
            this.iToken = 2;
            this.sTable = null;
            return;
        }
        if (this.tTokenizer.wasLongName()) {
            this.sTable = this.tTokenizer.getLongNameFirst();
            this.sToken = this.tTokenizer.getLongNameLast();
            if (this.sToken.equals("*")) {
                this.iToken = 12;
                return;
            }
            this.iToken = 2;
            return;
        }
        if (this.sToken.equals("")) {
            this.iToken = 108;
            return;
        }
        if (this.sToken.equals("AND")) {
            this.iToken = 28;
            return;
        }
        if (this.sToken.equals("OR")) {
            this.iToken = 29;
            return;
        }
        if (this.sToken.equals("NOT")) {
            this.iToken = 20;
            return;
        }
        if (this.sToken.equals("IN")) {
            this.iToken = 30;
            return;
        }
        if (this.sToken.equals("EXISTS")) {
            this.iToken = 31;
            return;
        }
        if (this.sToken.equals("BETWEEN")) {
            this.iToken = 107;
            return;
        }
        if (this.sToken.equals("+")) {
            this.iToken = 100;
            return;
        }
        if (this.sToken.equals("-")) {
            this.iToken = 9;
            return;
        }
        if (this.sToken.equals("*")) {
            this.iToken = 12;
            this.sTable = null;
            return;
        }
        if (this.sToken.equals("/")) {
            this.iToken = 14;
            return;
        }
        if (this.sToken.equals("||")) {
            this.iToken = 106;
            return;
        }
        if (this.sToken.equals("(")) {
            this.iToken = 101;
            return;
        }
        if (this.sToken.equals(")")) {
            this.iToken = 102;
            return;
        }
        if (this.sToken.equals("SELECT")) {
            this.iToken = 103;
            return;
        }
        if (this.sToken.equals("<")) {
            this.iToken = 24;
            return;
        }
        if (this.sToken.equals("<=")) {
            this.iToken = 25;
            return;
        }
        if (this.sToken.equals(">=")) {
            this.iToken = 22;
            return;
        }
        if (this.sToken.equals(">")) {
            this.iToken = 23;
            return;
        }
        if (this.sToken.equals("=")) {
            this.iToken = 21;
            return;
        }
        if (this.sToken.equals("IS")) {
            this.sToken = this.tTokenizer.getString();
            if (this.sToken.equals("NOT")) {
                this.iToken = 26;
                return;
            }
            this.iToken = 21;
            this.tTokenizer.back();
            return;
        }
        if (this.sToken.equals("<>") || this.sToken.equals("!=")) {
            this.iToken = 26;
            return;
        }
        if (this.sToken.equals("LIKE")) {
            this.iToken = 27;
            return;
        }
        if (this.sToken.equals("COUNT")) {
            this.iToken = 40;
            return;
        }
        if (this.sToken.equals("SUM")) {
            this.iToken = 41;
            return;
        }
        if (this.sToken.equals("MIN")) {
            this.iToken = 42;
            return;
        }
        if (this.sToken.equals("MAX")) {
            this.iToken = 43;
            return;
        }
        if (this.sToken.equals("AVG")) {
            this.iToken = 44;
            return;
        }
        if (this.sToken.equals("MOD")) {
            this.iToken = 50;
            return;
        }
        if (this.sToken.equals("LCASE") || this.sToken.equals("LOWER")) {
            this.iToken = 51;
            return;
        }
        if (this.sToken.equals("UCASE") || this.sToken.equals("UPPER")) {
            this.iToken = 52;
            return;
        }
        if (this.sToken.equals("LENGTH")) {
            this.iToken = 53;
            return;
        }
        if (this.sToken.equals("LEFT")) {
            this.iToken = 54;
            return;
        }
        if (this.sToken.equals("RIGHT")) {
            this.iToken = 55;
            return;
        }
        if (this.sToken.equals("SUBSTRING")) {
            this.iToken = 105;
            return;
        }
        if (this.sToken.equals("CONCAT")) {
            this.iToken = 15;
            return;
        }
        if (this.sToken.equals("CURDATE")) {
            this.iToken = 57;
            return;
        }
        if (this.sToken.equals("CURTIME")) {
            this.iToken = 58;
            return;
        }
        if (this.sToken.equals("NOW")) {
            this.iToken = 59;
            return;
        }
        if (this.sToken.equals("IFNULL")) {
            this.iToken = 60;
            return;
        }
        if (this.sToken.equals("CONVERT")) {
            this.iToken = 61;
            return;
        }
        if (this.sToken.equals("CASEWHEN")) {
            this.iToken = 90;
            return;
        }
        if (this.sToken.equals("BITAND")) {
            this.iToken = 91;
            return;
        }
        if (this.sToken.equals("BITOR")) {
            this.iToken = 92;
            return;
        }
        if (this.sToken.equals(",")) {
            this.iToken = 104;
            return;
        }
        this.iToken = 108;
    }
}

