/*
 * Decompiled with CFR 0.152.
 */
package org.hsql;

import java.sql.SQLException;
import java.util.Vector;
import org.hsql.Access;
import org.hsql.Channel;
import org.hsql.Column;
import org.hsql.DatabaseInformation;
import org.hsql.Index;
import org.hsql.Log;
import org.hsql.Parser;
import org.hsql.Result;
import org.hsql.Table;
import org.hsql.Tokenizer;
import org.hsql.Trace;
import org.hsql.User;

class Database {
    private Access aAccess;
    private Vector tTable = new Vector();
    private DatabaseInformation dInfo;
    private Log lLog;
    private Parser pParser;
    private boolean bReadOnly;
    private boolean bShutdown;

    public Database(String string) throws SQLException {
        this.aAccess = new Access();
        this.dInfo = new DatabaseInformation(this, this.tTable, this.aAccess);
        boolean bl = false;
        Channel channel = new Channel(new User(null, null, true, null), true, false);
        if (string.equals(".")) {
            bl = true;
        } else {
            this.lLog = new Log(this, channel, string);
            bl = this.lLog.open();
        }
        if (bl) {
            this.execute("CREATE USER SA PASSWORD \"\" ADMIN", channel);
        }
    }

    public boolean isShutdown() {
        return this.bShutdown;
    }

    public synchronized Channel connect(String string, String string2) throws SQLException {
        User user = this.aAccess.getUser(string.toUpperCase(), string2.toUpperCase());
        return new Channel(user, true, this.bReadOnly);
    }

    public byte[] execute(String string, String string2, String string3) {
        Result result = null;
        try {
            Channel channel = this.connect(string, string2);
            result = this.execute(string3, channel);
        }
        catch (Exception exception) {
            result = new Result(exception.getMessage());
        }
        try {
            return result.getBytes();
        }
        catch (Exception exception) {
            return new byte[0];
        }
    }

    public synchronized Result execute(String string, Channel channel) {
        Tokenizer tokenizer = new Tokenizer(string);
        Parser parser = new Parser(this, tokenizer, channel);
        Result result = new Result();
        try {
            Trace.check(channel != null, 29);
            Trace.check(!this.bShutdown, 42);
            while (true) {
                int n = tokenizer.getPosition();
                boolean bl = false;
                String string2 = tokenizer.getString();
                if (string2.equals("")) {
                    return result;
                }
                if (string2.equals("SELECT")) {
                    result = parser.processSelect();
                } else if (string2.equals("INSERT")) {
                    result = parser.processInsert();
                } else if (string2.equals("UPDATE")) {
                    result = parser.processUpdate();
                } else if (string2.equals("DELETE")) {
                    result = parser.processDelete();
                } else if (string2.equals("CREATE")) {
                    result = this.processCreate(tokenizer, channel);
                    bl = true;
                } else if (string2.equals("DROP")) {
                    result = this.processDrop(tokenizer, channel);
                    bl = true;
                } else if (string2.equals("GRANT")) {
                    result = this.processGrantOrRevoke(tokenizer, channel, true);
                    bl = true;
                } else if (string2.equals("REVOKE")) {
                    result = this.processGrantOrRevoke(tokenizer, channel, false);
                    bl = true;
                } else if (string2.equals("CONNECT")) {
                    result = this.processConnect(tokenizer, channel);
                    bl = true;
                } else if (string2.equals("SET")) {
                    result = this.processSet(tokenizer, channel);
                    bl = true;
                } else if (string2.equals("SCRIPT")) {
                    result = this.processScript(tokenizer, channel);
                } else if (string2.equals("COMMIT")) {
                    result = this.processCommit(tokenizer, channel);
                } else if (string2.equals("ROLLBACK")) {
                    result = this.processRollback(tokenizer, channel);
                } else if (string2.equals("SHUTDOWN")) {
                    result = this.processShutdown(tokenizer, channel);
                } else if (string2.equals("CHECKPOINT")) {
                    result = this.processCheckpoint(channel);
                } else if (!string2.equals(";")) {
                    throw Trace.error(0, string2);
                }
                if (!bl || this.lLog == null) continue;
                int n2 = tokenizer.getPosition();
                this.lLog.write(tokenizer.getPart(n, n2));
            }
        }
        catch (SQLException sQLException) {
            return new Result(String.valueOf(sQLException.getMessage()) + " in statement [" + string + "]");
        }
    }

    void setReadOnly() {
        this.bReadOnly = true;
    }

    Vector getTables() {
        return this.tTable;
    }

    Log getLog() {
        return this.lLog;
    }

    Table getTable(String string, Channel channel) throws SQLException {
        Table table = null;
        int n = 0;
        while (n < this.tTable.size()) {
            table = (Table)this.tTable.elementAt(n);
            if (table.getName().equals(string)) {
                return table;
            }
            ++n;
        }
        table = this.dInfo.getSystemTable(string, channel);
        if (table == null) {
            throw Trace.error(3, string);
        }
        return table;
    }

    Result getScript(boolean bl, boolean bl2, boolean bl3, Channel channel) throws SQLException {
        return this.dInfo.getScript(bl, bl2, bl3, channel);
    }

    void linkTable(Table table) throws SQLException {
        String string = table.getName();
        int n = 0;
        while (n < this.tTable.size()) {
            Table table2 = (Table)this.tTable.elementAt(n);
            if (table2.getName().equals(string)) {
                throw Trace.error(2, string);
            }
            ++n;
        }
        this.tTable.addElement(table);
    }

    private Result processScript(Tokenizer tokenizer, Channel channel) throws SQLException {
        String string = tokenizer.getString();
        if (tokenizer.wasValue()) {
            string = (String)tokenizer.getAsValue();
            Log.scriptToFile(this, string, true, channel);
            return new Result();
        }
        tokenizer.back();
        return this.getScript(true, true, false, channel);
    }

    private Result processCreate(Tokenizer tokenizer, Channel channel) throws SQLException {
        channel.checkReadWrite();
        channel.checkAdmin();
        String string = tokenizer.getString();
        if (string.equals("TABLE")) {
            this.processCreateTable(tokenizer, channel, false);
        } else if (string.equals("MEMORY")) {
            tokenizer.getThis("TABLE");
            this.processCreateTable(tokenizer, channel, false);
        } else if (string.equals("CACHED")) {
            tokenizer.getThis("TABLE");
            this.processCreateTable(tokenizer, channel, true);
        } else if (string.equals("USER")) {
            String string2 = tokenizer.getStringToken();
            tokenizer.getThis("PASSWORD");
            String string3 = tokenizer.getStringToken();
            boolean bl = tokenizer.getString().equals("ADMIN");
            this.aAccess.createUser(string2, string3, bl);
        } else {
            boolean bl = false;
            if (string.equals("UNIQUE")) {
                bl = true;
                string = tokenizer.getString();
            }
            if (!string.equals("INDEX")) {
                throw Trace.error(1, string);
            }
            String string4 = tokenizer.getName();
            tokenizer.getThis("ON");
            Table table = this.getTable(tokenizer.getString(), channel);
            this.addIndexOn(tokenizer, channel, string4, table, bl);
        }
        return new Result();
    }

    private void addIndexOn(Tokenizer tokenizer, Channel channel, String string, Table table, boolean bl) throws SQLException {
        Vector<String> vector;
        block3: {
            String string2;
            vector = new Vector<String>();
            tokenizer.getThis("(");
            do {
                vector.addElement(tokenizer.getString());
                string2 = tokenizer.getString();
                if (string2.equals(")")) break block3;
            } while (string2.equals(","));
            throw Trace.error(1, string2);
        }
        int n = vector.size();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = table.getColumnNr((String)vector.elementAt(n2));
            ++n2;
        }
        channel.commit();
        if (table.isEmpty()) {
            table.createIndex(nArray, string, bl);
            return;
        }
        Table table2 = this.copyTable(table, null);
        table2.createIndex(nArray, string, bl);
        table2.moveData(table);
        this.dropTable(table.getName());
        this.linkTable(table2);
    }

    private void processCreateTable(Tokenizer tokenizer, Channel channel, boolean bl) throws SQLException {
        Table table;
        block17: {
            String string;
            boolean bl2;
            String string2 = tokenizer.getName();
            table = bl && this.lLog != null ? new Table(this.lLog, string2, true) : new Table(this.lLog, string2, false);
            tokenizer.getThis("(");
            int n = -1;
            int n2 = 0;
            boolean bl3 = false;
            while (true) {
                bl2 = false;
                string2 = tokenizer.getString();
                if (string2.equals("CONSTRAINT") || string2.equals("PRIMARY")) {
                    tokenizer.back();
                    bl3 = true;
                    break;
                }
                string = string2;
                int n3 = Column.getTypeNr(tokenizer.getString());
                string2 = tokenizer.getString();
                if (n3 == 8 && string2.equals("PRECISION")) {
                    string2 = tokenizer.getString();
                }
                if (string2.equals("(")) {
                    while (!(string2 = tokenizer.getString()).equals(")")) {
                    }
                    string2 = tokenizer.getString();
                }
                boolean bl4 = true;
                if (string2.equals("NULL")) {
                    string2 = tokenizer.getString();
                } else if (string2.equals("NOT")) {
                    tokenizer.getThis("NULL");
                    bl4 = false;
                    string2 = tokenizer.getString();
                }
                if (string2.equals("IDENTITY")) {
                    bl2 = true;
                    Trace.check(n == -1, 8, string);
                    string2 = tokenizer.getString();
                    n = n2;
                }
                if (string2.equals("PRIMARY")) {
                    tokenizer.getThis("KEY");
                    Trace.check(bl2 || n == -1, 8, string);
                    n = n2;
                    string2 = tokenizer.getString();
                }
                table.addColumn(string, n3, bl4, bl2);
                if (string2.equals(")")) break;
                if (!string2.equals(",")) {
                    throw Trace.error(1, string2);
                }
                ++n2;
            }
            if (n != -1) {
                table.createPrimaryKey(n);
            } else {
                table.createPrimaryKey();
            }
            if (bl3) {
                bl2 = false;
                do {
                    string2 = tokenizer.getString();
                    string = "SYSTEM_CONSTRAINT" + (int)(bl2 ? 1 : 0);
                    bl2 += 1;
                    if (string2.equals("CONSTRAINT")) {
                        string = tokenizer.getString();
                        string2 = tokenizer.getString();
                    }
                    if (string2.equals("PRIMARY")) {
                        tokenizer.getThis("KEY");
                        this.addIndexOn(tokenizer, channel, string, table, true);
                    }
                    if ((string2 = tokenizer.getString()).equals(")")) break block17;
                } while (string2.equals(","));
                throw Trace.error(1, string2);
            }
        }
        channel.commit();
        this.linkTable(table);
    }

    private Result processDrop(Tokenizer tokenizer, Channel channel) throws SQLException {
        channel.checkReadWrite();
        channel.checkAdmin();
        String string = tokenizer.getString();
        if (string.equals("TABLE")) {
            this.dropTable(tokenizer.getString());
            channel.commit();
        } else if (string.equals("USER")) {
            this.aAccess.dropUser(tokenizer.getStringToken());
        } else if (string.equals("INDEX")) {
            string = tokenizer.getString();
            if (!tokenizer.wasLongName()) {
                throw Trace.error(1, string);
            }
            String string2 = tokenizer.getLongNameFirst();
            String string3 = tokenizer.getLongNameLast();
            Table table = this.getTable(string2, channel);
            table.checkDropIndex(string3);
            Table table2 = this.copyTable(table, string3);
            table2.moveData(table);
            this.dropTable(string2);
            this.linkTable(table2);
            channel.commit();
        } else {
            throw Trace.error(1, string);
        }
        return new Result();
    }

    private Table copyTable(Table table, String string) throws SQLException {
        Table table2 = new Table(this.lLog, table.getName(), table.isCached());
        int n = 0;
        while (n < table.getColumnCount()) {
            table2.addColumn(table.getColumn(n));
            ++n;
        }
        int n2 = table.getPrimaryIndex().getColumns()[0];
        if (n2 >= table.getColumnCount()) {
            table2.createPrimaryKey();
        } else {
            table2.createPrimaryKey(n2);
        }
        Index index = null;
        while ((index = table.getNextIndex(index)) != null) {
            if (string != null && index.getName().equals(string) || index == table.getPrimaryIndex()) continue;
            table2.createIndex(index);
        }
        return table2;
    }

    private Result processGrantOrRevoke(Tokenizer tokenizer, Channel channel, boolean bl) throws SQLException {
        String string;
        String string2;
        channel.checkReadWrite();
        channel.checkAdmin();
        int n = 0;
        do {
            string = tokenizer.getString();
            n |= Access.getRight(string);
        } while ((string2 = tokenizer.getString()).equals(","));
        if (!string2.equals("ON")) {
            throw Trace.error(1, string2);
        }
        string = tokenizer.getString();
        this.getTable(string, channel);
        tokenizer.getThis("TO");
        String string3 = tokenizer.getStringToken();
        if (bl) {
            this.aAccess.grant(string3, string, n);
            String string4 = "GRANT";
        } else {
            this.aAccess.revoke(string3, string, n);
            String string5 = "REVOKE";
        }
        return new Result();
    }

    private Result processConnect(Tokenizer tokenizer, Channel channel) throws SQLException {
        tokenizer.getThis("USER");
        String string = tokenizer.getStringToken();
        tokenizer.getThis("PASSWORD");
        String string2 = tokenizer.getStringToken();
        User user = this.aAccess.getUser(string, string2);
        channel.commit();
        channel.setUser(user);
        return new Result();
    }

    private Result processSet(Tokenizer tokenizer, Channel channel) throws SQLException {
        String string = tokenizer.getString();
        if (string.equals("PASSWORD")) {
            channel.checkReadWrite();
            channel.setPassword(tokenizer.getStringToken());
        } else if (string.equals("READONLY")) {
            channel.commit();
            channel.setReadOnly(this.processTrueOrFalse(tokenizer));
        } else if (string.equals("LOGSIZE")) {
            channel.checkAdmin();
            int n = Integer.parseInt(tokenizer.getString());
            if (this.lLog != null) {
                this.lLog.setLogSize(n);
            }
        } else if (string.equals("IGNORECASE")) {
            channel.checkAdmin();
            Column.bIgnoreCase = this.processTrueOrFalse(tokenizer);
        } else if (string.equals("MAXROWS")) {
            int n = Integer.parseInt(tokenizer.getString());
            channel.setMaxRows(n);
        } else if (string.equals("AUTOCOMMIT")) {
            channel.setAutoCommit(this.processTrueOrFalse(tokenizer));
        } else if (string.equals("TABLE")) {
            channel.checkReadWrite();
            channel.checkAdmin();
            Table table = this.getTable(tokenizer.getString(), channel);
            tokenizer.getThis("INDEX");
            tokenizer.getString();
            table.setIndexRoots((String)tokenizer.getAsValue());
        } else {
            throw Trace.error(1, string);
        }
        return new Result();
    }

    private boolean processTrueOrFalse(Tokenizer tokenizer) throws SQLException {
        String string = tokenizer.getString();
        if (string.equals("TRUE")) {
            return true;
        }
        if (string.equals("FALSE")) {
            return false;
        }
        throw Trace.error(1, string);
    }

    private Result processCommit(Tokenizer tokenizer, Channel channel) throws SQLException {
        String string = tokenizer.getString();
        if (!string.equals("WORK")) {
            tokenizer.back();
        }
        channel.commit();
        return new Result();
    }

    private Result processRollback(Tokenizer tokenizer, Channel channel) throws SQLException {
        String string = tokenizer.getString();
        if (!string.equals("WORK")) {
            tokenizer.back();
        }
        channel.rollback();
        return new Result();
    }

    private Result processShutdown(Tokenizer tokenizer, Channel channel) throws SQLException {
        channel.checkAdmin();
        if (this.lLog != null) {
            if (tokenizer.getString().equals("IMMEDIATELY")) {
                this.lLog.shutdown();
            } else {
                tokenizer.back();
                this.lLog.close();
            }
            this.lLog = null;
        }
        this.bShutdown = true;
        return new Result();
    }

    private Result processCheckpoint(Channel channel) throws SQLException {
        channel.checkAdmin();
        if (this.lLog != null) {
            this.lLog.checkpoint();
        }
        return new Result();
    }

    private void dropTable(String string) throws SQLException {
        int n = 0;
        while (n < this.tTable.size()) {
            Table table = (Table)this.tTable.elementAt(n);
            if (table.getName().equals(string)) {
                this.tTable.removeElementAt(n);
                return;
            }
            ++n;
        }
        throw Trace.error(3, string);
    }
}

