/*
 * Decompiled with CFR 0.152.
 */
package org.hsql;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.SQLException;
import org.hsql.CacheFree;
import org.hsql.Row;
import org.hsql.Table;
import org.hsql.Trace;

class Cache {
    private RandomAccessFile rFile;
    private static final int LENGTH = 1024;
    private static final int MAXCACHESIZE = 10240;
    private Row[] rData;
    private Row[] rWriter;
    private Row rFirst;
    private Row rLastChecked;
    private String sName;
    private static final int MASK = 1023;
    private int iFreePos;
    private static final int FREEPOSPOS = 16;
    private CacheFree fRoot;
    private int iFreeCount;
    private int iCacheSize;

    Cache(String string) {
        this.sName = string;
        this.rData = new Row[1024];
        this.rWriter = new Row[1024];
        this.iFreePos = 32;
    }

    void open(boolean bl) throws SQLException {
        try {
            boolean bl2 = false;
            if (new File(this.sName).exists()) {
                bl2 = true;
            }
            this.rFile = new RandomAccessFile(this.sName, bl ? "r" : "rw");
            if (bl2) {
                this.rFile.seek(16L);
                this.iFreePos = this.rFile.readInt();
                return;
            }
        }
        catch (Exception exception) {
            throw Trace.error(35, "error " + exception + " opening " + this.sName);
        }
    }

    void flush() throws SQLException {
        try {
            this.rFile.seek(16L);
            this.rFile.writeInt(this.iFreePos);
            this.saveAll();
            this.rFile.close();
            return;
        }
        catch (Exception exception) {
            throw Trace.error(35, "error " + exception + " closing " + this.sName);
        }
    }

    void shutdown() throws SQLException {
        try {
            this.rFile.close();
            return;
        }
        catch (Exception exception) {
            throw Trace.error(35, "error " + exception + " in shutdown " + this.sName);
        }
    }

    void free(Row row, int n, int n2) throws SQLException {
        ++this.iFreeCount;
        CacheFree cacheFree = new CacheFree();
        cacheFree.iPos = n;
        cacheFree.iLength = n2;
        if (this.iFreeCount > 1024) {
            this.iFreeCount = 0;
        } else {
            cacheFree.fNext = this.fRoot;
        }
        this.fRoot = cacheFree;
        this.remove(row);
    }

    void add(Row row) throws SQLException {
        int n;
        Row row2;
        int n2 = row.iSize;
        CacheFree cacheFree = this.fRoot;
        CacheFree cacheFree2 = null;
        int n3 = this.iFreePos;
        while (cacheFree != null) {
            if (cacheFree.iLength >= n2) {
                n3 = cacheFree.iPos;
                if ((n2 = cacheFree.iLength - n2) < 8) {
                    if (cacheFree2 == null) {
                        this.fRoot = cacheFree.fNext;
                    } else {
                        cacheFree2.fNext = cacheFree.fNext;
                    }
                    --this.iFreeCount;
                    break;
                }
                cacheFree.iLength = n2;
                break;
            }
            cacheFree2 = cacheFree;
            cacheFree = cacheFree.fNext;
        }
        row.iPos = n3;
        if (n3 == this.iFreePos) {
            this.iFreePos += n2;
        }
        if ((row2 = this.rData[n = n3 & 0x3FF]) == null) {
            row2 = this.rFirst;
        }
        row.insert(row2);
        ++this.iCacheSize;
        this.rData[n] = row;
        this.rFirst = row;
    }

    Row getRow(int n, Table table) throws SQLException {
        Row row;
        Row row2;
        int n2 = n & 0x3FF;
        Row row3 = row2 = this.rData[n2];
        while (row2 != null) {
            int n3 = row2.iPos;
            if (n3 == n) {
                return row2;
            }
            if ((n3 & 0x3FF) != n2 || (row2 = row2.rNext) == row3) break;
        }
        if ((row = this.rData[n2]) == null) {
            row = this.rFirst;
        }
        try {
            this.rFile.seek(n);
            int n4 = this.rFile.readInt();
            byte[] byArray = new byte[n4];
            this.rFile.read(byArray);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            row2 = new Row(table, dataInputStream, n, row);
            row2.iSize = n4;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw Trace.error(35, "reading: " + iOException);
        }
        ++this.iCacheSize;
        this.rData[n2] = row2;
        this.rFirst = row2;
        return row2;
    }

    void cleanUp() throws SQLException {
        if (this.iCacheSize < 10240) {
            return;
        }
        int n = 0;
        while (this.iCacheSize + 1024 > 10240 && 16 * n < 1024) {
            Row row = this.getWorst();
            if (row == null) {
                return;
            }
            if (row.bChanged) {
                this.rWriter[n++] = row;
                continue;
            }
            if (row.isRoot()) continue;
            this.remove(row);
        }
        if (n != 0) {
            this.saveSorted(this.rWriter, n);
        }
        int n2 = 0;
        while (n2 < n) {
            Row row = this.rWriter[n2];
            if (!row.isRoot()) {
                this.remove(row);
            }
            this.rWriter[n2] = null;
            ++n2;
        }
    }

    private void remove(Row row) throws SQLException {
        int n;
        if (row == this.rLastChecked) {
            this.rLastChecked = this.rLastChecked.rNext;
            if (this.rLastChecked == row) {
                this.rLastChecked = null;
            }
        }
        if (this.rData[n = row.iPos & 0x3FF] == row) {
            Row row2;
            this.rFirst = row2 = row.rNext;
            if ((row2.iPos & 0x3FF) != n) {
                row2 = null;
            }
            this.rData[n] = row2;
        }
        if (row == this.rFirst) {
            this.rFirst = this.rFirst.rNext;
            if (row == this.rFirst) {
                this.rFirst = null;
            }
        }
        row.free();
        --this.iCacheSize;
    }

    private Row getWorst() throws SQLException {
        Row row;
        if (this.rLastChecked == null) {
            this.rLastChecked = this.rFirst;
        }
        if ((row = this.rLastChecked) == null) {
            return null;
        }
        Row row2 = row;
        int n = Row.iCurrentAccess;
        int n2 = 0;
        while (n2 < 3) {
            int n3 = row.iLastAccess;
            if (n3 < n) {
                row2 = row;
                n = n3;
            }
            row = row.rNext;
            ++n2;
        }
        row2.iLastAccess = Row.iCurrentAccess++;
        this.rLastChecked = row.rNext;
        return row2;
    }

    private void saveAll() throws SQLException {
        if (this.rFirst == null) {
            return;
        }
        Row row = this.rFirst;
        block0: while (true) {
            int n = 0;
            Row row2 = row;
            do {
                if (!row.bChanged) continue;
                this.rWriter[n++] = row;
            } while ((row = row.rNext) != row2 && n < 1024);
            if (n == 0) {
                return;
            }
            this.saveSorted(this.rWriter, n);
            int n2 = 0;
            while (true) {
                if (n2 >= n) continue block0;
                this.rWriter[n2] = null;
                ++n2;
            }
            break;
        }
    }

    private void saveSorted(Row[] rowArray, int n) throws SQLException {
        Cache.sort(this.rWriter, 0, n - 1);
        try {
            int n2 = 0;
            while (n2 < n) {
                this.rFile.seek(this.rWriter[n2].iPos);
                this.rFile.write(this.rWriter[n2].write());
                ++n2;
            }
            return;
        }
        catch (Exception exception) {
            throw Trace.error(35, "saveSorted " + exception);
        }
    }

    private static final void sort(Row[] rowArray, int n, int n2) throws SQLException {
        int n3;
        int n4;
        while (n2 - n > 10) {
            n4 = n2 + n >> 1;
            if (rowArray[n].iPos > rowArray[n2].iPos) {
                Cache.swap(rowArray, n, n2);
            }
            if (rowArray[n4].iPos < rowArray[n].iPos) {
                Cache.swap(rowArray, n, n4);
            } else if (rowArray[n4].iPos > rowArray[n2].iPos) {
                Cache.swap(rowArray, n4, n2);
            }
            n3 = n2 - 1;
            Cache.swap(rowArray, n4, n3);
            int n5 = rowArray[n3].iPos;
            n4 = n;
            while (true) {
                if (rowArray[++n4].iPos < n5) {
                    continue;
                }
                while (rowArray[--n3].iPos > n5) {
                }
                if (n4 >= n3) break;
                Cache.swap(rowArray, n4, n3);
            }
            Cache.swap(rowArray, n4, n2 - 1);
            Cache.sort(rowArray, n, n4 - 1);
            n = n4 + 1;
        }
        n4 = n + 1;
        while (n4 <= n2) {
            Row row = rowArray[n4];
            n3 = n4 - 1;
            while (n3 >= n && rowArray[n3].iPos > row.iPos) {
                rowArray[n3 + 1] = rowArray[n3];
                --n3;
            }
            rowArray[n3 + 1] = row;
            ++n4;
        }
    }

    private static void swap(Row[] rowArray, int n, int n2) {
        Row row = rowArray[n];
        rowArray[n] = rowArray[n2];
        rowArray[n2] = row;
    }
}

