/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.Statement;
import org.hsql.Profile;
import org.hsql.jdbcDriver;
import sun.jdbc.odbc.JdbcOdbcDriver;

class PerformanceTest {
    public static void main(String[] stringArray) {
        PerformanceTest.test();
    }

    static long getTime() {
        return System.currentTimeMillis();
    }

    static void test() {
        try {
            DriverManager.registerDriver(new jdbcDriver());
            DriverManager.registerDriver((Driver)new JdbcOdbcDriver());
            PerformanceTest.test("Hypersonic SQL (file)", "HypersonicSQL:test3", "sa", "", true);
            PerformanceTest.test("Hypersonic SQL (local)", "HypersonicSQL:.", "sa", "", true);
            PerformanceTest.test("Local InterBase Server", "odbc:TestInterBase", "SA", "sa", false);
            Profile.listUnvisited();
            return;
        }
        catch (Exception exception) {
            System.out.println("PerformanceTest error: " + exception.getMessage());
            return;
        }
    }

    static void test(String string, String string2, String string3, String string4, boolean bl) {
        System.out.println(string);
        Statement statement = null;
        Connection connection = null;
        try {
            connection = DriverManager.getConnection("jdbc:" + string2, string3, string4);
            statement = connection.createStatement();
        }
        catch (Exception exception) {
            System.out.println("PerformanceTest init error: " + exception.getMessage());
        }
        try {
            statement.execute("drop table Test");
        }
        catch (Exception exception) {}
        String string5 = "";
        try {
            if (bl) {
                string5 = "create table Test(Nr integer Primary Key,Name varchar(20),ZIP integer)";
            } else {
                string5 = "create table Test(Nr integer,Name varchar(20),ZIP integer)";
                statement.execute(string5);
                string5 = "create unique index iNr on Test(Nr)";
            }
            statement.execute(string5);
            statement.execute("create index iZIP on Test(ZIP)");
            long l = PerformanceTest.getTime();
            int n = 0;
            while (n < 1000) {
                statement.executeQuery("select * from Test");
                ++n;
            }
            PerformanceTest.printTime("SELECT 1000*EMPTY", PerformanceTest.getTime() - l);
            l = PerformanceTest.getTime();
            int n2 = 0;
            while (n2 < 1000) {
                string5 = "insert into Test values(" + n2 + "," + "'Kurt" + n2 + "',59" + n2 % 100 + n2 / 100 + ")";
                statement.execute(string5);
                ++n2;
            }
            PerformanceTest.printTime("INSERT 1000*1 record", PerformanceTest.getTime() - l);
            l = PerformanceTest.getTime();
            int n3 = 0;
            while (n3 < 1000) {
                string5 = "select * from Test where Nr=" + n3;
                statement.executeQuery(string5);
                ++n3;
            }
            PerformanceTest.printTime("SELECT 1000*1 record", PerformanceTest.getTime() - l);
            l = PerformanceTest.getTime();
            int n4 = 0;
            while (n4 < 1000) {
                string5 = "select * from Test where Nr>" + n4 + " and Nr<" + (n4 + 100);
                statement.executeQuery(string5);
                ++n4;
            }
            PerformanceTest.printTime("SELECT 1000*100 records", PerformanceTest.getTime() - l);
            l = PerformanceTest.getTime();
            int n5 = 0;
            while (n5 < 100) {
                string5 = "update Test set Name='Hans" + n5 + "' where Nr=" + n5;
                statement.execute(string5);
                ++n5;
            }
            PerformanceTest.printTime("UPDATE 100*1 record", PerformanceTest.getTime() - l);
            l = PerformanceTest.getTime();
            int n6 = 0;
            while (n6 < 1000) {
                string5 = "delete from Test where ZIP=59" + n6 % 100 + n6 / 100;
                statement.execute(string5);
                ++n6;
            }
            PerformanceTest.printTime("DELETE 1000*1 record", PerformanceTest.getTime() - l);
            connection.close();
            return;
        }
        catch (Exception exception) {
            System.out.println("PerformanceTest error: " + exception);
            System.out.println("with SQL command: " + string5);
            exception.printStackTrace();
            return;
        }
    }

    static void printTime(String string, long l) {
        string = String.valueOf((String.valueOf(string) + "                        ").substring(0, 24)) + ": ";
        System.out.println(String.valueOf(string) + (double)l / 1000.0);
    }

    PerformanceTest() {
    }
}

