/*
 * Decompiled with CFR 0.152.
 */
package Free.DBPool;

import Free.DBPool.ConnectionReaper;
import Free.DBPool.JDCConnection;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;

public class JDCConnectionPool {
    private Vector connections;
    private String url;
    private String user;
    private String password;
    private final long timeout = 60000L;
    private ConnectionReaper reaper;
    private final int poolsize = 10;

    public JDCConnectionPool(String string, String string2, String string3) {
        this.url = string;
        this.user = string2;
        this.password = string3;
        this.connections = new Vector(10);
        this.reaper = new ConnectionReaper(this);
        this.reaper.start();
    }

    public synchronized void reapConnections() {
        long l = System.currentTimeMillis() - 60000L;
        Enumeration enumeration = this.connections.elements();
        while (enumeration != null && enumeration.hasMoreElements()) {
            JDCConnection jDCConnection = (JDCConnection)enumeration.nextElement();
            if (!jDCConnection.inUse() || l <= jDCConnection.getLastUse() || jDCConnection.validate()) continue;
            this.removeConnection(jDCConnection);
        }
    }

    public synchronized void closeConnections() {
        Enumeration enumeration = this.connections.elements();
        while (enumeration != null && enumeration.hasMoreElements()) {
            JDCConnection jDCConnection = (JDCConnection)enumeration.nextElement();
            this.removeConnection(jDCConnection);
        }
    }

    private synchronized void removeConnection(JDCConnection jDCConnection) {
        this.connections.removeElement(jDCConnection);
    }

    public synchronized Connection getConnection() throws SQLException {
        JDCConnection jDCConnection;
        int n = 0;
        while (n < this.connections.size()) {
            jDCConnection = (JDCConnection)this.connections.elementAt(n);
            if (jDCConnection.lease()) {
                return jDCConnection;
            }
            ++n;
        }
        Connection connection = DriverManager.getConnection(this.url, this.user, this.password);
        jDCConnection = new JDCConnection(connection, this);
        jDCConnection.lease();
        this.connections.addElement(jDCConnection);
        return jDCConnection;
    }

    public synchronized void returnConnection(JDCConnection jDCConnection) {
        jDCConnection.expireLease();
    }
}

