/*
 * FREE 2000
 *
 * Copyright (c) Jason Kitcat, University of Warwick
 *
 * jeep@thecouch.org   http://www.thecouch.org/free/
 *
 * Knoll Cottage, Sutton Place, Nr.Abinger, Dorking, Surrey RH5 6RN United Kingdom
 *
 * Tel: 07956 886 508  Fax: 0870 052 7114
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (gpl.txt); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package FreeTest;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.text.*;
import java.util.*;

public class TestFrame1 extends JFrame 
{

// IMPORTANT: Source code between BEGIN/END comment pair will be regenerated
// every time the form is saved. All manual changes will be overwritten.
// BEGIN GENERATED CODE
	// member declarations
	javax.swing.JScrollPane jScrollPane1 = new javax.swing.JScrollPane();
	javax.swing.JTextPane jTextPane1 = new javax.swing.JTextPane();
	javax.swing.JButton jButton1 = new javax.swing.JButton();
	javax.swing.JButton jButton2 = new javax.swing.JButton();
	javax.swing.JScrollPane jScrollPane2 = new javax.swing.JScrollPane();
	javax.swing.JTextPane jTextPane2 = new javax.swing.JTextPane();
	javax.swing.JLabel jLabel1 = new javax.swing.JLabel();
	javax.swing.JLabel jLabel2 = new javax.swing.JLabel();
	javax.swing.JButton jButton3 = new javax.swing.JButton();
	javax.swing.JButton jButton4 = new javax.swing.JButton();
	javax.swing.JTextField jTextField1 = new javax.swing.JTextField();
	javax.swing.JLabel jLabel3 = new javax.swing.JLabel();
	javax.swing.JButton jButton5 = new javax.swing.JButton();
	javax.swing.JButton jButton6 = new javax.swing.JButton();
	javax.swing.JButton jButton7 = new javax.swing.JButton();
	javax.swing.JButton jButton8 = new javax.swing.JButton();
	javax.swing.JButton jButton9 = new javax.swing.JButton();
// END GENERATED CODE

	public TestFrame1()
	{
	}

	public void initComponents() throws Exception
	{
// IMPORTANT: Source code between BEGIN/END comment pair will be regenerated
// every time the form is saved. All manual changes will be overwritten.
// BEGIN GENERATED CODE
		// the following code sets the frame's initial state
		jScrollPane1.setLocation(new java.awt.Point(10, 20));
		jScrollPane1.setVisible(true);
		jScrollPane1.setSize(new java.awt.Dimension(250, 380));
		jScrollPane1.getViewport().add(jTextPane1);

		jTextPane1.setVisible(true);

		jButton1.setText("Vote Boundary Tests");
		jButton1.setLocation(new java.awt.Point(270, 20));
		jButton1.setVisible(true);
		jButton1.setToolTipText("Keep clicking to rotate through tests");
		jButton1.setSize(new java.awt.Dimension(170, 20));

		jButton2.setText("Vote Stamp Tests");
		jButton2.setLocation(new java.awt.Point(270, 50));
		jButton2.setVisible(true);
		jButton2.setToolTipText("Keep clicking to rotate through tests");
		jButton2.setSize(new java.awt.Dimension(170, 20));

		jScrollPane2.setLocation(new java.awt.Point(450, 20));
		jScrollPane2.setVisible(true);
		jScrollPane2.setSize(new java.awt.Dimension(250, 380));
		jScrollPane2.getViewport().add(jTextPane2);

		jTextPane2.setVisible(true);

		jLabel1.setText("Test Results");
		jLabel1.setLocation(new java.awt.Point(450, 0));
		jLabel1.setVisible(true);
		jLabel1.setSize(new java.awt.Dimension(170, 20));

		jLabel2.setText("Status");
		jLabel2.setLocation(new java.awt.Point(10, 0));
		jLabel2.setVisible(true);
		jLabel2.setSize(new java.awt.Dimension(140, 20));

		jButton3.setText("Vote MAC Tests");
		jButton3.setLocation(new java.awt.Point(270, 80));
		jButton3.setVisible(true);
		jButton3.setToolTipText("Keep clicking to rotate through tests");
		jButton3.setSize(new java.awt.Dimension(170, 20));

		jButton4.setText("Vote Stress Test");
		jButton4.setLocation(new java.awt.Point(270, 270));
		jButton4.setVisible(true);
		jButton4.setSize(new java.awt.Dimension(170, 20));

		jTextField1.setLocation(new java.awt.Point(390, 240));
		jTextField1.setVisible(true);
		jTextField1.setSize(new java.awt.Dimension(50, 20));

		jLabel3.setText("No. of connections");
		jLabel3.setLocation(new java.awt.Point(270, 240));
		jLabel3.setVisible(true);
		jLabel3.setSize(new java.awt.Dimension(120, 20));

		jButton5.setText("ER Boundary Tests");
		jButton5.setLocation(new java.awt.Point(270, 110));
		jButton5.setVisible(true);
		jButton5.setToolTipText("Keep clicking to rotate through tests");
		jButton5.setSize(new java.awt.Dimension(170, 20));

		jButton6.setText("ER Auth Tests");
		jButton6.setLocation(new java.awt.Point(270, 140));
		jButton6.setVisible(true);
		jButton6.setToolTipText("Keep clicking to rotate through tests");
		jButton6.setSize(new java.awt.Dimension(170, 20));

		jButton7.setText("ER MAC Tests");
		jButton7.setLocation(new java.awt.Point(270, 170));
		jButton7.setVisible(true);
		jButton7.setToolTipText("Keep clicking to rotate through tests");
		jButton7.setSize(new java.awt.Dimension(170, 20));

		jButton9.setText("ER AuthKey Tests");
		jButton9.setLocation(new java.awt.Point(270, 200));
		jButton9.setVisible(true);
		jButton9.setToolTipText("Keep clicking to rotate through tests");
		jButton9.setSize(new java.awt.Dimension(170, 20));

		jButton8.setText("ER Stress Test");
		jButton8.setLocation(new java.awt.Point(270, 300));
		jButton8.setVisible(true);
		jButton8.setSize(new java.awt.Dimension(170, 20));

		setLocation(new java.awt.Point(0, 0));
		setTitle("FREE: Test Suite");
		getContentPane().setLayout(null);
		setSize(new java.awt.Dimension(710, 400));
		getContentPane().add(jScrollPane1);
		getContentPane().add(jButton1);
		getContentPane().add(jButton2);
		getContentPane().add(jScrollPane2);
		getContentPane().add(jLabel1);
		getContentPane().add(jLabel2);
		getContentPane().add(jButton3);
		getContentPane().add(jButton4);
		getContentPane().add(jTextField1);
		getContentPane().add(jLabel3);
		getContentPane().add(jButton5);
		getContentPane().add(jButton6);
		getContentPane().add(jButton7);
		getContentPane().add(jButton9);
		getContentPane().add(jButton8);


		jButton1.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton1ActionPerformed(e);
			}
		});
		jButton2.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton2ActionPerformed(e);
			}
		});
		jButton3.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton3ActionPerformed(e);
			}
		});
		jButton4.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton4ActionPerformed(e);
			}
		});
		jButton5.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton5ActionPerformed(e);
			}
		});
		jButton6.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton6ActionPerformed(e);
			}
		});
		jButton7.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton7ActionPerformed(e);
			}
		});
		jButton8.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton8ActionPerformed(e);
			}
		});
		jButton9.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton9ActionPerformed(e);
			}
		});
		addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent e) {
				thisWindowClosing(e);
			}
		});
// END GENERATED CODE
	}
  
  	private boolean mShown = false;
  	
	public void addNotify() 
	{
		super.addNotify();
		
		if (mShown)
			return;
			
		// resize frame to account for menubar
		JMenuBar jMenuBar = getJMenuBar();
		if (jMenuBar != null) {
			int jMenuBarHeight = jMenuBar.getPreferredSize().height;
			Dimension dimension = getSize();
			dimension.height += jMenuBarHeight;
			setSize(dimension);
		}

		mShown = true;
	}

	// Show an informational message (black, plain text)
	public void showInfo(String msg) {
		SimpleAttributeSet attrs = new SimpleAttributeSet();
		StyleConstants.setForeground(attrs, Color.black);
		showMsg(msg, attrs);
	}
  
	// Show an warning message (red, bold text)
	public void showError(String msg) {
		SimpleAttributeSet attrs = new SimpleAttributeSet();
		StyleConstants.setForeground(attrs, Color.red);
		StyleConstants.setBold(attrs, true);
		showMsg(msg, attrs);
	}
	
	// Show a text message using the specified AttributeSet
	protected void showMsg(String msg, AttributeSet attrs) {
		Document doc = jTextPane1.getDocument();
		msg += "\n";
		try {
			doc.insertString(doc.getLength(), msg, attrs);
		} catch (BadLocationException ex) {
			ex.printStackTrace();
		}
	}

	// Show an informational message (black, plain text)
	public void showInfo2(String msg) {
		SimpleAttributeSet attrs = new SimpleAttributeSet();
		StyleConstants.setForeground(attrs, Color.black);
		showMsg2(msg, attrs);
	}
  
	// Show an warning message (red, bold text)
	public void showError2(String msg) {
		SimpleAttributeSet attrs = new SimpleAttributeSet();
		StyleConstants.setForeground(attrs, Color.red);
		StyleConstants.setBold(attrs, true);
		showMsg2(msg, attrs);
	}
	
	// Show a text message using the specified AttributeSet
	protected void showMsg2(String msg, AttributeSet attrs) {
		Document doc = jTextPane2.getDocument();
		msg += "\n";
		try {
			doc.insertString(doc.getLength(), msg, attrs);
		} catch (BadLocationException ex) {
			ex.printStackTrace();
		}
	}

	// Close the window when the close box is clicked
	void thisWindowClosing(java.awt.event.WindowEvent e)
	{
		setVisible(false);
		dispose();
		System.exit(0);
	}
	
	public void jButton1ActionPerformed(java.awt.event.ActionEvent e) {
	
		FTest.comms.isStress = false;
		Boundary.doVoteTests();
	
	}
	
	public void jButton2ActionPerformed(java.awt.event.ActionEvent e) {
	
		FTest.comms.isStress = false;
		Boundary.doStampTests();
		
	}
	
	public void jButton3ActionPerformed(java.awt.event.ActionEvent e) {
	
		FTest.comms.isStress = false;
		Boundary.doMACTests();
	
	}
	
	public void jButton4ActionPerformed(java.awt.event.ActionEvent e) {
	
		/* In this method we spin off multiple Stress classes which
		 * in turn start their own TCPClient thread to send a vote packet.
		 * Using this system we can simulate many simultaneous votes.
		 */

		int clients;
		String data;
		Integer t;

		t = new Integer(jTextField1.getText());
		clients = t.intValue();
		FTest.comms.stressClients = clients;

		Stress[] stressClients = new Stress[clients];  // array to hold threads
		
		try {
		
			showInfo2("Starting stress test...");
			showInfo2("Simulating " + clients + " clients.");

			FTest.comms.isStress = true;
			FTest.comms.stressCount = 0;

			// pre-create packet to ease processing load
			FTest.comms.setType('V');
			FTest.comms.setCheck(new Date());
			data = FTest.comms.getCheck().toString() + "-TEST";
			FTest.comms.setMessage("V|" + data + "|" + AuthSys.makeDigest(data));
		
			// initialise clients
			for (int i = 0; i < clients; i++) {
				stressClients[i] = new Stress();
			}
	
			FTest.comms.stressBefore = new Date();

			// go!
			for (int i = 0; i < clients; i++) {
				stressClients[i].start();
			}

		} catch (Exception exc) {
			FTest.frame.showError("Stress Test Error: " + exc.getMessage());
		}
	
	}
	
	public void jButton5ActionPerformed(java.awt.event.ActionEvent e) {

		FTest.comms.isStress = false;
		Boundary.doERTests();
	
	}
	
	public void jButton6ActionPerformed(java.awt.event.ActionEvent e) {
	
		FTest.comms.isStress = false;
		Boundary.doAuthTests();

	}
	
	public void jButton7ActionPerformed(java.awt.event.ActionEvent e) {
	
		FTest.comms.isStress = false;
		Boundary.doERMACTests();

	}
	
	public void jButton8ActionPerformed(java.awt.event.ActionEvent e) {

		/* In this method we spin off multiple Stress classes which
		 * in turn start their own TCPClient thread to send an Auth packet.
		 * Using this system we can simulate many simultaneous auth requests.
		 */

		int clients;
		String data;
		Integer t;

		t = new Integer(jTextField1.getText());
		clients = t.intValue();
		FTest.comms.stressClients = clients;

		Stress[] stressClients = new Stress[clients];  // array to hold threads
		
		try {
		
			showInfo2("Starting stress test...");
			showInfo2("Simulating " + clients + " clients.");

			FTest.comms.isStress = true;
			FTest.comms.stressCount = 0;

			// pre-create packet to ease processing load
			FTest.comms.setType('E');
			data = "TEST-TEST-TEST";
			FTest.comms.setMessage("E|" + data + "|" + AuthSys.makeDigest(data));
		
			// initialise clients
			for (int i = 0; i < clients; i++) {
				stressClients[i] = new Stress();
			}
	
			FTest.comms.stressBefore = new Date();

			// go!
			for (int i = 0; i < clients; i++) {
				stressClients[i].start();
			}

		} catch (Exception exc) {
			FTest.frame.showError("Stress Test Error: " + exc.getMessage());
		}
		
	}
	
	
	public void jButton9ActionPerformed(java.awt.event.ActionEvent e) {
	
		FTest.comms.isStress = false;
		Boundary.doERKeyTests();

	}
	
	
	
} //eof testframe1
