/*
 * FREE 2000
 *
 * Copyright (c) Jason Kitcat, University of Warwick
 *
 * jeep@thecouch.org   http://www.thecouch.org/free/
 *
 * Knoll Cottage, Sutton Place, Nr.Abinger, Dorking, Surrey RH5 6RN United Kingdom
 *
 * Tel: 07956 886 508  Fax: 0870 052 7114
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (gpl.txt); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
 
/**
 * TCPClient Class
 * @version 0.5 11 November 2000
 * @author Jason Kitcat
 */
 
package FreeTest;

import java.io.*;
import java.net.*;

public class TCPClient implements Runnable {

	/**
	 * run() delivers a packet to the server whose DNS address is chosen
	 * 
	 */
	public void run() {
	
		String serverName;
		String packetMsg;
		int port;
		Socket freeSocket = null;
		PrintWriter out = null;
		BufferedReader in = null;
		
		/* get data */
		if (FTest.comms.getType()=='V') {
			serverName = FTest.comms.R_address;
		} else if (FTest.comms.getType()=='D') {
			serverName = FTest.comms.R_address;
		} else if (FTest.comms.getType()=='E') {
			serverName = FTest.comms.ER_address;
		} else if (FTest.comms.getType()=='K') {
			serverName = FTest.comms.ER_address;
		} else {
			FTest.frame.showInfo("Other type");
			serverName = FTest.comms.ER_address;
		}
		
		packetMsg = FTest.comms.getMessage() + "\r\n";
		port = FTest.comms.freePort;
		
		/* send packet */
		try {
			freeSocket = new Socket(serverName, port);
			out = new PrintWriter(freeSocket.getOutputStream(), true);
			in = new BufferedReader(new InputStreamReader(freeSocket.getInputStream()));
			
			out.println(packetMsg); //write packet
		} catch (UnknownHostException e) {
			FTest.frame.showError("Unknown host: " + serverName);
		} catch (IOException e) {
			FTest.frame.showError("Couldn't get I/O for the connection to: " + serverName);
		}
		
		String inputData = "NONE";
		String outputData = "NONE";
		
		/* read response */
		try {
			
			while (true) {
			
				if (in.ready()) {  // if there's data 
				
					inputData = in.readLine();
					
					if (!inputData.equals("")) { // check real data has arrived
		
						outputData = ClientProtocol.process(inputData);
						
						if ((outputData.equals("DONE"))|(outputData.equals("ERROR"))) {
						
							break;
							
						} else if (outputData.charAt(0)=='X') {
						
							out.println(outputData);
							
							break;
							
						} else {
						
							out.println(outputData);
							
						}
						
					}
					
				}
			
			}
						
			
		} catch (Exception e) {
			FTest.frame.showError("Connection Error: " + e.getMessage());
		} finally {
			//tidy up
			try {
				out.close();
				in.close();
				freeSocket.close();
			} catch (Exception e) {
				FTest.frame.showError("Error shutting connection: " + e.getMessage());
			}
			FTest.comms.setFromServer(outputData);
		}			
	
	} //EOF run
	
} //EOF TCPClient

