/*
 * FREE 2000
 *
 * Copyright (c) Jason Kitcat, University of Warwick
 *
 * jeep@thecouch.org   http://www.thecouch.org/free/
 *
 * Knoll Cottage, Sutton Place, Nr.Abinger, Dorking, Surrey RH5 6RN United Kingdom
 *
 * Tel: 07956 886 508  Fax: 0870 052 7114
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (gpl.txt); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
 
/**
 * Packet Class - customised data type
 * @version 0.3 16 February 2000
 * @author Jason Kitcat
 */
 
package FreeTest;

import java.lang.*;

public class Packet {


private char type;
private String message;
private String digest;

/* constructor */
protected Packet(String p) {

	int i=2;

	type = p.charAt(0);
	while (p.charAt(i)!='|') {
		i++;
	}
	
	// defensive code
	if (i == 2) {
		message = "";
	} else {
		message = p.substring(2,(i));
	}
	digest = p.substring(i+1);

}

/* returns a printable value of Packet */
public String toString() {

	String out;
	
	out = type + "|" + message + "|" + digest;
	
	return out;
	
}

/* return data portion of Packet */
protected String getMessage() {

	return message;
	
}

/* return message digest of Packet */
protected String getDigest() {

	return digest;
	
}

/* return type of Packet */
protected char getType() {

	return type;
	
}

} //EOF Packet