/*
 * FREE 2000
 *
 * Copyright (c) Jason Kitcat, University of Warwick
 *
 * jeep@thecouch.org   http://www.thecouch.org/free/
 *
 * Knoll Cottage, Sutton Place, Nr.Abinger, Dorking, Surrey RH5 6RN United Kingdom
 *
 * Tel: 07956 886 508  Fax: 0870 052 7114
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (gpl.txt); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

/**
 * FTest Class
 * @version 0.2 11 November 2000
 * @author Jason Kitcat
 */

package FreeTest;

import java.net.*;
import java.io.*;
import javax.swing.*;
import java.awt.*;

public class FTest 
{

	protected static TestFrame1 frame;
	protected static Comms comms;
	
	protected FTest() 
	{
		try {
			// For native Look and Feel, uncomment the following code.
			/*
			try {
				UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
			} 
			catch (Exception e) { 
			}
			*/
			frame = new TestFrame1();
			
			comms = new Comms();
			Boundary.setData();

			showSplash(4000);
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}

	// Main entry point
	static protected void main(String[] args) 
	{
		new FTest();
	}

	/**
	 * A simple little method, adatped from O'Reilly's 'Java Swing', to
	 * show a title screen in the centre of the screen for a certain time.
	 *
	 * @param duration  The time to show the screen for
	 */
	protected static void showSplash(int duration) {
		JWindow splash = new JWindow();
		JPanel content = (JPanel)splash.getContentPane();
		
		//set the window's bounads, centering the window
		int width = 400;
		int height = 200;
		Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
		int x = (screen.width-width)/2;
		int y = (screen.height-height)/2;
		splash.setBounds(x,y,width,height);
		
		//build the splash screen
		JLabel label = new JLabel(new ImageIcon("splash.gif"));
		content.add(label, BorderLayout.CENTER);
		
		splash.setVisible(true);
		
		//Wait a while
		try {
			Thread.sleep(duration);
		
			//then load next window
			frame.initComponents();
			splash.setVisible(false);
			frame.setVisible(true);
			frame.showInfo("Welcome to the FREE Test Suite 0.4");
		 } catch (Exception e) {}
		
	} //EOF showSplash
	
} //EOF Class
