/*
 * FREE 2000
 *
 * Copyright (c) Jason Kitcat, University of Warwick
 *
 * jeep@thecouch.org   http://www.thecouch.org/free/
 *
 * Knoll Cottage, Sutton Place, Nr.Abinger, Dorking, Surrey RH5 6RN United Kingdom
 *
 * Tel: 07956 886 508  Fax: 0870 052 7114
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (gpl.txt); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package FreeInstall;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

 /**
  * A screen to let users easily set the FREE code variables.
  *
  * @version 0.1 17 April 2000
  * @author Jason Kitcat
  */
public class InstallFrame extends JFrame 
{

	javax.swing.JLabel jLabel1 = new javax.swing.JLabel();
	javax.swing.JLabel jLabel2 = new javax.swing.JLabel();
	javax.swing.JLabel jLabel3 = new javax.swing.JLabel();
	javax.swing.JLabel jLabel4 = new javax.swing.JLabel();
	javax.swing.JLabel jLabel6 = new javax.swing.JLabel();
	javax.swing.JTextField jTextField1 = new javax.swing.JTextField();
	javax.swing.JTextField jTextField2 = new javax.swing.JTextField();
	javax.swing.JTextField jTextField3 = new javax.swing.JTextField();
	javax.swing.JTextField jTextField4 = new javax.swing.JTextField();
	javax.swing.JButton jButton1 = new javax.swing.JButton();
	javax.swing.JLabel jLabel5 = new javax.swing.JLabel();

	protected InstallFrame() {
	
		jLabel4.setText("Please fill out fields for setup:");
		jLabel4.setVisible(true);
		jLabel4.setPreferredSize(new java.awt.Dimension(260, 20));
		jLabel4.setMinimumSize(new java.awt.Dimension(260, 20));
		jLabel4.setAlignmentX(LEFT_ALIGNMENT);
		
		JPanel jPanel1 = new JPanel();
		jPanel1.setLayout(new BoxLayout(jPanel1, BoxLayout.Y_AXIS));
		jPanel1.add(jLabel4);
		jPanel1.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));

		jLabel1.setText("Regional Server name:");
		jLabel1.setVisible(true);
		jLabel1.setPreferredSize(new java.awt.Dimension(80, 20));
		jLabel1.setMinimumSize(new java.awt.Dimension(80, 20));
		jLabel1.setAlignmentX(LEFT_ALIGNMENT);

		jTextField1.setVisible(true);
		jTextField1.setPreferredSize(new java.awt.Dimension(200, 20));
		jTextField1.setMinimumSize(new java.awt.Dimension(200, 20));
		
		jLabel2.setText("Electoral Roll Server name:");
		jLabel2.setVisible(true);
		jLabel2.setPreferredSize(new java.awt.Dimension(80, 20));
		jLabel2.setMinimumSize(new java.awt.Dimension(80, 20));
		jLabel2.setAlignmentX(LEFT_ALIGNMENT);

		jTextField2.setVisible(true);
		jTextField2.setPreferredSize(new java.awt.Dimension(200, 20));
		jTextField2.setPreferredSize(new java.awt.Dimension(200, 20));

		jLabel3.setText("Totaller Server name:");
		jLabel3.setVisible(true);
		jLabel3.setPreferredSize(new java.awt.Dimension(80, 20));
		jLabel3.setMinimumSize(new java.awt.Dimension(80, 20));
		jLabel3.setAlignmentX(LEFT_ALIGNMENT);

		jTextField3.setVisible(true);
		jTextField3.setPreferredSize(new java.awt.Dimension(200, 20));
		jTextField3.setMinimumSize(new java.awt.Dimension(200, 20));

		jLabel6.setText("FREE port number (>1024):");
		jLabel6.setVisible(true);
		jLabel6.setPreferredSize(new java.awt.Dimension(80, 20));
		jLabel6.setMinimumSize(new java.awt.Dimension(80, 20));
		jLabel6.setAlignmentX(LEFT_ALIGNMENT);

		jTextField4.setVisible(true);
		jTextField4.setPreferredSize(new java.awt.Dimension(200, 20));
		jTextField4.setMinimumSize(new java.awt.Dimension(200, 20));

		JPanel jPanel2 = new JPanel();
		jPanel2.setLayout(new BoxLayout(jPanel2, BoxLayout.Y_AXIS));
		jPanel2.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
		jPanel2.add(jLabel1);
		jPanel2.add(Box.createRigidArea(new java.awt.Dimension(0,5)));
		jPanel2.add(jTextField1);
		jPanel2.add(Box.createVerticalGlue());
		jPanel2.add(jLabel2);
		jPanel2.add(Box.createRigidArea(new java.awt.Dimension(0,5)));
		jPanel2.add(jTextField2);
		jPanel2.add(Box.createVerticalGlue());
		jPanel2.add(jLabel3);
		jPanel2.add(Box.createRigidArea(new java.awt.Dimension(0,5)));
		jPanel2.add(jTextField3);
		jPanel2.add(Box.createVerticalGlue());
		jPanel2.add(jLabel6);
		jPanel2.add(Box.createRigidArea(new java.awt.Dimension(0,5)));
		jPanel2.add(jTextField4);

		jLabel5.setText("Please fill out ALL the fields!");
		jLabel5.setVisible(false);
		jLabel5.setPreferredSize(new java.awt.Dimension(210, 20));
		jLabel5.setMinimumSize(new java.awt.Dimension(210, 20));

		jButton1.setText("OK");
		jButton1.setVisible(true);
		jButton1.setPreferredSize(new java.awt.Dimension(70, 20));
		jButton1.setMinimumSize(new java.awt.Dimension(70, 20));

		JPanel jPanel3 = new JPanel();
		jPanel3.setLayout(new BoxLayout(jPanel3, BoxLayout.X_AXIS));
		jPanel3.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
		jPanel3.add(Box.createHorizontalGlue());
		jPanel3.add(jLabel5);
		jPanel3.add(Box.createRigidArea(new java.awt.Dimension(0,5)));
		jPanel3.add(jButton1);

		setLocation(new java.awt.Point(40, 40));
		setTitle("FREE: Setup (1)");
		setResizable(true);
		setSize(new java.awt.Dimension(350, 350));
		Container contentPane = getContentPane();
		contentPane.add(jPanel1, BorderLayout.NORTH);
		contentPane.add(jPanel2, BorderLayout.CENTER);
		contentPane.add(jPanel3, BorderLayout.SOUTH);
	
	}

	protected void initComponents() throws Exception
	{

		jButton1.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton1ActionPerformed(e);
			}
		});
		addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent e) {
				thisWindowClosing(e);
			}
		});
	}
  
  	private boolean mShown = false;
  	
	public void addNotify() 
	{
		super.addNotify();
		
		if (mShown)
			return;
			
		// resize frame to account for menubar
		JMenuBar jMenuBar = getJMenuBar();
		if (jMenuBar != null) {
			int jMenuBarHeight = jMenuBar.getPreferredSize().height;
			Dimension dimension = getSize();
			dimension.height += jMenuBarHeight;
			setSize(dimension);
		}

		mShown = true;
	}

	// Close the window when the close box is clicked
	void thisWindowClosing(java.awt.event.WindowEvent e)
	{
	}
	
	protected void jButton1ActionPerformed(java.awt.event.ActionEvent e) {

		if (jTextField1.getText().equals("")|jTextField2.getText().equals("")|jTextField3.getText().equals("")|jTextField4.getText().equals("")) {
			jLabel5.setVisible(true);
		} else {
			if (Install.isSafe(jTextField1.getText())|Install.isSafe(jTextField2.getText())|Install.isSafe(jTextField3.getText())|Install.isSafe(jTextField4.getText())) {
				setVisible(false);
				jLabel5.setVisible(false);
			
				Install.regional_name = jTextField1.getText();
				Install.er_name = jTextField2.getText();
				Install.totaller_name = jTextField3.getText();
				Install.freePort = jTextField4.getText();

				setVisible(false);			
				Install.frame3.setVisible(true);
				dispose();
			} else {
				jLabel5.setVisible(true);
			}

		}
					
	}
		
} //EOF class
