/*
 * FREE 2000
 *
 * Copyright (c) Jason Kitcat, University of Warwick
 *
 * jeep@thecouch.org   http://www.thecouch.org/free/
 *
 * Knoll Cottage, Sutton Place, Nr.Abinger, Dorking, Surrey RH5 6RN United Kingdom
 *
 * Tel: 07956 886 508  Fax: 0870 052 7114
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (gpl.txt); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package FreeClient;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.text.*;

/**
 * The main voting screen where voters pick their choice and it is sent to a server.
 *
 * @version 0.5 15 March 2000
 * @author Jason Kitcat
 */
public class VoteFrame extends JFrame 
{

	private String choice;
	private final ButtonGroup group = new ButtonGroup();

	javax.swing.JScrollPane jScrollPane1 = new javax.swing.JScrollPane();
	javax.swing.JTextPane jTextPane1 = new javax.swing.JTextPane();
	javax.swing.JLabel jLabel1 = new javax.swing.JLabel();
	javax.swing.JToggleButton jToggleButton1 = new javax.swing.JToggleButton();
	javax.swing.JToggleButton jToggleButton2 = new javax.swing.JToggleButton();
	javax.swing.JToggleButton jToggleButton3 = new javax.swing.JToggleButton();
	javax.swing.JToggleButton jToggleButton4 = new javax.swing.JToggleButton();
	javax.swing.JButton jButton1 = new javax.swing.JButton();
	javax.swing.JButton jButton2 = new javax.swing.JButton();
	javax.swing.JLabel jLabel2 = new javax.swing.JLabel();
	javax.swing.JButton jButton3 = new javax.swing.JButton();
	javax.swing.JButton jButton4 = new javax.swing.JButton();

	protected VoteFrame()
	{
		choice = "";
		group.add(jToggleButton1);
		group.add(jToggleButton2);
		group.add(jToggleButton3);
		group.add(jToggleButton4);

		//jLabel1.setText("Please make your choice:");
		//jLabel1.setVisible(true);
		//jLabel1.setPreferredSize(new java.awt.Dimension(290, 20));
		//jLabel1.setMinimumSize(new java.awt.Dimension(290, 20));

//#ifdef INSTALL
		jToggleButton1.setText("GREEN");
		jToggleButton1.setVisible(true);
		jToggleButton1.setPreferredSize(new java.awt.Dimension(100, 30));
		jToggleButton1.setMinimumSize(new java.awt.Dimension(100, 30));

//#ifdef INSTALL
		jToggleButton2.setText("LABOUR");
		jToggleButton2.setVisible(true);
		jToggleButton2.setPreferredSize(new java.awt.Dimension(100, 30));
		jToggleButton2.setMinimumSize(new java.awt.Dimension(100, 30));

//#ifdef INSTALL
		jToggleButton3.setText("LIB DEM");
		jToggleButton3.setVisible(true);
		jToggleButton3.setPreferredSize(new java.awt.Dimension(100, 30));
		jToggleButton3.setMinimumSize(new java.awt.Dimension(100, 30));

//#ifdef INSTALL
		jToggleButton4.setText("TORY");
		jToggleButton4.setVisible(true);
		jToggleButton4.setPreferredSize(new java.awt.Dimension(100, 30));
		jToggleButton4.setMinimumSize(new java.awt.Dimension(100, 30));

		JPanel buttonPane = new JPanel();
		buttonPane.setLayout(new BoxLayout(buttonPane, BoxLayout.X_AXIS));
		buttonPane.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
		buttonPane.add(jToggleButton1);
		buttonPane.add(Box.createHorizontalGlue());
		buttonPane.add(jToggleButton2);
		buttonPane.add(Box.createHorizontalGlue());
		buttonPane.add(jToggleButton3);
		buttonPane.add(Box.createHorizontalGlue());
		buttonPane.add(jToggleButton4);

		jScrollPane1.setVisible(true);
		jScrollPane1.setPreferredSize(new java.awt.Dimension(430, 110));
		jScrollPane1.setMinimumSize(new java.awt.Dimension(430, 110));
		jScrollPane1.getViewport().add(jTextPane1);

		jTextPane1.setVisible(true);
		
		JPanel jPanel1 = new JPanel();
		jPanel1.setLayout(new BoxLayout(jPanel1, BoxLayout.Y_AXIS));
		jPanel1.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
		jPanel1.add(jScrollPane1);
		
		jLabel2.setText("Are you sure?");
		jLabel2.setVisible(false);
		jLabel2.setPreferredSize(new java.awt.Dimension(90, 20));
		jLabel2.setMinimumSize(new java.awt.Dimension(90, 20));

		jButton1.setText("Yes");
		jButton1.setVisible(false);
		jButton1.setPreferredSize(new java.awt.Dimension(80, 20));
		jButton1.setMinimumSize(new java.awt.Dimension(80, 20));

		jButton2.setText("No");
		jButton2.setVisible(false);
		jButton2.setPreferredSize(new java.awt.Dimension(80, 20));
		jButton2.setMinimumSize(new java.awt.Dimension(80, 20));

		jButton3.setText("Retry");
		jButton3.setVisible(false);
		jButton3.setPreferredSize(new java.awt.Dimension(80, 20));
		jButton3.setMinimumSize(new java.awt.Dimension(80, 20));

		jButton4.setText("Quit");
		jButton4.setVisible(false);
		jButton4.setPreferredSize(new java.awt.Dimension(70, 20));
		jButton4.setMinimumSize(new java.awt.Dimension(70, 20));

		JPanel buttonPane2 = new JPanel();
		buttonPane2.setLayout(new BoxLayout(buttonPane2, BoxLayout.X_AXIS));
		buttonPane2.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
		buttonPane2.add(jLabel2);
		buttonPane.add(Box.createRigidArea(new Dimension(10,0)));
		buttonPane2.add(jButton1);
		buttonPane.add(Box.createRigidArea(new Dimension(10,0)));
		buttonPane2.add(jButton2);
		buttonPane2.add(Box.createHorizontalGlue());
		buttonPane2.add(jButton3);
		buttonPane.add(Box.createRigidArea(new Dimension(10,0)));
		buttonPane2.add(jButton4);

		setLocation(new java.awt.Point(40, 40));
		setTitle("FREE: Voting Screen");
		setResizable(true);
		setSize(new java.awt.Dimension(460, 300));
		Container contentPane = getContentPane();
		contentPane.add(buttonPane, BorderLayout.NORTH);
		contentPane.add(jPanel1, BorderLayout.CENTER);
		contentPane.add(buttonPane2, BorderLayout.SOUTH);
	}

	protected void initComponents() throws Exception
	{

		jToggleButton1.addChangeListener(new javax.swing.event.ChangeListener() {
			public void stateChanged(javax.swing.event.ChangeEvent e) {
				jToggleButton1StateChanged(e);
			}
		});
		jToggleButton2.addChangeListener(new javax.swing.event.ChangeListener() {
			public void stateChanged(javax.swing.event.ChangeEvent e) {
				jToggleButton2StateChanged(e);
			}
		});
		jToggleButton3.addChangeListener(new javax.swing.event.ChangeListener() {
			public void stateChanged(javax.swing.event.ChangeEvent e) {
				jToggleButton3StateChanged(e);
			}
		});
		jToggleButton4.addChangeListener(new javax.swing.event.ChangeListener() {
			public void stateChanged(javax.swing.event.ChangeEvent e) {
				jToggleButton4StateChanged(e);
			}
		});
		jButton1.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton1ActionPerformed(e);
			}
		});
		jButton2.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton2ActionPerformed(e);
			}
		});
		jButton3.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton3ActionPerformed(e);
			}
		});
		jButton4.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton4ActionPerformed(e);
			}
		});
		addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent e) {
				thisWindowClosing(e);
			}
		});
// END GENERATED CODE
	}

	// Show an informational message (black, plain text)
	protected void showInfo(String msg) {
		SimpleAttributeSet attrs = new SimpleAttributeSet();
		StyleConstants.setForeground(attrs, Color.black);
		showMsg(msg, attrs);
	}
  
	// Show an warning message (red, bold text)
	protected void showError(String msg) {
		SimpleAttributeSet attrs = new SimpleAttributeSet();
		StyleConstants.setForeground(attrs, Color.red);
		StyleConstants.setBold(attrs, true);
		showMsg(msg, attrs);
	}
	
	// Show a text message using the specified AttributeSet
	protected void showMsg(String msg, AttributeSet attrs) {
		Document doc = jTextPane1.getDocument();
		msg += "\n";
		try {
			doc.insertString(doc.getLength(), msg, attrs);
		} catch (BadLocationException ex) {
			ex.printStackTrace();
		}
	}
  
  	private boolean mShown = false;
  	
	public void addNotify() 
	{
		super.addNotify();
		
		if (mShown)
			return;
			
		// resize frame to account for menubar
		JMenuBar jMenuBar = getJMenuBar();
		if (jMenuBar != null) {
			int jMenuBarHeight = jMenuBar.getPreferredSize().height;
			Dimension dimension = getSize();
			dimension.height += jMenuBarHeight;
			setSize(dimension);
		}

		mShown = true;
	}

	// Close the window when the close box is clicked
	void thisWindowClosing(java.awt.event.WindowEvent e)
	{
	}
	
	protected void jToggleButton1StateChanged(javax.swing.event.ChangeEvent e) {
//#ifdef INSTALL
		choice = "GREEN";
		jLabel2.setVisible(true);
		jButton1.setVisible(true);
		jButton2.setVisible(true);
	}
	
	protected void jToggleButton2StateChanged(javax.swing.event.ChangeEvent e) {
//#ifdef INSTALL
		choice = "LABOUR";
		jLabel2.setVisible(true);
		jButton1.setVisible(true);
		jButton2.setVisible(true);
	}
	
	protected void jToggleButton3StateChanged(javax.swing.event.ChangeEvent e) {
//#ifdef INSTALL
		choice = "LIBDEM";
		jLabel2.setVisible(true);
		jButton1.setVisible(true);
		jButton2.setVisible(true);
	}
	
	protected void jToggleButton4StateChanged(javax.swing.event.ChangeEvent e) {
//#ifdef INSTALL
		choice = "TORY";
		jLabel2.setVisible(true);
		jButton1.setVisible(true);
		jButton2.setVisible(true);
	}
	
	protected void jButton1ActionPerformed(java.awt.event.ActionEvent e) {
		jLabel2.setVisible(false);
		jButton1.setVisible(false);
		jButton2.setVisible(false);
		showInfo("Sending your vote...");
		FClient.comms.sendVote(choice);
		jToggleButton1.setEnabled(false);
		jToggleButton2.setEnabled(false);
		jToggleButton3.setEnabled(false);
		jToggleButton4.setEnabled(false);
		jButton1.setEnabled(false);
		jButton2.setEnabled(false);
	}
	
	protected void jButton2ActionPerformed(java.awt.event.ActionEvent e) {
		jLabel2.setVisible(false);
		jButton1.setVisible(false);
		jButton2.setVisible(false);
		choice = "";		
	}
	
	protected void jButton3ActionPerformed(java.awt.event.ActionEvent e) {
		jButton3.setEnabled(false);
		jButton4.setEnabled(false);
		jButton1.setEnabled(false);
		jButton2.setEnabled(false);
		FClient.comms.sendVote(choice);
		showInfo("Sending your vote again...");
	}
	
	protected void jButton4ActionPerformed(java.awt.event.ActionEvent e) {
		jButton1.setEnabled(false);
		jButton2.setEnabled(false);
		setVisible(false);
		dispose();
		System.exit(0);
	}
	
	protected void voteOK() {	
		jButton1.setEnabled(false);
		jButton2.setEnabled(false);
		jButton4.setEnabled(true);
		jButton4.setVisible(true);
		showInfo("Your vote has been registered. Thank You.\r\nClick Quit to finish.\r\n");
	}
	
	protected void voteErr() {
		jButton1.setEnabled(false);
		jButton2.setEnabled(false);
		jButton3.setVisible(true);
		jButton4.setVisible(true);
		showError("Sorry, it's our fault,\r\nbut there was a problem sending your vote.\r\nEither Retry or Quit.\r\nIf you do Quit you cannot try again.\r\n");
	}
	
}
