/*
 * FREE 2000
 *
 * Copyright (c) Jason Kitcat, University of Warwick
 *
 * jeep@thecouch.org   http://www.thecouch.org/free/
 *
 * Knoll Cottage, Sutton Place, Nr.Abinger, Dorking, Surrey RH5 6RN United Kingdom
 *
 * Tel: 07956 886 508  Fax: 0870 052 7114
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (gpl.txt); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package FreeClient;

import java.net.*;
import java.io.*;
import javax.swing.*;
import java.awt.*;

/**
 * FClient Class initialises and starts the FreeClient software.
 *
 * @version 0.4 31 March 2000
 * @author Jason Kitcat
 */
public class FClient {

	/* Time, in milliseconds, before a connection times out */
	protected static final long timeOutTime = 240000;

	/* true when we are talking to the ERServer */
	protected static boolean ercheck;

	/* variable for stopping comms after time out */
	protected static boolean carryOn = true;
	
	protected static VoteFrame frame;
	protected static FCFrame2 frame2;
	protected static FCFrame3 frame3;
	protected static FCFrame4 frame4;
	protected static Comms comms;

	/**
	 * FClient() is the constructor which creates all the Swing frames and
	 * launches the splash screen.
	 *
	 */
	protected FClient()
	{
		try {
			// For native Look and Feel, uncomment the following code.
			/*
			try {
				UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
			} 
			catch (Exception e) { 
			}
			*/
			
			frame2 = new FCFrame2();

			showSplash(4000);
						
			frame = new VoteFrame();
			frame.initComponents();
			frame3 = new FCFrame3();
			frame3.initComponents();
			frame4 = new FCFrame4();
			frame4.initComponents();
			
			comms = new Comms();

		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}

	// Main entry point
	static public void main(String[] args) 
	{
		new FClient();
	}
	
	/**
	 * A simple little method, adatped from O'Reilly's 'Java Swing', to
	 * show a title screen in the centre of the screen for a certain time.
	 *
	 * @param duration  The time to show the screen for
	 */
	protected static void showSplash(int duration) {
		JWindow splash = new JWindow();
		JPanel content = (JPanel)splash.getContentPane();
		
		//set the window's bounds, centering the window
		int width = 400;
		int height = 200;
		Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
		int x = (screen.width-width)/2;
		int y = (screen.height-height)/2;
		splash.setBounds(x,y,width,height);
		
		//build the splash screen
		JLabel label = new JLabel(new ImageIcon("splash.gif"));
		content.add(label, BorderLayout.CENTER);
		
		splash.setVisible(true);
		
		//Wait a while
		try {
			Thread.sleep(duration);
		
			//then load next window
			frame2.initComponents();
			splash.setVisible(false);
			frame2.setVisible(true);
		 } catch (Exception e) {}
		
	} //EOF showSplash
	
} //EOF Class
