/*
 * FREE 2000
 *
 * Copyright (c) Jason Kitcat, University of Warwick
 *
 * jeep@thecouch.org   http://www.thecouch.org/free/
 *
 * Knoll Cottage, Sutton Place, Nr.Abinger, Dorking, Surrey RH5 6RN United Kingdom
 *
 * Tel: 07956 886 508  Fax: 0870 052 7114
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (gpl.txt); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
 
package FreeClient;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.text.*;

/**
 * Intro screen to explain to users what FREE does.
 *
 * @version 0.2 15 March 2000
 * @author Jason Kitcat
 */
public class FCFrame2 extends JFrame 
{

	javax.swing.JLabel jLabel1 = new javax.swing.JLabel();
	javax.swing.JScrollPane jScrollPane1 = new javax.swing.JScrollPane();
	javax.swing.JTextPane jTextPane1 = new javax.swing.JTextPane();
	javax.swing.JButton jButton1 = new javax.swing.JButton();

	protected FCFrame2() {

		jLabel1.setText("Introduction:");
		jLabel1.setVisible(true);
		jLabel1.setPreferredSize(new java.awt.Dimension(210, 20));
		jLabel1.setMinimumSize(new java.awt.Dimension(210, 20));
		jLabel1.setAlignmentX(LEFT_ALIGNMENT);

		jScrollPane1.setVisible(true);
		jScrollPane1.setPreferredSize(new java.awt.Dimension(330, 210));
		jScrollPane1.setMinimumSize(new java.awt.Dimension(330, 210));
		jScrollPane1.setAlignmentX(LEFT_ALIGNMENT);
		jScrollPane1.getViewport().add(jTextPane1);

		jTextPane1.setVisible(true);
		
		JPanel scrollPanel = new JPanel();
		scrollPanel.setLayout(new BoxLayout(scrollPanel, BoxLayout.Y_AXIS));
		scrollPanel.add(jLabel1);
		scrollPanel.add(Box.createRigidArea(new java.awt.Dimension(0,5)));
		scrollPanel.add(jScrollPane1);
		scrollPanel.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));

		jButton1.setText("OK");
		jButton1.setVisible(true);
		jButton1.setToolTipText("Click to go to user authentication");
		jButton1.setPreferredSize(new java.awt.Dimension(70, 20));
		jButton1.setMinimumSize(new java.awt.Dimension(70, 20));

		JPanel buttonPane = new JPanel();
		buttonPane.setLayout(new BoxLayout(buttonPane, BoxLayout.X_AXIS));
		buttonPane.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
		buttonPane.add(Box.createHorizontalGlue());
		buttonPane.add(jButton1);

		setLocation(new java.awt.Point(40, 40));
		setTitle("FREE: Introduction");
		setResizable(true);
		setSize(new java.awt.Dimension(350, 260));
		Container contentPane = getContentPane();
		contentPane.add(scrollPanel, BorderLayout.CENTER);
		contentPane.add(buttonPane, BorderLayout.SOUTH);
	
	}

	protected void initComponents() throws Exception
	{
		jButton1.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton1ActionPerformed(e);
			}
		});
		addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowOpened(java.awt.event.WindowEvent e) {
				thisWindowOpened(e);
			}
			public void windowClosing(java.awt.event.WindowEvent e) {
				thisWindowClosing(e);
			}
		});
	}
  
  	private boolean mShown = false;
  	
	public void addNotify() 
	{
		super.addNotify();
		
		if (mShown)
			return;
			
		// resize frame to account for menubar
		JMenuBar jMenuBar = getJMenuBar();
		if (jMenuBar != null) {
			int jMenuBarHeight = jMenuBar.getPreferredSize().height;
			Dimension dimension = getSize();
			dimension.height += jMenuBarHeight;
			setSize(dimension);
		}

		mShown = true;
	}


	// Show an informational message (black, plain text)
	protected void showInfo(String msg) {
		SimpleAttributeSet attrs = new SimpleAttributeSet();
		StyleConstants.setForeground(attrs, Color.black);
		showMsg(msg, attrs);
	}
  
	// Show a text message using the specified AttributeSet
	protected void showMsg(String msg, AttributeSet attrs) {
		Document doc = jTextPane1.getDocument();
		msg += "\n";
		try {
			doc.insertString(doc.getLength(), msg, attrs);
		} catch (BadLocationException ex) {
			ex.printStackTrace();
		}
	}


	// Close the window when the close box is clicked
	void thisWindowClosing(java.awt.event.WindowEvent e)
	{
		setVisible(false);
		dispose();
		
		FClient.frame3.setVisible(true);
		
	}
	
	protected void thisWindowOpened(java.awt.event.WindowEvent e) {
	
		showInfo("Welcome to the FREE Voting System.\n\r\n\rThis system is specially designed to allow you to vote in full confidence. You can feel assured because FREE is designed for:\n\r\n\r- PRIVACY\n\rAt no time is a link ever made between who you are and what you have voted. Your choice is 100% private.\n\r\n\r- SECURITY\n\rFREE uses special security systems designed to prevent anybody voting multiple times or any third party from throwing the outcome of a vote.\n\r\n\r- RELIABILITY\n\rMany different computers are used by FREE, so that if one fails the whole vote won't be affected. FREE allows votes to be cheaper, faster and more accurate.\n\r\n\rThank you for voting - democracy needs you.\n\r\n\r");
					
	}
	
	protected void jButton1ActionPerformed(java.awt.event.ActionEvent e) {
	
		setVisible(false);
			
		FClient.ercheck = true;
		FClient.frame3.setVisible(true);
				
		dispose();
	}
	
	
	
}
