/*
 * FREE 2000
 *
 * Copyright (c) Jason Kitcat, University of Warwick
 *
 * jeep@thecouch.org   http://www.thecouch.org/free/
 *
 * Knoll Cottage, Sutton Place, Nr.Abinger, Dorking, Surrey RH5 6RN United Kingdom
 *
 * Tel: 07956 886 508  Fax: 0870 052 7114
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (gpl.txt); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
  
package FreeClient;
 
import java.util.*;
import Free.util.*;

/**
 * ClientProtocol receives Strings of data from <code>TCPClient</code> and 
 * implements the logic to process these strings and formulate the appropriate
 * replies.
 *
 * The source code is extremely readable and best explains the full functionality.
 *
 * @version 0.5  2 November 2000
 * @author Jason Kitcat
 */
public class ClientProtocol {

	/**
	 * process analyses packets and responds appropriately.
	 *
	 * @param inputData   Contains the contents of a received packet
	 * @returns		String with a packet to return to client
	 * @throws		<code>Exception</code>, all errors are handled by <code>TCPClient</code>
	 *				which has the ability to gracefully close the connection.  
	 */
	protected static String process(String inputData) throws Exception {

		String outputData="";
		
		if (inputData.charAt(0) == 'A') {
			/* auth request */
			Packet p = new Packet(inputData);

			if (AuthSys.checkDigest(p)) {  // tamper check
			
				// split message
				String data, authFlag, authKey;
				int i=0;
					
				data = p.getMessage();
					
				// parse to get seperate data fields
				while (data.charAt(i)!='-') {
					i++;
				}
				authFlag = data.substring(0,i);
				authKey = data.substring(i+1);									
			
				if (authFlag.equals("TRUE")) {
					FClient.comms.setERAuthKey(authKey);
					FClient.frame4.showInfo("User authorised to vote!");
					FClient.frame4.status=true;
					FClient.frame4.jButton1.setVisible(true);
					FClient.frame4.showInfo("Click OK to continue.");
				} else {
					FClient.frame4.showError("Voter authorisation failed.");
					FClient.frame4.status=false;
					FClient.frame4.jButton1.setVisible(true);
					FClient.frame4.jButton2.setVisible(true);
					FClient.frame4.showInfo("Click OK to try again.");
				}
				
				outputData = "X|OK|" + AuthSys.makeDigest("OK") + "\r\n";			

			} else {
				outputData = "ERROR";
				FClient.frame4.showError("Packet corrupted or altered!");
				FClient.frame4.status=false;
				FClient.frame4.jButton1.setVisible(true);
				FClient.frame4.jButton2.setVisible(true);
				FClient.frame4.showInfo("Click OK to try again.");
			}
			

		} else if (inputData.charAt(0) == 'C') {
			/* confirm */
			Packet p = new Packet(inputData);

			if (AuthSys.checkDigest(p)) {  // tamper check
			
				if (p.getMessage().equals("STAMP")) {
					if (FClient.comms.getCheck() != null) {
						String data = FClient.comms.getCheck().toString();
						outputData = "C|" + data + "|" + AuthSys.makeDigest(data) + "\r\n"; //reply with time stamp
						FClient.frame.showInfo("Time Stamp check sent.");		
					} else {
						FClient.frame.showError("Vote security error.");
						outputData = "ERROR";
					}
				} else if (p.getMessage().equals("OK")) {  //everything went fine
					FClient.frame.showInfo("Vote confirmed.");
					outputData = "X|OK|" + AuthSys.makeDigest("OK") + "\r\n";
					FClient.comms.noCheck();  // just in case, we clear the check date
					FClient.frame.voteOK();
				} else {
					FClient.frame.showError("Unrecognized confirm packet received.");
					outputData = "ERROR";
					FClient.frame.voteErr();
				}
			} else {
				FClient.frame.showError("Packet corrupted or altered!");
				outputData = "ERROR";
				FClient.frame.voteErr();
			}			
							
		} else if (inputData.charAt(0) == 'D') {
			/* diagnostic */
			Packet p = new Packet(inputData);

			if (AuthSys.checkDigest(p)) {  // tamper check

				FClient.frame.showInfo("Diagnostic packet received.");
				outputData = "X|OK|" + AuthSys.makeDigest("OK") + "\r\n";
			
			} else {
				outputData = "ERROR";
				throw new Exception("Packet corrupted or altered!");
			}

		} else {
			outputData = "ERROR";
			if (FClient.ercheck) {  // make sure we're sending errors to the right screen
				FClient.frame4.showError("Unrecognized packet received.");
			} else {
				FClient.frame.showError("Unrecognized packet received.");
			}
		}
		
		return outputData;

	} //EOF process()

} //EOF Class