/*
 * FREE 2000
 *
 * Copyright (c) Jason Kitcat, University of Warwick
 *
 * jeep@thecouch.org   http://www.thecouch.org/free/
 *
 * Knoll Cottage, Sutton Place, Nr.Abinger, Dorking, Surrey RH5 6RN United Kingdom
 *
 * Tel: 07956 886 508  Fax: 0870 052 7114
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (gpl.txt); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
  
package Free;

import java.net.*;
import java.io.*;
import java.util.*;

/**
 * The TCPServer Class opens a socket to listen for client connections
 * which, when received, are spun out into new threads to keep the listening
 * socket free to accept new clients.
 *
 * The class is based on original code from "Java Threads" from O'Reilly.
 *
 * @version 0.7  31 March 2000
 * @author Jason Kitcat
 */
public class TCPServer implements Cloneable, Runnable {

	Thread runner = null;
	ServerSocket server = null;
	Socket data = null;
	boolean shouldStop = false;
	
	/**
	 * startServer creates and runs a new thread for a session
	 *
	 * @param port	A number indicating the port being used for the session
	 */
	protected synchronized void startServer(int port) throws IOException {
	
		if (runner == null) {
			server = new ServerSocket(port);
			runner = new Thread(this);
			runner.start();
		}
	}
	
	
	/**
	 * stopServer does just that!
	 */
	protected synchronized void stopServer() {
	
		if (server != null) {
			shouldStop = true;
			runner.interrupt();
			runner = null;
			try {
				server.close();
			} catch (IOException ioe) {
				RTServer.NORM.warn("IO Error closing server connection");
			}
			server = null;
		}
	}
	
	/**
	 * run listens and accepts new connections, spinning them off into new threads
	 *
	 * if we're already listening to a data socket, process the data with overloaded run
	 */
	public void run() {

		if (server != null) {
			while (!shouldStop) {
				try {
					Socket datasocket = server.accept();
					TCPServer newSocket = (TCPServer) clone();
					
					newSocket.server = null;
					newSocket.data = datasocket;
					newSocket.runner = new Thread(newSocket);
					newSocket.runner.start();
				} catch (InterruptedIOException e) {
					// do nothing it's ok
				} catch (IOException e) {
					RTServer.NORM.error("Error in TCPServer: " + e.getMessage());
				} catch (CloneNotSupportedException e) {
					RTServer.NORM.error("Error in TCPServer: " + e.getMessage());
				}
			}
		} else {
			run(data);
		}
	}
	
	/**
	 * run this time the overloaded one deals with the data as we're on a data socket
	 *
	 * @param data	Data being sent by the client
	 */
	public void run(Socket data) {
	
		String inputData, outputData;
			
		outputData = "";
		inputData = "";
		
		try {
			BufferedReader in = new BufferedReader(new InputStreamReader(data.getInputStream()));
			PrintWriter out = new PrintWriter(data.getOutputStream(), true);
						
			while (true) {
			
				if (in.ready()) {  // if there's data 
				
					inputData = in.readLine();
					
					if (!inputData.equals("")) { // check real data has arrived

						RTServer.DEV.debug("Received: " + inputData);
						outputData = ServerProtocol.process(inputData);
						
						if ((outputData.equals("DONE"))|(outputData.equals("ERROR"))) {
						
							break;
						
						} else {
						
							out.println(outputData);
							
						}
						
					}
					
				}
			
			}
												
			RTServer.NORM.info("Closing connection");
			//tidy up
			out.close();
			in.close();
			data.close();
			
		} catch (Exception e) {
			RTServer.NORM.error("Error with connection: " + e.getMessage());
		}
		
	} //EOF run
	
} //EOF TCPServer
