/*
 * FREE 2000
 *
 * Copyright (c) Jason Kitcat, University of Warwick
 *
 * jeep@thecouch.org   http://www.thecouch.org/free/
 *
 * Knoll Cottage, Sutton Place, Nr.Abinger, Dorking, Surrey RH5 6RN United Kingdom
 *
 * Tel: 07956 886 508  Fax: 0870 052 7114
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (gpl.txt); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
 
package Free;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.text.*;

/**
 * The main RTServer status screen.
 *
 * @version 0.4 15 March 2000
 * @author Jason Kitcat
 */
public class RTFrame extends JFrame 
{

	javax.swing.JScrollPane jScrollPane1 = new javax.swing.JScrollPane();
	javax.swing.JTextPane jTextPane1 = new javax.swing.JTextPane();
	javax.swing.JButton jButton1 = new javax.swing.JButton();
	javax.swing.JButton jButton2 = new javax.swing.JButton();


	protected RTFrame() {
		jScrollPane1.setVisible(true);
		jScrollPane1.setPreferredSize(new java.awt.Dimension(330, 210));
		jScrollPane1.setMinimumSize(new java.awt.Dimension(330, 210));
		jScrollPane1.setAlignmentX(LEFT_ALIGNMENT);
		jScrollPane1.getViewport().add(jTextPane1);

		jTextPane1.setVisible(true);
		
		JPanel scrollPanel = new JPanel();
		scrollPanel.setLayout(new BoxLayout(scrollPanel, BoxLayout.Y_AXIS));
		scrollPanel.add(jScrollPane1);
		scrollPanel.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));

		jButton2.setText("Database Console");
		jButton2.setVisible(true);
		jButton2.setToolTipText("Click here to execute SQL commands");

		jButton1.setText("End Vote");
		jButton1.setVisible(false);
		jButton1.setToolTipText("Click to close voting and send results to Totaller");

		JPanel buttonPane = new JPanel();
		buttonPane.setLayout(new BoxLayout(buttonPane, BoxLayout.X_AXIS));
		buttonPane.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
		buttonPane.add(Box.createHorizontalGlue());
		buttonPane.add(jButton2);
		buttonPane.add(Box.createRigidArea(new Dimension(10,0)));
		buttonPane.add(jButton1);

		setLocation(new java.awt.Point(20, 20));
		setTitle("FREE: RTServer");
		setSize(new java.awt.Dimension(352, 260));
		Container contentPane = getContentPane();
		contentPane.add(scrollPanel, BorderLayout.CENTER);
		contentPane.add(buttonPane, BorderLayout.SOUTH);
	
	}

	public void initComponents() throws Exception
	{
		jButton1.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton1ActionPerformed(e);
			}
		});
		jButton2.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton2ActionPerformed(e);
			}
		});
		addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent e) {
				thisWindowClosing(e);
			}
		});
	}
  
  	private boolean mShown = false;
  	
	public void addNotify() 
	{
		super.addNotify();
		
		if (mShown)
			return;
			
		// resize frame to account for menubar
		JMenuBar jMenuBar = getJMenuBar();
		if (jMenuBar != null) {
			int jMenuBarHeight = jMenuBar.getPreferredSize().height;
			Dimension dimension = getSize();
			dimension.height += jMenuBarHeight;
			setSize(dimension);
		}

		mShown = true;
	}

	// Show an informational message (black, plain text)
	protected void showInfo(String msg) {
		SimpleAttributeSet attrs = new SimpleAttributeSet();
		StyleConstants.setForeground(attrs, Color.black);
		showMsg(msg, attrs);
	}
  
	// Show an warning message (red, bold text)
	protected void showError(String msg) {
		SimpleAttributeSet attrs = new SimpleAttributeSet();
		StyleConstants.setForeground(attrs, Color.red);
		StyleConstants.setBold(attrs, true);
		showMsg(msg, attrs);
	}
	
	// Show a text message using the specified AttributeSet
	protected void showMsg(String msg, AttributeSet attrs) {
		Document doc = jTextPane1.getDocument();
		msg += "\n";
		try {
			doc.insertString(doc.getLength(), msg, attrs);
		} catch (BadLocationException ex) {
			ex.printStackTrace();
		}
	}

	// Close the window when the close box is clicked
	void thisWindowClosing(java.awt.event.WindowEvent e)
	{
		RTServer.serv.stopServer();
		
		setVisible(false);
		dispose();
		System.exit(0);
	}
	
	protected void jButton1ActionPerformed(java.awt.event.ActionEvent e) {
		jButton1.setEnabled(false);
		RTServer.serv.stopServer();
		RTServer.NORM.info("Server stopped.");
		RTServer.comms.getTotalVoted();
	}
	
	public void jButton2ActionPerformed(java.awt.event.ActionEvent e) {	
		jButton2.setEnabled(false);
		RTServer.frame3.setVisible(true);
	}
	
	
	
}
