/*
 * FREE 2000
 *
 * Copyright (c) Jason Kitcat, University of Warwick
 *
 * jeep@thecouch.org   http://www.thecouch.org/free/
 *
 * Knoll Cottage, Sutton Place, Nr.Abinger, Dorking, Surrey RH5 6RN United Kingdom
 *
 * Tel: 07956 886 508  Fax: 0870 052 7114
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (gpl.txt); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
 
package Free;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * Asks user to choose mode to run RTServer in.
 *
 * @version 0.5 20 March 2000
 * @author Jason Kitcat
 */
public class Intro extends JFrame 
{
	private final ButtonGroup group = new ButtonGroup();

	javax.swing.JRadioButton jRadioButton1 = new javax.swing.JRadioButton();
	javax.swing.JRadioButton jRadioButton2 = new javax.swing.JRadioButton();
	javax.swing.JLabel jLabel1 = new javax.swing.JLabel();
	javax.swing.JLabel jLabel2 = new javax.swing.JLabel();
	javax.swing.JTextField jTextField1 = new javax.swing.JTextField();
	javax.swing.JButton jButton1 = new javax.swing.JButton();
	javax.swing.JLabel jLabel3 = new javax.swing.JLabel();

	protected Intro()
	{
		group.add(jRadioButton1);
		group.add(jRadioButton2);

		jLabel1.setText("What kind of server is this?");
		jLabel1.setVisible(true);
		jLabel1.setPreferredSize(new java.awt.Dimension(210, 20));
		jLabel1.setMinimumSize(new java.awt.Dimension(210, 20));
		jLabel1.setAlignmentX(LEFT_ALIGNMENT);

		jRadioButton1.setText("Regional Server");
		jRadioButton1.setVisible(true);
		jRadioButton1.setPreferredSize(new java.awt.Dimension(210, 30));
		jRadioButton1.setMinimumSize(new java.awt.Dimension(210, 30));
		jRadioButton1.setAlignmentX(LEFT_ALIGNMENT);
		

		jRadioButton2.setText("Totaller Server");
		jRadioButton2.setVisible(true);
		jRadioButton1.setPreferredSize(new java.awt.Dimension(210, 30));
		jRadioButton1.setMinimumSize(new java.awt.Dimension(210, 30));
		jRadioButton1.setAlignmentX(LEFT_ALIGNMENT);

		jLabel2.setEnabled(false);
		jLabel2.setText("How many regional servers?");
		jLabel2.setVisible(true);
		jLabel2.setPreferredSize(new java.awt.Dimension(200, 20));
		jLabel2.setMinimumSize(new java.awt.Dimension(200, 20));
		jLabel2.setAlignmentX(LEFT_ALIGNMENT);

		jTextField1.setEnabled(false);
		jTextField1.setVisible(true);
		jTextField1.setPreferredSize(new java.awt.Dimension(200, 20));
		jTextField1.setMinimumSize(new java.awt.Dimension(200, 20));
		jTextField1.setAlignmentX(LEFT_ALIGNMENT);

		JPanel jPanel1 = new JPanel();
		jPanel1.setLayout(new BoxLayout(jPanel1, BoxLayout.Y_AXIS));
		jPanel1.add(jLabel1);
		jPanel1.add(Box.createRigidArea(new java.awt.Dimension(0,5)));
		jPanel1.add(jRadioButton1);
		jPanel1.add(Box.createRigidArea(new java.awt.Dimension(0,5)));
		jPanel1.add(jRadioButton2);
		jPanel1.add(Box.createRigidArea(new java.awt.Dimension(0,5)));
		jPanel1.add(jLabel2);
		jPanel1.add(Box.createRigidArea(new java.awt.Dimension(0,5)));
		jPanel1.add(jTextField1);
		jPanel1.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));

		jButton1.setEnabled(false);
		jButton1.setText("OK");
		jButton1.setVisible(true);
		jButton1.setPreferredSize(new java.awt.Dimension(70, 20));
		jButton1.setMinimumSize(new java.awt.Dimension(70, 20));

		jLabel3.setText("You've missed one!");
		jLabel3.setVisible(false);
		jLabel3.setPreferredSize(new java.awt.Dimension(120, 20));
		jLabel3.setMinimumSize(new java.awt.Dimension(120, 20));
		
		JPanel jPanel2 = new JPanel();
		jPanel2.setLayout(new BoxLayout(jPanel2, BoxLayout.X_AXIS));
		jPanel2.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
		jPanel2.add(Box.createHorizontalGlue());
		jPanel2.add(jLabel3);
		jPanel2.add(Box.createRigidArea(new Dimension(10,0)));
		jPanel2.add(jButton1);

		setLocation(new java.awt.Point(20, 20));
		setTitle("FREE: Settings");
		setSize(new java.awt.Dimension(250, 200));
		Container contentPane = getContentPane();
		contentPane.add(jPanel1, BorderLayout.CENTER);
		contentPane.add(jPanel2, BorderLayout.SOUTH);

	}

	public void initComponents() throws Exception
	{


		jRadioButton1.addChangeListener(new javax.swing.event.ChangeListener() {
			public void stateChanged(javax.swing.event.ChangeEvent e) {
				jRadioButton1StateChanged(e);
			}
		});
		jRadioButton2.addChangeListener(new javax.swing.event.ChangeListener() {
			public void stateChanged(javax.swing.event.ChangeEvent e) {
				jRadioButton2StateChanged(e);
			}
		});
		jButton1.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton1ActionPerformed(e);
			}
		});
		addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent e) {
				thisWindowClosing(e);
			}
		});
	}
  
  	private boolean mShown = false;
  	
	public void addNotify() 
	{
		super.addNotify();
		
		if (mShown)
			return;
			
		// resize frame to account for menubar
		JMenuBar jMenuBar = getJMenuBar();
		if (jMenuBar != null) {
			int jMenuBarHeight = jMenuBar.getPreferredSize().height;
			Dimension dimension = getSize();
			dimension.height += jMenuBarHeight;
			setSize(dimension);
		}

		mShown = true;
	}

	// Close the window when the close box is clicked
	void thisWindowClosing(java.awt.event.WindowEvent e)
	{
	}
	
	public void jRadioButton1StateChanged(javax.swing.event.ChangeEvent e) {
		jLabel2.setEnabled(false);
		jTextField1.setEnabled(false);
		jButton1.setEnabled(true);
		RTServer.serverType = 'R';
	}

	public void jRadioButton2StateChanged(javax.swing.event.ChangeEvent e) {
		jLabel2.setEnabled(true);
		jTextField1.setEnabled(true);
		jButton1.setEnabled(true);
		RTServer.serverType = 'T';
	}
		
	public void jButton1ActionPerformed(java.awt.event.ActionEvent e) {
	
			if (RTServer.serverType == 'T') {
				if (jTextField1.getText().equals("")) {
					jLabel3.setVisible(true);
				} else {
					Integer t;
					t = new Integer(jTextField1.getText());
					RTServer.rServers = t.intValue();
					
					setVisible(false);
					RTServer.frame.setVisible(true);

					RTServer.startDaemon();
					dispose();
				}
			} else {
				setVisible(false);
				RTServer.frame.setVisible(true);

				RTServer.startDaemon();
				dispose();
			}
	
	}
				
}
