/*
 * FREE 2000
 *
 * Copyright (c) Jason Kitcat, University of Warwick
 *
 * jeep@thecouch.org   http://www.thecouch.org/free/
 *
 * Knoll Cottage, Sutton Place, Nr.Abinger, Dorking, Surrey RH5 6RN United Kingdom
 *
 * Tel: 07956 886 508  Fax: 0870 052 7114
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (gpl.txt); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
  
package Free;
 
import java.util.*;
import Free.util.*;

/**
 * Processes data from <code>TCPClient</code> to formulate the correct resonses.
 *
 * The source code is extremely readable and provides the best explanation of its function.
 *
 * @version 0.9 14 November 2000
 * @author Jason Kitcat
 */
public class ClientProtocol {

	/**
	 * process analyses packets and responds appropriately
	 *
	 * @param inputData   Contains the contents of a received packet
	 * @returns   String with a packet to return to client
	 * @throws		<code>Exception</code>, all errors are handled by <code>TCPClient</code>
	 *				which has the ability to gracefully close the connection.  
	 */
	protected static String process(String inputData) throws Exception {

		String temp;
		String outputData="";
		
		if (inputData.charAt(0) == 'C') {
			/* confirm */
			Packet p = new Packet(inputData);

			if (AuthSys.checkDigest(p)) {  // tamper check
			
				if (p.getMessage().equals("STAMP")) {
					if (RTServer.comms.getCheck() != null) {
						String data = RTServer.comms.getCheck().toString();
						outputData = "C|" + data + "|" + AuthSys.makeDigest(data) + "\r\n"; // reply with time stamp
					} else {
						RTServer.NORM.error("Total security error.");
						outputData = "ERROR";
					}
				} else if (p.getMessage().equals("OK")) {  // everything went fine
					RTServer.NORM.info("Total confirmed.");
					/* are there any more totals left? */
					if (RTServer.comms.tdCount < (RTServer.comms.totalData.size()-1)) {
						RTServer.comms.tdCount++;  // if so do the next one
						temp = RTServer.comms.getCheck().toString() + "-" + RTServer.comms.totalData.elementAt(RTServer.comms.tdCount);
						outputData = "T|" + temp + "|" + AuthSys.makeDigest(temp) + "\r\n";
					} else {  // otherwise tell them we're all done
						outputData = "T|DONE|" + AuthSys.makeDigest("DONE") + "\r\n";
					}					
				} else if (p.getMessage().equals("DONE")) {  // all totals sent successfully
					outputData = "X|OK|" + AuthSys.makeDigest("OK") + "\r\n";
					RTServer.comms.noCheck(); // just in case, we clear the check date
					RTServer.NORM.info("All totals sent successfully.");
				} else {
					RTServer.NORM.warn("Unrecognized confirm packet received.");
					outputData = "ERROR";
				}
			} else {
				RTServer.NORM.warn("Packet corrupted or altered!");
				outputData = "ERROR";
			}			

		} else if (inputData.charAt(0) == 'D') {
			/* diagnostic */
			Packet p = new Packet(inputData);

			if (AuthSys.checkDigest(p)) {  // tamper check

				RTServer.NORM.info("Diagnostic packet received.");
				outputData = "X|OK|" + AuthSys.makeDigest("OK") + "\r\n";
			
			} else {
				outputData = "ERROR";
				throw new Exception("Packet corrupted or altered!");
			}
							
		} else if (inputData.charAt(0) == 'K') {
			/* AuthKey packet */
			RTServer.NORM.info("AuthKey packet received.");
			Packet p = new Packet(inputData);

			if (AuthSys.checkDigest(p)) {  // tamper check
					// remove key + close connection
				if (DBase.removeKey(p.getMessage())) {
					outputData = "X|OK|" + AuthSys.makeDigest("OK") + "\r\n";
				} else {
					// otherwise it's an error
					outputData = "ERROR";
					throw new Exception("Packet corrupted or altered!");
				}
			} else {
				outputData = "ERROR";
				throw new Exception("Packet corrupted or altered!");
			}

		} else if (inputData.charAt(0) == 'Q') {
			/* verification query */
			Packet p = new Packet(inputData);

			if (AuthSys.checkDigest(p)) {  // tamper check

				DBase.verCheck(new Integer(p.getMessage()).intValue());
				outputData = "X|OK|" + AuthSys.makeDigest("OK") + "\r\n";
				RTServer.comms.sendTotals();
			
			} else {
				outputData = "ERROR";
				throw new Exception("Packet corrupted or altered!");
			}

		} else {
			outputData = "ERROR";
			RTServer.NORM.warn("Unrecognized packet received.");
		}
		
		return outputData;

	} //EOF process()

} //EOF Class