/*
 * FREE 2000
 *
 * Copyright (c) Jason Kitcat, University of Warwick
 *
 * jeep@thecouch.org   http://www.thecouch.org/free/
 *
 * Knoll Cottage, Sutton Place, Nr.Abinger, Dorking, Surrey RH5 6RN United Kingdom
 *
 * Tel: 07956 886 508  Fax: 0870 052 7114
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (gpl.txt); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
  
package ERServer;

import java.net.*;
import java.io.*;
import javax.swing.*;
import java.awt.*;

import com.ibm.log4j.*;

/**
 * Launches the ERServer program and initalises the GUI.
 *
 * The database is also initialised. Additionally the log system
 * is prepared. Logging is done with <code>log4j</code>, more info
 * is available from
 * <a href="http://www.log4j.org">www.log4j.org</a>.
 *
 *
 * @version 0.7  1 November 2000
 * @author Jason Kitcat
 */
public class ERServer 
{
	/* SECURITY NOTE: VERY IMPORTANT! */
	// constant to store value being used as FREE port number
	// For security reasons I recommend this is changed every election
//#ifdef INSTALL
	private static final int freePort = 1111;

	// Swing frames
	protected static ERFrame1 frame;
	protected static ERFrame2 frame2;
	
	// Our server
	protected static TCPServer serv;
	
	// logging categories
	protected static Category NORM;
	protected static Category DEV;

	protected ERServer() 
	{
		try {
			// For native Look and Feel, uncomment the following code.
			/*
			try {
				UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
			} 
			catch (Exception e) { 
			}
			*/
			
			showSplash(4000);
			
			// initiate GUI
			frame = new ERFrame1();
			frame.initComponents();
			frame2 = new ERFrame2();
			frame2.initComponents();
			frame.setVisible(true);

			// init logging system
			ScreenAppender A1 = new ScreenAppender();
			PropertyConfigurator.configure("log4j.erserver.properties");			
			NORM = Category.getInstance("NORM");
			NORM.addAppender(A1);
			/* comment out the DEV portion to reduce log detail */
			DEV = Category.getInstance("DEV");
			DEV.addAppender(A1);
			
			NORM.info("FREE ERServer 0.6 starting up...");
			
			// initialise database
			DBase.init();

			// intialise AuthSys
			AuthKey.init();
				
			// launch TCPServer services
			serv = new TCPServer();
			serv.startServer(freePort);
			
			NORM.info("Server daemon started");
			
		}
		catch (Exception e) {
			e.printStackTrace();
			NORM.error("Startup error: " + e.getMessage());
		}
	}

	// Main entry point
	static protected void main(String[] args) 
	{
		new ERServer();
	}
	
	/**
	 * A simple little method, adatped from O'Reilly's 'Java Swing', to
	 * show a title screen in the centre of the screen for a certain time.
	 *
	 * @param duration  The time to show the screen for
	 */
	protected static void showSplash(int duration) {
		JWindow splash = new JWindow();
		JPanel content = (JPanel)splash.getContentPane();
		
		//set the window's bounds, centering the window
		int width = 400;
		int height = 200;
		Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
		int x = (screen.width-width)/2;
		int y = (screen.height-height)/2;
		splash.setBounds(x,y,width,height);
		
		//build the splash screen
		JLabel label = new JLabel(new ImageIcon("splash.gif"));
		content.add(label, BorderLayout.CENTER);
		
		splash.setVisible(true);
		
		//Wait a while
		try { Thread.sleep(duration); } catch (Exception e) {}
		
		splash.setVisible(false);
		
	} //EOF showSplash

} //EOF Class
