/*
 * Decompiled with CFR 0.152.
 */
package org.hsql;

import java.sql.SQLException;
import org.hsql.Column;
import org.hsql.Expression;
import org.hsql.Record;
import org.hsql.Result;
import org.hsql.TableFilter;
import org.hsql.Trace;

class Select {
    boolean bDistinct;
    TableFilter[] tFilter;
    Expression eCondition;
    Expression[] eColumn;
    int iResultLen;
    int iGroupLen;
    int iOrderLen;
    Select sUnion;
    String sIntoTable;
    int iUnionType;
    static final int UNION = 1;
    static final int UNIONALL = 2;
    static final int INTERSECT = 3;
    static final int EXCEPT = 4;

    void resolve() throws SQLException {
        int n = this.tFilter.length;
        int n2 = 0;
        while (n2 < n) {
            this.resolve(this.tFilter[n2]);
            ++n2;
        }
    }

    void resolve(TableFilter tableFilter) throws SQLException {
        if (this.eCondition != null) {
            this.eCondition.resolve(tableFilter);
            tableFilter.setCondition(this.eCondition);
        }
        int n = this.eColumn.length;
        int n2 = 0;
        while (n2 < n) {
            this.eColumn[n2].resolve(tableFilter);
            ++n2;
        }
    }

    Object getValue(int n) throws SQLException {
        this.resolve();
        Result result = this.getResult(2);
        int n2 = result.getSize();
        int n3 = result.getColumnCount();
        Trace.check(n2 == 1 && n3 == 1, 33);
        Object object = result.rRoot.data[0];
        if (result.iType[0] == n) {
            return object;
        }
        String string = Column.convertObject(object);
        return Column.convertString(string, n);
    }

    Result getResult(int n) throws SQLException {
        int n2;
        Object object;
        Object[] objectArray;
        this.resolve();
        if (this.sUnion != null && this.sUnion.iResultLen != this.iResultLen) {
            throw Trace.error(31);
        }
        int n3 = this.eColumn.length;
        Result result = new Result(n3);
        boolean bl = false;
        boolean bl2 = false;
        int n4 = 0;
        while (n4 < n3) {
            objectArray = this.eColumn[n4];
            result.iType[n4] = objectArray.getDataType();
            if (objectArray.isAggregate()) {
                bl = true;
            }
            ++n4;
        }
        objectArray = null;
        if (bl) {
            objectArray = new Object[n3];
        }
        if (this.iGroupLen > 0) {
            bl2 = true;
        }
        int n5 = 0;
        int n6 = this.tFilter.length;
        boolean[] blArray = new boolean[n6];
        int n7 = 0;
        while (n7 >= 0) {
            boolean bl3;
            object = this.tFilter[n7];
            blArray[n7] = !blArray[n7] ? (bl3 = ((TableFilter)object).findFirst()) : (bl3 = ((TableFilter)object).next());
            if (!bl3) {
                --n7;
                continue;
            }
            if (n7 < n6 - 1) {
                ++n7;
                continue;
            }
            if (this.eCondition != null && !this.eCondition.test()) continue;
            Object[] objectArray2 = new Object[n3];
            n2 = 0;
            while (n2 < n3) {
                objectArray2[n2] = this.eColumn[n2].getValue();
                ++n2;
            }
            if (!bl || bl2) {
                result.add(objectArray2);
                if (n <= 0 || ++n5 < n) continue;
                break;
            }
            ++n5;
            this.updateAggregateRow(objectArray, objectArray2, n3);
        }
        if (bl && !bl2) {
            this.addAggregateRow(result, objectArray, n3, n5);
        } else if (bl2) {
            object = new int[this.iGroupLen];
            int[] nArray = new int[this.iGroupLen];
            int n8 = this.iResultLen;
            n2 = 0;
            while (n2 < this.iGroupLen) {
                object[n2] = n8;
                nArray[n2] = 1;
                ++n8;
                ++n2;
            }
            result = Select.sortResult(result, (int[])object, nArray);
            Record record = result.rRoot;
            Result result2 = new Result(n3);
            int n9 = 0;
            while (n9 < n3) {
                result2.iType[n9] = result.iType[n9];
                ++n9;
            }
            do {
                Object[] objectArray3 = new Object[n3];
                n5 = 0;
                boolean bl4 = false;
                while (record != null && !bl4) {
                    ++n5;
                    int n10 = 0;
                    while (n10 < this.iGroupLen) {
                        if (record.next == null) {
                            bl4 = true;
                        } else if (Column.compare(record.data[n10], record.next.data[n10], result.iType[n10]) != 0) {
                            bl4 = true;
                        }
                        ++n10;
                    }
                    this.updateAggregateRow(objectArray3, record.data, n3);
                    record = record.next;
                }
                this.addAggregateRow(result2, objectArray3, n3, n5);
            } while (record != null);
            result = result2;
        }
        if (this.iOrderLen != 0) {
            object = new int[this.iOrderLen];
            int[] nArray = new int[this.iOrderLen];
            int n11 = this.iResultLen;
            n2 = 0;
            while (n2 < this.iOrderLen) {
                object[n2] = n11;
                nArray[n2] = this.eColumn[n11].isDescending() ? -1 : 1;
                ++n11;
                ++n2;
            }
            result = Select.sortResult(result, (int[])object, nArray);
        }
        result.setColumnCount(this.iResultLen);
        if (this.bDistinct) {
            result = Select.removeDuplicates(result);
        }
        int n12 = 0;
        while (n12 < this.iResultLen) {
            Expression expression = this.eColumn[n12];
            result.sLabel[n12] = expression.getAlias();
            result.sTable[n12] = expression.getTableName();
            result.sName[n12] = expression.getColumnName();
            ++n12;
        }
        if (this.sUnion != null) {
            Result result3 = this.sUnion.getResult(n);
            if (this.iUnionType == 1) {
                result.append(result3);
                result = Select.removeDuplicates(result);
            } else if (this.iUnionType == 2) {
                result.append(result3);
            } else if (this.iUnionType == 3) {
                result = Select.removeDuplicates(result);
                result3 = Select.removeDuplicates(result3);
                result = Select.removeDifferent(result, result3);
            } else if (this.iUnionType == 4) {
                result = Select.removeDuplicates(result);
                result3 = Select.removeDuplicates(result3);
                result = Select.removeSecond(result, result3);
            }
        }
        return result;
    }

    private void updateAggregateRow(Object[] objectArray, Object[] objectArray2, int n) throws SQLException {
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.eColumn[n2].getDataType();
            switch (this.eColumn[n2].getType()) {
                case 40: 
                case 41: 
                case 44: {
                    objectArray[n2] = Column.sum(objectArray[n2], objectArray2[n2], n3);
                    break;
                }
                case 42: {
                    objectArray[n2] = Column.min(objectArray[n2], objectArray2[n2], n3);
                    break;
                }
                case 43: {
                    objectArray[n2] = Column.max(objectArray[n2], objectArray2[n2], n3);
                    break;
                }
                default: {
                    objectArray[n2] = objectArray2[n2];
                    break;
                }
            }
            ++n2;
        }
    }

    private void addAggregateRow(Result result, Object[] objectArray, int n, int n2) throws SQLException {
        int n3 = 0;
        while (n3 < n) {
            int n4 = this.eColumn[n3].getType();
            if (n4 == 44) {
                objectArray[n3] = Column.avg(objectArray[n3], this.eColumn[n3].getDataType(), n2);
            } else if (n4 == 40 && objectArray[n3] == null) {
                objectArray[n3] = new Integer(0);
            }
            ++n3;
        }
        result.add(objectArray);
    }

    private static Result removeDuplicates(Result result) {
        int n = result.getColumnCount();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = n2;
            nArray2[n2] = 1;
            ++n2;
        }
        result = Select.sortResult(result, nArray, nArray2);
        Record record = result.rRoot;
        while (record != null) {
            Record record2 = record.next;
            if (record2 == null) break;
            if (Select.compareRecord(record.data, record2.data, result, n) == 0) {
                record.next = record2.next;
                continue;
            }
            record = record.next;
        }
        return result;
    }

    private static Result removeSecond(Result result, Result result2) {
        int n = result.getColumnCount();
        Record record = result.rRoot;
        Record record2 = result.rRoot;
        boolean bl = true;
        Record record3 = result2.rRoot;
        int n2 = 0;
        while (record != null && record3 != null) {
            n2 = Select.compareRecord(record.data, record3.data, result, n);
            if (n2 == 0) {
                if (bl) {
                    result.rRoot = record.next;
                } else {
                    record2.next = record.next;
                }
                record = record.next;
                continue;
            }
            if (n2 > 0) {
                record3 = record3.next;
                continue;
            }
            record2 = record;
            bl = false;
            record = record.next;
        }
        return result;
    }

    private static Result removeDifferent(Result result, Result result2) {
        int n = result.getColumnCount();
        Record record = result.rRoot;
        Record record2 = result.rRoot;
        boolean bl = true;
        Record record3 = result2.rRoot;
        int n2 = 0;
        while (record != null && record3 != null) {
            n2 = Select.compareRecord(record.data, record3.data, result, n);
            if (n2 == 0) {
                if (bl) {
                    result.rRoot = record;
                } else {
                    record2.next = record;
                }
                bl = false;
                record2 = record;
                record = record.next;
                record3 = record3.next;
                continue;
            }
            if (n2 > 0) {
                record3 = record3.next;
                continue;
            }
            record = record.next;
        }
        if (bl) {
            result.rRoot = null;
        } else {
            record2.next = null;
        }
        return result;
    }

    private static Result sortResult(Result result, int[] nArray, int[] nArray2) {
        if (result.rRoot == null || result.rRoot.next == null) {
            return result;
        }
        Record[] recordArray = new Record[2];
        Record[] recordArray2 = new Record[2];
        int n = 0;
        Record record = result.rRoot;
        while (record != null) {
            Record record2 = record.next;
            record.next = recordArray[n];
            recordArray[n] = record;
            record = record2;
            n ^= 1;
        }
        int n2 = 1;
        while (recordArray[1] != null) {
            Record record3 = recordArray[0];
            Record record4 = recordArray[1];
            recordArray2[1] = null;
            recordArray2[0] = null;
            recordArray[1] = null;
            recordArray[0] = null;
            n = 0;
            while (record3 != null) {
                int n3 = n2;
                int n4 = n2;
                while (true) {
                    if (n3 == 0 || record3 == null) {
                        if (n4 == 0 || record4 == null) break;
                        record = record4;
                        record4 = record4.next;
                        --n4;
                    } else if (n4 == 0 || record4 == null) {
                        record = record3;
                        record3 = record3.next;
                        --n3;
                    } else if (Select.compareRecord(record3.data, record4.data, result, nArray, nArray2) > 0) {
                        record = record4;
                        record4 = record4.next;
                        --n4;
                    } else {
                        record = record3;
                        record3 = record3.next;
                        --n3;
                    }
                    if (recordArray[n] == null) {
                        recordArray[n] = record;
                    } else {
                        recordArray2[n].next = record;
                    }
                    recordArray2[n] = record;
                    record.next = null;
                }
                n ^= 1;
            }
            n2 <<= 1;
        }
        result.rRoot = recordArray[0];
        return result;
    }

    private static int compareRecord(Object[] objectArray, Object[] objectArray2, Result result, int[] nArray, int[] nArray2) {
        int n = Column.compare(objectArray[nArray[0]], objectArray2[nArray[0]], result.iType[nArray[0]]);
        if (n == 0) {
            int n2 = 1;
            while (n2 < nArray.length) {
                n = Column.compare(objectArray[nArray[n2]], objectArray2[nArray[n2]], result.iType[nArray[n2]]);
                if (n != 0) {
                    return n * nArray2[n2];
                }
                ++n2;
            }
        }
        return n * nArray2[0];
    }

    private static int compareRecord(Object[] objectArray, Object[] objectArray2, Result result, int n) {
        int n2 = 0;
        while (n2 < n) {
            int n3 = Column.compare(objectArray[n2], objectArray2[n2], result.iType[n2]);
            if (n3 != 0) {
                return n3;
            }
            ++n2;
        }
        return 0;
    }

    Select() {
    }
}

