/*
 * Decompiled with CFR 0.152.
 */
package org.hsql;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.hsql.Access;
import org.hsql.Channel;
import org.hsql.Column;
import org.hsql.Database;
import org.hsql.Index;
import org.hsql.Node;
import org.hsql.Result;
import org.hsql.Table;
import org.hsql.User;

class DatabaseInformation {
    private Database dDatabase;
    private Access aAccess;
    private Vector tTable;
    static final String META_SCHEM = "SCHEM";
    static final String META_CAT = "CAT";
    static final String META_COLUMN_SIZE = "COLUMN_SIZE";
    static final String META_BUFFER_LENGTH = "BUFFER_LENGTH";
    static final String META_DECIMAL_DIGITS = "DECIMAL_DIGITS";
    static final String META_NUM_PREC_RADIX = "NUM_PREC_RADIX";
    static final String META_FIXED_PREC_SCALE = "FIXED_PREC_SCALE";
    static final String META_ORDINAL_POSITON = "ORDINAL_POSITON";
    static final String META_ASC_OR_DESC = "ASC_OR_DESC";

    DatabaseInformation(Database database, Vector vector, Access access) {
        this.dDatabase = database;
        this.tTable = vector;
        this.aAccess = access;
    }

    Table getSystemTable(String string, Channel channel) throws SQLException {
        if (string.equals("SYSTEM_PROCEDURES")) {
            Table table = new Table(null, string, false);
            table.addColumn("PROCEDURE_CAT", 12);
            table.addColumn("PROCEDURE_SCHEM", 12);
            table.addColumn("PROCEDURE_NAME", 12);
            table.addColumn("NUM_INPUT_PARAMS", 4);
            table.addColumn("NUM_OUTPUT_PARAMS", 4);
            table.addColumn("NUM_RESULT_SETS", 4);
            table.addColumn("REMARKS", 12);
            table.addColumn("PROCEDURE_TYPE", 5);
            table.createPrimaryKey();
            return table;
        }
        if (string.equals("SYSTEM_PROCEDURECOLUMNS")) {
            Table table = new Table(null, string, false);
            table.addColumn("PROCEDURE_CAT", 12);
            table.addColumn("PROCEDURE_SCHEM", 12);
            table.addColumn("PROCEDURE_NAME", 12);
            table.addColumn("COLUMN_NAME", 12);
            table.addColumn("COLUMN_TYPE", 5);
            table.addColumn("DATA_TYPE", 5);
            table.addColumn("TYPE_NAME", 12);
            table.addColumn("PRECISION", 4);
            table.addColumn("LENGTH", 4);
            table.addColumn("SCALE", 5);
            table.addColumn("RADIX", 5);
            table.addColumn("NULLABLE", 5);
            table.addColumn("REMARKS", 12);
            table.createPrimaryKey();
            return table;
        }
        if (string.equals("SYSTEM_TABLES")) {
            Table table = new Table(null, string, false);
            table.addColumn("TABLE_CAT", 12);
            table.addColumn("TABLE_SCHEM", 12);
            table.addColumn("TABLE_NAME", 12);
            table.addColumn("TABLE_TYPE", 12);
            table.addColumn("REMARKS", 12);
            table.createPrimaryKey();
            int n = 0;
            while (n < this.tTable.size()) {
                Table table2 = (Table)this.tTable.elementAt(n);
                Object[] objectArray = table.getNewRow();
                objectArray[2] = table2.getName();
                objectArray[3] = "TABLE";
                table.insert(objectArray, null);
                ++n;
            }
            return table;
        }
        if (string.equals("SYSTEM_SCHEMAS")) {
            Table table = new Table(null, string, false);
            table.addColumn("TABLE_SCHEM", 12);
            table.createPrimaryKey();
            return table;
        }
        if (string.equals("SYSTEM_CATALOGS")) {
            Table table = new Table(null, string, false);
            table.addColumn("TABLE_CAT", 12);
            table.createPrimaryKey();
            return table;
        }
        if (string.equals("SYSTEM_TABLETYPES")) {
            Table table = new Table(null, string, false);
            table.addColumn("TABLE_TYPE", 12);
            table.createPrimaryKey();
            Object[] objectArray = table.getNewRow();
            objectArray[0] = "TABLE";
            table.insert(objectArray, null);
            return table;
        }
        if (string.equals("SYSTEM_COLUMNS")) {
            Table table = new Table(null, string, false);
            table.addColumn("TABLE_CAT", 12);
            table.addColumn("TABLE_SCHEM", 12);
            table.addColumn("TABLE_NAME", 12);
            table.addColumn("COLUMN_NAME", 12);
            table.addColumn("DATA_TYPE", 5);
            table.addColumn("TYPE_NAME", 12);
            table.addColumn(META_COLUMN_SIZE, 4);
            table.addColumn(META_BUFFER_LENGTH, 4);
            table.addColumn(META_DECIMAL_DIGITS, 4);
            table.addColumn(META_NUM_PREC_RADIX, 4);
            table.addColumn("NULLABLE", 4);
            table.addColumn("REMARKS", 12);
            table.addColumn("COLUMN_DEF", 12);
            table.addColumn("SQL_DATA_TYPE", 12);
            table.addColumn("SQL_DATETIME_SUB", 4);
            table.addColumn("CHAR_OCTET_LENGTH", 4);
            table.addColumn("ORDINAL_POSITION", 12);
            table.addColumn("IS_NULLABLE", 12);
            table.createPrimaryKey();
            int n = 0;
            while (n < this.tTable.size()) {
                Table table3 = (Table)this.tTable.elementAt(n);
                int n2 = table3.getColumnCount();
                int n3 = 0;
                while (n3 < n2) {
                    Object[] objectArray = table.getNewRow();
                    objectArray[2] = table3.getName();
                    objectArray[3] = table3.getColumnName(n3);
                    objectArray[4] = new Short((short)table3.getColumnType(n3));
                    objectArray[5] = Column.getType(table3.getColumnType(n3));
                    int n4 = table3.getColumnIsNullable(n3) ? 1 : 0;
                    objectArray[10] = new Integer(n4);
                    if (table3.getIdentityColumn() == n3) {
                        objectArray[11] = "IDENDITY";
                    }
                    table.insert(objectArray, null);
                    ++n3;
                }
                ++n;
            }
            return table;
        }
        if (string.equals("SYSTEM_COLUMNPRIVILEGES")) {
            Table table = new Table(null, string, false);
            table.addColumn("TABLE_CAT", 12);
            table.addColumn("TABLE_SCHEM", 12);
            table.addColumn("TABLE_NAME", 12);
            table.addColumn("COLUMN_NAME", 12);
            table.addColumn("GRANTOR", 12);
            table.addColumn("GRANTEE", 12);
            table.addColumn("PRIVILEGE", 12);
            table.addColumn("IS_GRANTABLE", 12);
            table.createPrimaryKey();
            return table;
        }
        if (string.equals("SYSTEM_TABLEPRIVILEGES")) {
            Table table = new Table(null, string, false);
            table.addColumn("TABLE_CAT", 12);
            table.addColumn("TABLE_SCHEM", 12);
            table.addColumn("TABLE_NAME", 12);
            table.addColumn("GRANTOR", 12);
            table.addColumn("GRANTEE", 12);
            table.addColumn("PRIVILEGE", 12);
            table.addColumn("IS_GRANTABLE", 12);
            table.createPrimaryKey();
            int n = 0;
            while (n < this.tTable.size()) {
                Table table4 = (Table)this.tTable.elementAt(n);
                Object[] objectArray = table.getNewRow();
                objectArray[2] = table4.getName();
                objectArray[3] = "sa";
                objectArray[5] = "FULL";
                table.insert(objectArray, null);
                ++n;
            }
            return table;
        }
        if (string.equals("SYSTEM_BESTROWIDENTIFIER")) {
            Table table = new Table(null, string, false);
            table.addColumn("SCOPE", 5);
            table.addColumn("COLUMN_NAME", 12);
            table.addColumn("DATA_TYPE", 5);
            table.addColumn("TYPE_NAME", 12);
            table.addColumn(META_COLUMN_SIZE, 4);
            table.addColumn(META_BUFFER_LENGTH, 4);
            table.addColumn(META_DECIMAL_DIGITS, 5);
            table.addColumn("PSEUDO_COLUMN", 5);
            table.createPrimaryKey();
            return table;
        }
        if (string.equals("SYSTEM_VERSIONCOLUMNS")) {
            Table table = new Table(null, string, false);
            table.addColumn("SCOPE", 4);
            table.addColumn("COLUMN_NAME", 12);
            table.addColumn("DATA_TYPE", 5);
            table.addColumn("TYPE_NAME", 12);
            table.addColumn(META_COLUMN_SIZE, 5);
            table.addColumn(META_BUFFER_LENGTH, 4);
            table.addColumn(META_DECIMAL_DIGITS, 5);
            table.addColumn("PSEUDO_COLUMN", 5);
            table.createPrimaryKey();
            return table;
        }
        if (string.equals("SYSTEM_PRIMARYKEYS")) {
            Table table = new Table(null, string, false);
            table.addColumn("TABLE_CAT", 12);
            table.addColumn("TABLE_SCHEM", 12);
            table.addColumn("TABLE_NAME", 12);
            table.addColumn("COLUMN_NAME", 12);
            table.addColumn("KEY_SEQ", 5);
            table.addColumn("PK_NAME", 12);
            table.createPrimaryKey();
            int n = 0;
            while (n < this.tTable.size()) {
                Table table5 = (Table)this.tTable.elementAt(n);
                Index index = table5.getIndex("SYSTEM_PK");
                int[] nArray = index.getColumns();
                int n5 = nArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    Object[] objectArray = table.getNewRow();
                    objectArray[2] = table5.getName();
                    objectArray[3] = table5.getColumnName(nArray[n6]);
                    objectArray[4] = new Short((short)(n6 + 1));
                    objectArray[5] = "SYSTEM_PK";
                    table.insert(objectArray, null);
                    ++n6;
                }
                ++n;
            }
            return table;
        }
        if (string.equals("SYSTEM_IMPORTEDKEYS")) {
            Table table = new Table(null, string, false);
            table.addColumn("PKTABLE_CAT", 12);
            table.addColumn("PKTABLE_SCHEM", 12);
            table.addColumn("PKTABLE_NAME", 12);
            table.addColumn("PKCOLUMN_NAME", 12);
            table.addColumn("FKTABLE_CAT", 12);
            table.addColumn("FKTABLE_SCHEM", 12);
            table.addColumn("FKTABLE_NAME", 12);
            table.addColumn("FKCOLUMN_NAME", 12);
            table.addColumn("KEY_SEQ", 5);
            table.addColumn("UPDATE_RULE", 5);
            table.addColumn("DELETE_RULE", 5);
            table.addColumn("FK_NAME", 12);
            table.addColumn("PK_NAME", 12);
            table.addColumn("DEFERRABILITY", 5);
            table.createPrimaryKey();
            return table;
        }
        if (string.equals("SYSTEM_EXPORTEDKEYS")) {
            Table table = new Table(null, string, false);
            table.addColumn("PKTABLE_CAT", 12);
            table.addColumn("PKTABLE_SCHEM", 12);
            table.addColumn("PKTABLE_NAME", 12);
            table.addColumn("PKCOLUMN_NAME", 12);
            table.addColumn("FKTABLE_CAT", 12);
            table.addColumn("FKTABLE_SCHEM", 12);
            table.addColumn("FKTABLE_NAME", 12);
            table.addColumn("FKCOLUMN_NAME", 12);
            table.addColumn("KEY_SEQ", 5);
            table.addColumn("UPDATE_RULE", 5);
            table.addColumn("DELETE_RULE", 5);
            table.addColumn("FK_NAME", 12);
            table.addColumn("PK_NAME", 12);
            table.addColumn("DEFERRABILITY", 5);
            table.createPrimaryKey();
            return table;
        }
        if (string.equals("SYSTEM_CROSSREFERENCE")) {
            Table table = new Table(null, string, false);
            table.addColumn("PKTABLE_CAT", 12);
            table.addColumn("PKTABLE_SCHEM", 12);
            table.addColumn("PKTABLE_NAME", 12);
            table.addColumn("PKCOLUMN_NAME", 12);
            table.addColumn("FKTABLE_CAT", 12);
            table.addColumn("FKTABLE_SCHEM", 12);
            table.addColumn("FKTABLE_NAME", 12);
            table.addColumn("FKCOLUMN_NAME", 12);
            table.addColumn("KEY_SEQ", 4);
            table.addColumn("UPDATE_RULE", 5);
            table.addColumn("DELETE_RULE", 5);
            table.addColumn("FK_NAME", 12);
            table.addColumn("PK_NAME", 12);
            table.addColumn("DEFERRABILITY", 5);
            table.createPrimaryKey();
            return table;
        }
        if (string.equals("SYSTEM_TYPEINFO")) {
            Table table = new Table(null, string, false);
            table.addColumn("TYPE_NAME", 12);
            table.addColumn("DATA_TYPE", 5);
            table.addColumn("PRECISION", 4);
            table.addColumn("LITERAL_PREFIX", 12);
            table.addColumn("LITERAL_SUFFIX", 12);
            table.addColumn("CREATE_PARAMS", 12);
            table.addColumn("NULLABLE", 5);
            table.addColumn("CASE_SENSITIVE", 12);
            table.addColumn("SEARCHABLE", 5);
            table.addColumn("UNSIGNED_ATTRIBUTE", -7);
            table.addColumn(META_FIXED_PREC_SCALE, -7);
            table.addColumn("AUTO_INCREMENT", -7);
            table.addColumn("LOCAL_TYPE_NAME", 12);
            table.addColumn("MINIMUM_SCALE", 5);
            table.addColumn("MAXIMUM_SCALE", 5);
            table.addColumn("SQL_DATE_TYPE", 4);
            table.addColumn("SQL_DATETIME_SUB", 4);
            table.addColumn(META_NUM_PREC_RADIX, 4);
            table.createPrimaryKey();
            int n = 0;
            while (n < Column.TYPES.length) {
                Object[] objectArray = table.getNewRow();
                int n7 = Column.TYPES[n];
                objectArray[0] = Column.getType(n7);
                objectArray[1] = new Short((short)n7);
                objectArray[2] = new Integer(0);
                objectArray[6] = new Short(1);
                objectArray[7] = new Boolean(true);
                objectArray[8] = new Short(3);
                objectArray[9] = new Boolean(false);
                objectArray[10] = new Boolean(n7 == 2 || n7 == 2);
                objectArray[11] = new Boolean(n7 == 4);
                objectArray[12] = objectArray[0];
                objectArray[13] = new Short(0);
                objectArray[14] = new Short(0);
                objectArray[15] = new Short(0);
                objectArray[16] = objectArray[15];
                objectArray[17] = new Integer(10);
                table.insert(objectArray, null);
                ++n;
            }
            return table;
        }
        if (string.equals("SYSTEM_INDEXINFO")) {
            Table table = new Table(null, string, false);
            table.addColumn("TABLE_CAT", 12);
            table.addColumn("TABLE_SCHEM", 12);
            table.addColumn("TABLE_NAME", 12);
            table.addColumn("NON_UNIQUE", -7);
            table.addColumn("INDEX_QUALIFIER", 12);
            table.addColumn("INDEX_NAME", 12);
            table.addColumn("TYPE", 5);
            table.addColumn(META_ORDINAL_POSITON, 5);
            table.addColumn("COLUMN_NAME", 12);
            table.addColumn(META_ASC_OR_DESC, 12);
            table.addColumn("CARDINALITY", 4);
            table.addColumn("PAGES", 4);
            table.addColumn("FILTER_CONDITION", 12);
            table.createPrimaryKey();
            int n = 0;
            while (n < this.tTable.size()) {
                Table table6 = (Table)this.tTable.elementAt(n);
                Index index = null;
                while ((index = table6.getNextIndex(index)) != null) {
                    int[] nArray = index.getColumns();
                    int n8 = nArray.length;
                    if (!index.isUnique()) {
                        --n8;
                    }
                    int n9 = 0;
                    while (n9 < n8) {
                        Object[] objectArray = table.getNewRow();
                        objectArray[2] = table6.getName();
                        objectArray[3] = new Boolean(!index.isUnique());
                        objectArray[5] = index.getName();
                        objectArray[6] = new Short(3);
                        objectArray[7] = new Short((short)(n9 + 1));
                        objectArray[8] = table6.getColumnName(nArray[n9]);
                        objectArray[9] = "A";
                        table.insert(objectArray, null);
                        ++n9;
                    }
                }
                ++n;
            }
            return table;
        }
        if (string.equals("SYSTEM_UDTS")) {
            Table table = new Table(null, string, false);
            table.addColumn("TYPE_CAT", 12);
            table.addColumn("TYPE_SCHEM", 12);
            table.addColumn("TYPE_NAME", 12);
            table.addColumn("CLASS_NAME", -7);
            table.addColumn("DATA_TYPE", 12);
            table.addColumn("REMARKS", 12);
            table.createPrimaryKey();
            return table;
        }
        if (string.equals("SYSTEM_CONNECTIONINFO")) {
            Table table = new Table(null, string, false);
            table.addColumn("KEY", 12);
            table.addColumn("VALUE", 12);
            table.createPrimaryKey();
            Object[] objectArray = table.getNewRow();
            objectArray[0] = "USER";
            objectArray[1] = channel.getUsername();
            table.insert(objectArray, null);
            objectArray = table.getNewRow();
            objectArray[0] = "READONLY";
            objectArray[1] = channel.isReadOnly() ? "TRUE" : "FALSE";
            table.insert(objectArray, null);
            objectArray = table.getNewRow();
            objectArray[0] = "MAXROWS";
            objectArray[1] = String.valueOf(channel.getMaxRows());
            table.insert(objectArray, null);
            return table;
        }
        return null;
    }

    Result getScript(boolean bl, boolean bl2, boolean bl3, Channel channel) throws SQLException {
        Object object;
        Object object2;
        Object object3;
        int n;
        StringBuffer stringBuffer;
        Object[] objectArray;
        Object object4;
        channel.checkAdmin();
        Result result = new Result(1);
        result.iType[0] = 12;
        result.sTable[0] = "SYSTEM_SCRIPT";
        result.sLabel[0] = "COMMAND";
        result.sName[0] = "COMMAND";
        int n2 = 0;
        while (n2 < this.tTable.size()) {
            object4 = (Table)this.tTable.elementAt(n2);
            if (bl) {
                objectArray = new String[]{"DROP TABLE " + ((Table)object4).getName()};
                result.add(objectArray);
            }
            stringBuffer = new StringBuffer("CREATE ");
            if (((Table)object4).isCached()) {
                stringBuffer.append("CACHED ");
            }
            stringBuffer.append("TABLE ");
            stringBuffer.append(((Table)object4).getName());
            stringBuffer.append('(');
            n = ((Table)object4).getColumnCount();
            object3 = ((Table)object4).getIndex("SYSTEM_PK");
            int n3 = object3 == null ? -1 : ((Index)object3).getColumns()[0];
            int n4 = 0;
            while (n4 < n) {
                stringBuffer.append(((Table)object4).getColumnName(n4));
                stringBuffer.append(' ');
                stringBuffer.append(Column.getType(((Table)object4).getType(n4)));
                if (!((Table)object4).getColumnIsNullable(n4)) {
                    stringBuffer.append(" NOT NULL");
                }
                if (n4 == ((Table)object4).getIdentityColumn()) {
                    stringBuffer.append(" IDENTITY");
                }
                if (n4 == n3) {
                    stringBuffer.append(" PRIMARY KEY");
                }
                if (n4 < n - 1) {
                    stringBuffer.append(',');
                }
                ++n4;
            }
            stringBuffer.append(')');
            objectArray = new String[]{stringBuffer.toString()};
            result.add(objectArray);
            object2 = null;
            while ((object2 = ((Table)object4).getNextIndex((Index)object2)) != null) {
                if (((Index)object2).getName().equals("SYSTEM_PK")) continue;
                stringBuffer = new StringBuffer("CREATE ");
                if (((Index)object2).isUnique()) {
                    stringBuffer.append("UNIQUE ");
                }
                stringBuffer.append("INDEX ");
                stringBuffer.append(((Index)object2).getName());
                stringBuffer.append(" ON ");
                stringBuffer.append(((Table)object4).getName());
                stringBuffer.append('(');
                object = ((Index)object2).getColumns();
                int n5 = ((Object)object).length;
                if (!((Index)object2).isUnique()) {
                    --n5;
                }
                int n6 = 0;
                while (n6 < n5) {
                    stringBuffer.append(((Table)object4).getColumnName((int)object[n6]));
                    if (n6 < n5 - 1) {
                        stringBuffer.append(',');
                    }
                    ++n6;
                }
                stringBuffer.append(')');
                objectArray = new String[]{stringBuffer.toString()};
                result.add(objectArray);
            }
            if (bl2) {
                object = ((Table)object4).getPrimaryIndex();
                Node node = ((Index)object).first();
                while (node != null) {
                    objectArray = new String[]{((Table)object4).getInsertStatement(node.getData())};
                    result.add(objectArray);
                    node = ((Index)object).next(node);
                }
            }
            if (bl3 && ((Table)object4).isCached()) {
                stringBuffer = new StringBuffer("SET TABLE ");
                stringBuffer.append(((Table)object4).getName());
                stringBuffer.append(" INDEX '");
                stringBuffer.append(((Table)object4).getIndexRoots());
                stringBuffer.append("'");
                objectArray = new String[]{stringBuffer.toString()};
                result.add(objectArray);
            }
            ++n2;
        }
        object4 = this.aAccess.getUsers();
        n = 0;
        while (n < ((Vector)object4).size()) {
            object3 = (User)((Vector)object4).elementAt(n);
            if (object3 != null) {
                Hashtable hashtable;
                String string = ((User)object3).getName();
                if (!string.equals("PUBLIC")) {
                    stringBuffer = new StringBuffer("CREATE USER ");
                    stringBuffer.append(string);
                    stringBuffer.append(" PASSWORD ");
                    stringBuffer.append("\"" + ((User)object3).getPassword() + "\"");
                    if (((User)object3).isAdmin()) {
                        stringBuffer.append(" ADMIN");
                    }
                    objectArray = new String[]{stringBuffer.toString()};
                    result.add(objectArray);
                }
                if ((hashtable = ((User)object3).getRights()) != null) {
                    object2 = hashtable.keys();
                    while (object2.hasMoreElements()) {
                        object = (String)object2.nextElement();
                        int n7 = (Integer)hashtable.get(object);
                        if (n7 == 0) continue;
                        stringBuffer = new StringBuffer("GRANT ");
                        stringBuffer.append(Access.getRight(n7));
                        stringBuffer.append(" ON ");
                        stringBuffer.append((String)object);
                        stringBuffer.append(" TO ");
                        stringBuffer.append(((User)object3).getName());
                        objectArray = new String[]{stringBuffer.toString()};
                        result.add(objectArray);
                    }
                }
            }
            ++n;
        }
        return result;
    }
}

