/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Rectangle;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.hsql.Profile;
import org.hsql.jdbcDriver;

class SelfTest {
    static String[] sDDL = new String[]{"create table T1(Nr integer)", "create table T2(Nr integer primary Key)", "create table T3(Nr integer,dbl double,vc varchar(10),cc char(1))", "create table T4(nr integer,lvc longVarChar,dt date,tm time)", "create table T5(dec decimal(10) primary key,b bit(1) not null)", "create table \"T6\"(\"x\" tinyint,s smallint not null,b bigint)", "create table t7(\"-x's'-\" real,f float(2),n numeric,t timestamp)", "create table t8(bin binary,vb varbinary,lvb longvarbinary)", "create table t9(nr integer not null,x smallint not null primary key)", "create unique index it1 on t1(nr)", "script", "create index it2 on t2(nr)", "create index it3 on t3(nr,dbl,vc,cc)", "create unique index it4 on t4(nr,lvc,tm)", "drop index t4.it4", "create unique index it4 on t4(nr,tm)", "drop index t4.it4", "create index it4 on t4(tm,nr)", "create index it4b on t4(tm,nr)", "create unique index it4c on t4(tm,nr)", "drop index t4.it4b", "create index it9 on t9(nr,x);", "drop table t1;drop table t2;drop table \"T3\";", "DROP TABLE T4;Drop Table T5; drop table T6", "drop table t7; drop table t8; drop table t9", "", "create user 'test' password 'test-p'", "create table test (id integer)", "revoke all on test to 'test'", "select * from test order by test.id", "grant all on test to 'test'", "grant select on test to 'test'", "revoke select,insert,update,delete on test to 'test'", "connect user 'test' password 'test-p'", "set password 'test-p2'", "connect user 'sa' password ''", "connect user 'test' password 'test-p2'", "connect user 'sa' password ''", "set autocommit false", "insert into test values (1)", "update test set id = 3", "rollback", "insert into test values (2)", "delete from test", "rollback", "commit", "script", "drop table test", "drop user 'test'", "script", "set autocommit true", "create memory table test (id integer)", "drop table test", "create cached table test (id integer null)", "drop table test"};
    static String[] sDML = new String[]{"create table address(nr integer,name varchar,placezip smallint)", "insert into address values(1,'Boss',3000)", "insert into address (nr,name,placezip) values(2,'Walt',8000)", "insert into address values(-3,'',0)", "insert into address select * from address where nr>0", "update address set nr=4 where nr=-2", "insert into address values(3,'x',3000)", "insert into address (name,nr,placezip) values('y',4,8000)", "insert into address (name,nr,placezip) select name,placezip,nr from address where name like 'x%'", "delete from address where name like 'x%'", "update address set name='Rene' where nr=4", "update address set nr=5, name='What' where nr=1 and name='Boss'", "create table place(zip smallint,name longvarchar,country char)", "insert into place values(3000,'Langenthal\t1','CH')", "insert into place values(0,'\\\\Heaven',null)", "insert into place values(8000,'Z\u00fcrich','CH')", "insert into place values(-1,'NULL','null')", "create table invoice(addressnr integer,total decimal)", "insert into invoice values(4,1003834.05)", "insert into invoice values(2,-4987770.01)", "insert into invoice select * from invoice where not total>=0.", "update invoice set total=10 where total < 0", "insert into invoice values(2,10)", "select * from system_tables", "select * from SYSTEM_CONNECTIONINFO", "create table t_double(id integer,d double,f double)", "insert into t_double values(1,1.2,1.4)", "insert into t_double values(2,1.4,1.0)", "create table t_date (id integer,d date,t time,ts timestamp )", "insert into t_DATE values(0,{d '1999-08-21'},'18:53:00',null)", "insert into t_date values(1,'1999-08-22','17:00:01','2000-02-29 10:00:00')", "create table t_bit (b1 bit,b2 bit)", "insert into t_bit values(false,false)", "insert into t_bit select b2,b1 from t_bit", "insert into t_bit values(true,false)", "insert into t_bit values(true,true)", "create table Problem(Nr bigint,ClassNr bigint,StateNr bigint,Name varchar);", "create table Class(Nr bigint, Name varchar, Node varchar);", "insert into Problem values(10, 1, 3, 'Problem 10; Class 1; State 3');", "insert into Problem values(20, 2, 2, 'Problem 20; Class 2; State 2');", "insert into Problem values(30, 3, 2, 'Problem 30; Class 3; State 2');", "insert into Class values(1, 'Class/State 1','Node A');", "insert into Class values(2, 'Class/State 2','Node B');", "insert into Class values(3, 'Class/State 3','Node C');", "CREATE CACHED TABLE HLO(NRO INTEGER,NIMI VARCHAR,PTMP INTEGER)", "CREATE INDEX INRO ON HLO(NRO)", "INSERT INTO HLO VALUES(1,'hlo 1',0)", "INSERT INTO HLO VALUES(2,'hlo 2',0)", "INSERT INTO HLO VALUES(3,'hlo 3',0)", "INSERT INTO HLO VALUES(4,'hlo 4',0)", "INSERT INTO HLO VALUES(5,'hlo 5',0)", "insert into hlo values(10,'10',0);", "delete from hlo where nro=10;", "DROP TABLE HLO"};
    static String[] sSelect = new String[]{"6", "select * from address", "4", "select * from place", "4", "select * from invoice", "1", "select nr from address where nr<0", "0", "select * from address where nr>=0 and nr<=0", "1", "select count(*) from address where nr=-99", "0", "select * from address where not name like '%'", "1", "select * from address,place p where (nr=4) and p.zip=placezip", "1", "select * from address,place p where (nr=4 or nr>3 and nr<2) and p.zip=placezip or (p.zip>0 and p.zip<-1 or p.zip=-2)", "1", "select * from address a,place p,invoice i where a.placezip=p.zip and a.nr=i.addressnr and i.addressnr=4", "1", "select p.zip,p.*,country from address a,place p,invoice i where a.placezip=p.zip and a.nr=i.addressnr and i.addressnr=4", "7", "select * from address union all select * from address where nr=4", "1", "select max(place.zip) x from place", "0", "select * from address where name like 'Wal_' escape 'l'", "2", "select * from address where name like 'Wal_' escape '+'", "4", "select total as x from invoice order by addressnr desc,total asc", "4", "select place.* from place where not country = 'NULL' and not name is null and not name is NULL and not name = 'null' and not country = 'NULL' order by zip", "3", "select * from address where nr in (1,5,99,5,4)", "1", "select * from (select * from address) as address where nr=4", "6", "select p1.country from place p1,place p2 where p1.country=p2.country", "1", "select * from t_double where id>-10 and d>1.3 and d>.3", "2", "select * from t_double where d>-20 or f<10.2", "2", "select d,t,d from t_date where d>'1900-08-21';", "1", "select d,*,d from t_date where ts>'2000-01-01 00:00:00'", "0", "select t_date.*,* from t_date where t<='01:00:00'", "2", "select * from t_bit where b1<=false or b2>true", "2", "select * from t_bit where not(b1<=false or b2>true)", "2", "select P.*, C.Name ClassName from Problem P,Class C where P.Nr in(10,20) and P.ClassNr=C.Nr", "1", "select P.*, S.Name StateName, S.Node StateNode, C.Name ClassName, C.Node ClassNode from Problem P, Class S, Class C where P.Nr = 10 and P.ClassNr = C.Nr and P.StateNr = S.Nr"};
    static String[] sResult = new String[]{"0", "create table test(nr integer,name char(10));select count(*) from test", "1", "insert into test values(1,null);select nr from test group by nr", "2", "update test set nr=2;select avg(nr) from test", "3", "update test set nr=1+1*2;select sum(nr) from test", "-3", "update test set nr=-(select max(t2.nr) from test t2);select nr from test", "4", "update test set nr=2*(1--1);select nr from test", "4", "select sum(nr) from test where nr in(select t2.nr from test t2)", null, "update test set nr=1/0;select nr from test", null, "update test set nr=8/(1+(null*3)-1);select nr from test", "2", "update test set nr=4/2;select \"TEST\".\"NR\" from test", "34", "update test set name='3' || '4';select distinct name from test", "x", "update test set name=null || 'x' || null;select name from \"TEST\"", "Ho", "select 'Ho' as hhoo from TEsT where name in ('x','y',null)"};
    static String[] sError = new String[]{"+", "select nr from address union select nr,nr from address", "create something", "create index x on address (nr +", "create table p2 (id integer primary key, id2 integer primary key)", "create table p3 (id integer primary key + 2)", "drop index x", "drop all", "create table test(nr integer); insert into test values (10 and)", "create table test(nr integer)", "create user 'test' password 'test';connect user 'test' password 'test';select * from test;", "connect user 'sa' password ''; drop user 'test'; drop it now", "insert into test values(1);insert into test rows", "create unique index i1 on test(id);select * from (oh what)", "insert into test values(2); update test set id=1;", "select * from test where id in (1 (2) 3)", "select o.* from test", "select * from test where id like '0' escape 'maybe'", "insert into test (nr and so on) values (1)", "insert into test values (select * from test union select * from test)", "update test set nr=1+(3+5 'x'", "update test set nr=1.....3", "select *.* from test", "select * from test where id>2 and (id>3;", "select * from test order it", "creat unique index 1", "select id from test where yes>2;", "select id from test where id has 5", "drop table test; grant access", "connect user or maybe not", "set parameter", "set autocommit and", "select column as column plus", "select * from hm", "grant all about it", "create table wrong(id usertype)", "select #strange#"};
    static String[] sFinish = new String[]{"drop table address drop table place drop table invoice", "drop table t_double;drop table t_date drop table t_bit", "drop table problem; drop table class"};

    public static void main(String[] stringArray) {
        String string;
        SelfTest.print("Usage: SelfTest [records [-m]] (-m means in-memory only)");
        int n = 500;
        if (stringArray.length >= 1) {
            n = Integer.parseInt(stringArray[0]);
        }
        boolean bl = true;
        if (stringArray.length >= 2 && (string = stringArray[1]).equals("-m")) {
            bl = false;
        }
        SelfTest.test(n, bl);
    }

    static void test(int n, boolean bl) {
        try {
            DriverManager.registerDriver(new jdbcDriver());
            if (bl) {
                SelfTest.delete("test2.backup");
                SelfTest.delete("test2.properties");
                SelfTest.delete("test2.script");
                SelfTest.delete("test2.data");
                SelfTest.test("Persistent", "jdbc:HypersonicSQL:test2", "sa", "", n, true);
            }
            SelfTest.test("In-Memory", "jdbc:HypersonicSQL:.", "sa", "", n, false);
            Profile.listUnvisited();
            return;
        }
        catch (Exception exception) {
            SelfTest.print("SelfTest error: " + exception.getMessage());
            exception.printStackTrace();
            return;
        }
    }

    static void delete(String string) {
        try {
            new File(string).delete();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    static void test(String string, String string2, String string3, String string4, int n, boolean bl) throws Exception {
        SelfTest.print(string);
        Statement statement = null;
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(string2, string3, string4);
            statement = connection.createStatement();
        }
        catch (Exception exception) {
            SelfTest.print("SelfTest init error: " + exception.getMessage());
        }
        String string5 = "";
        boolean bl2 = false;
        try {
            int n2;
            Object object;
            Object object2;
            int n3;
            int n4;
            int n5 = 0;
            while (n5 < sDDL.length) {
                string5 = sDDL[n5];
                statement.execute(string5);
                ++n5;
            }
            ResultSet resultSet = statement.executeQuery("SCRIPT");
            if (resultSet.next() && !(string5 = resultSet.getString(1)).startsWith("CREATE USER")) {
                bl2 = true;
            }
            int n6 = 0;
            while (n6 < sDML.length) {
                string5 = sDML[n6];
                statement.execute(string5);
                ++n6;
            }
            string5 = "CREATE TABLE marotest (id int PRIMARY KEY, dat int);INSERT INTO marotest VALUES (1,0);INSERT INTO marotest VALUES (2,0);INSERT INTO marotest VALUES (2,0);";
            try {
                statement.execute(string5);
                string5 = "";
            }
            catch (Exception exception) {}
            if (string5.equals("")) {
                throw new Exception("Duplicate key gave no error on insert");
            }
            try {
                string5 = "UPDATE marotest SET id=1, dat=-1 WHERE dat=0";
                statement.execute(string5);
                string5 = "";
            }
            catch (Exception exception) {}
            if (string5.equals("")) {
                throw new Exception("Duplicate key gave no error on update");
            }
            int n7 = 0;
            string5 = "SELECT *, id as marotest_id FROM marotest";
            resultSet = statement.executeQuery(string5);
            while (resultSet.next()) {
                resultSet.getFloat(1);
                resultSet.getString("id");
                resultSet.getInt("DaT");
                resultSet.getInt("marotest_id");
                if (resultSet.getShort("dat") != 0) {
                    throw new Exception("Bad update worked");
                }
                resultSet.getLong("DAT");
                resultSet.getString(2);
                resultSet.getObject("ID");
                resultSet.clearWarnings();
                try {
                    resultSet.getTimestamp("Timestamp?");
                    n7 = 99;
                }
                catch (Exception exception) {}
                ++n7;
            }
            resultSet.close();
            if (n7 != 2) {
                throw new Exception("Should have 2 but has " + n7 + " rows");
            }
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            resultSet = databaseMetaData.getColumns(null, "dbo", "MAROTEST", "%");
            while (resultSet.next()) {
                string5 = resultSet.getString(4).trim();
                n4 = resultSet.getInt(5);
                string5 = String.valueOf(string5) + n4 + resultSet.getString("TYPE_NAME");
                n4 = resultSet.getInt(7);
                n4 = resultSet.getInt(9);
                n4 = resultSet.getInt(11);
                if ((string5 = string5.toUpperCase()).equals("ID4INTEGER") || string5.equals("DAT4INTEGER")) continue;
                throw new Exception("Wrong database meta data");
            }
            string5 = "DROP TABLE marotest";
            statement.execute(string5);
            n4 = 0;
            while (n4 < sSelect.length) {
                n3 = Integer.parseInt(sSelect[n4++]);
                n7 = 0;
                string5 = sSelect[n4];
                resultSet = statement.executeQuery(string5);
                while (resultSet.next()) {
                    ++n7;
                }
                if (n7 != n3) {
                    throw new Exception("Should have " + n3 + " but has " + n7 + " rows:" + string5);
                }
                ++n4;
            }
            n3 = 0;
            while (n3 < sResult.length) {
                object2 = sResult[n3++];
                n7 = 0;
                string5 = sResult[n3];
                resultSet = statement.executeQuery(string5);
                resultSet.next();
                object = resultSet.getString(1);
                if (object2 == null) {
                    if (!resultSet.wasNull()) {
                        throw new Exception("Should be null");
                    }
                } else if (!((String)object2).equals(object)) {
                    throw new Exception("Should be " + (String)object2 + " but is " + (String)object);
                }
                if (resultSet.next()) {
                    throw new Exception("More than 1 row");
                }
                ++n3;
            }
            string5 = "create table TabProfile(id int primary key,car char,won bit,licence varbinary,name char,sex char,chance double,birthday date)";
            statement.execute(string5);
            string5 = "insert into TabProfile values ( ?, ?, ?, ?,'\"John\" the bird''s best friend', 'M',?,?);";
            object2 = connection.prepareStatement(string5);
            object2.clearParameters();
            object2.setInt(1, 10);
            object2.setString(2, "Matchcartoon");
            object2.setBoolean(3, true);
            byte[] byArray = new byte[5];
            byArray[1] = 1;
            byArray[2] = -128;
            byArray[3] = 44;
            byArray[4] = 12;
            object = byArray;
            object2.setBytes(4, (byte[])object);
            object2.setDouble(5, 50.5);
            object2.setNull(6, 91);
            object2.executeUpdate();
            object2.clearParameters();
            object2.setInt(1, -2);
            object2.setString(2, "\"Birdie\"'s car");
            object2.setBoolean(3, false);
            byte[] byArray2 = new byte[]{10, 127};
            object2.setBytes(4, byArray2);
            object2.setDouble(5, -3.1415E-20);
            object2.setDate(6, new Date(100, 1, 29));
            object2.executeUpdate();
            string5 = "drop table TabProfile";
            statement.execute(string5);
            string5 = "create table obj(id int,o object)";
            statement.execute(string5);
            string5 = "insert into obj values(?,?)";
            object2 = connection.prepareStatement(string5);
            object2.setInt(1, 1);
            int[] nArray = new int[]{1, 2, 3};
            object2.setObject(2, nArray);
            object2.executeUpdate();
            object2.clearParameters();
            object2.setInt(1, 2);
            Rectangle rectangle = new Rectangle(10, 11, 12, 13);
            object2.setObject(2, rectangle);
            object2.executeUpdate();
            resultSet = statement.executeQuery("SELECT o FROM obj ORDER BY id DESC");
            resultSet.next();
            Rectangle rectangle2 = (Rectangle)resultSet.getObject(1);
            if (rectangle2.x != 10 || rectangle2.y != 11 || rectangle2.width != 12 || rectangle2.height != 13) {
                throw new Exception("Object data error: Rectangle");
            }
            resultSet.next();
            int[] nArray2 = (int[])resultSet.getObject(1);
            if (nArray2[0] != 1 || nArray2[1] != 2 || nArray2[2] != 3 || nArray2.length != 3) {
                throw new Exception("Object data error: int[]");
            }
            string5 = "drop table obj";
            statement.execute(string5);
            int n8 = 0;
            while (n8 < sError.length) {
                string5 = sError[n8];
                n2 = 0;
                try {
                    statement.execute(string5);
                }
                catch (Exception exception) {
                    n2 = 1;
                }
                if (n2 == 0) {
                    throw new Exception("Should be an error");
                }
                ++n8;
            }
            string5 = "CREATE CACHED TABLE Addr(ID INT PRIMARY KEY,First CHAR,Name CHAR,ZIP INT)";
            statement.execute(string5);
            string5 = "CREATE INDEX iName ON Addr(Name)";
            statement.execute(string5);
            long l = System.currentTimeMillis();
            n2 = 0;
            while (n2 < n) {
                string5 = "INSERT INTO Addr VALUES(" + n2 + ",'Marcel" + n2 + "'," + "'Renggli" + (n - n2 - n2 % 31) + "'," + (3000 + n2 % 100) + ")";
                if (statement.executeUpdate(string5) != 1) {
                    throw new Exception("Insert failed");
                }
                if (n2 % 100 == 0) {
                    SelfTest.printStatus("inserting", n2, n, l);
                }
                ++n2;
            }
            SelfTest.printStatus("insert   ", n, n, l);
            SelfTest.print("");
            if (bl) {
                connection.close();
                connection = DriverManager.getConnection(string2, string3, string4);
                statement = connection.createStatement();
            }
            l = System.currentTimeMillis();
            int n9 = 0;
            while (n9 < n) {
                string5 = "UPDATE Addr SET Name='Robert" + (n9 + n9 % 31) + "' WHERE ID=" + n9;
                if (statement.executeUpdate(string5) != 1) {
                    throw new Exception("Update failed");
                }
                if (n9 % 100 == 0) {
                    SelfTest.printStatus("updated  ", n9, n, l);
                }
                ++n9;
            }
            SelfTest.printStatus("update   ", n, n, l);
            SelfTest.print("");
            if (bl) {
                string5 = "SHUTDOWN IMMEDIATELY";
                statement.execute(string5);
                connection.close();
                connection = DriverManager.getConnection(string2, string3, string4);
                statement = connection.createStatement();
            }
            l = System.currentTimeMillis();
            int n10 = 0;
            while (n10 < n) {
                string5 = "DELETE FROM Addr WHERE ID=" + (n - 1 - n10);
                if (statement.executeUpdate(string5) != 1) {
                    throw new Exception("Delete failed");
                }
                if (n10 % 100 == 0) {
                    SelfTest.printStatus("deleting ", n10, n, l);
                }
                ++n10;
            }
            SelfTest.printStatus("delete   ", n, n, l);
            SelfTest.print("");
            statement.execute("DROP TABLE Addr");
            int n11 = 0;
            while (n11 < sFinish.length) {
                string5 = sFinish[n11];
                statement.execute(string5);
                ++n11;
            }
            resultSet = statement.executeQuery("SCRIPT");
            while (resultSet.next()) {
                string5 = resultSet.getString(1);
                if (string5.startsWith("CREATE USER")) continue;
                bl2 = true;
            }
            if (bl2) {
                throw new Exception("Not all tables are dropped");
            }
            SelfTest.print("Test finished successfully");
        }
        catch (Exception exception) {
            SelfTest.print("");
            SelfTest.print("SelfTest error: " + exception);
            SelfTest.print("with SQL command: " + string5);
            exception.printStackTrace();
        }
        try {
            int n12 = 0;
            while (n12 < sFinish.length) {
                string5 = sFinish[n12];
                statement.execute(string5);
                ++n12;
            }
        }
        catch (Exception exception) {}
        connection.close();
    }

    static void printStatus(String string, int n, int n2, long l) {
        System.out.print(String.valueOf(string) + ": " + n + "/" + n2 + " " + 100 * n / n2 + "% ");
        long l2 = System.currentTimeMillis();
        if (l2 > l) {
            System.out.print((long)(n * 1000) / (l2 - l));
        }
        System.out.print(" rows/s                \r");
    }

    private static void print(String string) {
        System.out.println(string);
    }

    SelfTest() {
    }
}

